/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import com.clarkparsia.pellet.datatypes.types.floating.FloatingPointUtils;
import org.junit.Assert;
import org.junit.Test;

public class FloatingPointUtilsTests {
    @Test
    public void decrementNeg() {
        Assert.assertEquals((Object)Float.valueOf(Float.intBitsToFloat(-2147483640)), (Object)FloatingPointUtils.decrement((Float)Float.valueOf(Float.intBitsToFloat(-2147483641))));
        Assert.assertEquals((Object)Double.longBitsToDouble(-9223372036854775800L), (Object)FloatingPointUtils.decrement((Double)Double.longBitsToDouble(-9223372036854775801L)));
    }

    @Test
    public void decrementNegInf() {
        Assert.assertTrue((boolean)FloatingPointUtils.decrement((Float)Float.valueOf(Float.NEGATIVE_INFINITY)).isInfinite());
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)FloatingPointUtils.decrement((Float)Float.valueOf(Float.NEGATIVE_INFINITY)));
        Assert.assertTrue((boolean)FloatingPointUtils.decrement((Double)Double.NEGATIVE_INFINITY).isInfinite());
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)FloatingPointUtils.decrement((Double)Double.NEGATIVE_INFINITY));
    }

    @Test
    public void decrementPos() {
        Assert.assertEquals((Object)Float.valueOf(Float.intBitsToFloat(6)), (Object)FloatingPointUtils.decrement((Float)Float.valueOf(Float.intBitsToFloat(7))));
        Assert.assertEquals((Object)Double.longBitsToDouble(6L), (Object)FloatingPointUtils.decrement((Double)Double.longBitsToDouble(7L)));
    }

    @Test
    public void decrementToNegInf() {
        Number oneMore = Float.valueOf(Float.intBitsToFloat(-8388609));
        Assert.assertFalse((boolean)((Float)oneMore).isInfinite());
        Assert.assertTrue((boolean)FloatingPointUtils.decrement((Float)oneMore).isInfinite());
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)FloatingPointUtils.decrement((Float)oneMore));
        oneMore = Double.longBitsToDouble(-4503599627370497L);
        Assert.assertFalse((boolean)((Double)oneMore).isInfinite());
        Assert.assertTrue((boolean)FloatingPointUtils.decrement((Double)oneMore).isInfinite());
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)FloatingPointUtils.decrement((Double)oneMore));
    }

    @Test
    public void incrementNeg() {
        Assert.assertEquals((Object)Float.valueOf(Float.intBitsToFloat(-2147483642)), (Object)FloatingPointUtils.increment((Float)Float.valueOf(Float.intBitsToFloat(-2147483641))));
        Assert.assertEquals((Object)Double.longBitsToDouble(-9223372036854775802L), (Object)FloatingPointUtils.increment((Double)Double.longBitsToDouble(-9223372036854775801L)));
    }

    @Test
    public void incrementNegZero() {
        Assert.assertNotSame((Object)Float.valueOf("0.0"), (Object)Float.valueOf("-0.0"));
        Assert.assertEquals((Object)Float.valueOf("0.0"), (Object)FloatingPointUtils.increment((Float)Float.valueOf("-0.0")));
        Assert.assertNotSame((Object)Double.valueOf("0.0"), (Object)Double.valueOf("-0.0"));
        Assert.assertEquals((Object)Double.valueOf("0.0"), (Object)FloatingPointUtils.increment((Double)Double.valueOf("-0.0")));
    }

    @Test
    public void incrementPos() {
        Assert.assertEquals((Object)Float.valueOf(Float.intBitsToFloat(8)), (Object)FloatingPointUtils.increment((Float)Float.valueOf(Float.intBitsToFloat(7))));
        Assert.assertEquals((Object)Double.longBitsToDouble(8L), (Object)FloatingPointUtils.increment((Double)Double.longBitsToDouble(7L)));
    }

    @Test
    public void incrementPosInf() {
        Assert.assertTrue((boolean)FloatingPointUtils.increment((Float)Float.valueOf(Float.POSITIVE_INFINITY)).isInfinite());
        Assert.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)FloatingPointUtils.increment((Float)Float.valueOf(Float.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)FloatingPointUtils.increment((Double)Double.POSITIVE_INFINITY).isInfinite());
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)FloatingPointUtils.increment((Double)Double.POSITIVE_INFINITY));
    }

    @Test
    public void incrementToPosInf() {
        Number oneLess = Float.valueOf(Float.intBitsToFloat(0x7F7FFFFF));
        Assert.assertFalse((boolean)((Float)oneLess).isInfinite());
        Assert.assertTrue((boolean)FloatingPointUtils.increment((Float)oneLess).isInfinite());
        Assert.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)FloatingPointUtils.increment((Float)oneLess));
        oneLess = Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL);
        Assert.assertFalse((boolean)((Double)oneLess).isInfinite());
        Assert.assertTrue((boolean)FloatingPointUtils.increment((Double)oneLess).isInfinite());
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)FloatingPointUtils.increment((Double)oneLess));
    }
}

