/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.classification;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;

public class SimpleClassificationTests
extends AbstractKBTests {
    public static Test suite() {
        return new JUnit4TestAdapter(SimpleClassificationTests.class);
    }

    @org.junit.Test
    public void cdClassificationWithInverses() {
        this.classes(C, D, E);
        this.objectProperties(p);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.kb.addSubClass(D, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)E));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSubClassOf(C, E));
        this.kb.classify();
        Assert.assertTrue((boolean)this.kb.isSubClassOf(C, E));
    }

    @org.junit.Test
    public void cdClassificationWithCyclicInverses() {
        this.classes(C, D, E);
        this.objectProperties(p, q);
        this.kb.addSubClass(E, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)D));
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)q, (ATermAppl)E));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSubClassOf(E, D));
        this.kb.classify();
        Assert.assertTrue((boolean)this.kb.isSubClassOf(E, D));
    }

    @org.junit.Test
    public void cdClassificationWithPropChain() {
        this.classes(C, D, E);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)D)));
        this.kb.addSubClass(D, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)E));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSubClassOf(C, E));
        this.kb.classify();
        this.kb.printClassTree();
        Assert.assertTrue((boolean)this.kb.isSubClassOf(C, E));
    }
}

