/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.jena;

import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class ConcurrencyTest {
    private static final String ONTOLOGY_PATH_ = "/test/data/concurrency/vicodi.ttl";
    private static final int THREAD_NUMBER = 10;
    private static final Iterable<Individual> POISON = Collections.emptyList();
    private static final int BATCH_SIZE = 10;

    @Test
    public void concurrentDLQueries() throws Exception {
        System.err.println("Loading the ontology");
        OntModel ontModel = this.loadOntologyModel(ONTOLOGY_PATH_);
        System.err.println("Realizing the ontology");
        ((PelletInfGraph)ontModel.getGraph()).realize();
        ArrayBlockingQueue<Iterable<Individual>> toDo = new ArrayBlockingQueue<Iterable<Individual>>(20);
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            pool.execute(new QueryRunner(ontModel, toDo));
        }
        ExtendedIterator individuals = ontModel.listIndividuals();
        while (individuals.hasNext()) {
            ArrayList<Individual> batch = new ArrayList<Individual>(10);
            for (int i = 0; i < 10 && individuals.hasNext(); ++i) {
                Individual ind = (Individual)individuals.next();
                batch.add(ind);
            }
            if (batch.isEmpty()) continue;
            toDo.put(batch);
        }
        for (int i = 0; i < 10; ++i) {
            toDo.put(POISON);
        }
        pool.shutdown();
        pool.awaitTermination(100L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OntModel loadOntologyModel(String ontologyPath) throws IOException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        InputStream ontStream = null;
        try {
            ontStream = ConcurrencyTest.class.getResourceAsStream(ontologyPath);
            model.read(ontStream, null, "TTL");
        }
        finally {
            if (ontStream != null) {
                ontStream.close();
            }
        }
        return model;
    }

    static /* synthetic */ Iterable access$000() {
        return POISON;
    }

    private static class QueryRunner
    implements Runnable {
        private final OntModel model_;
        private final BlockingQueue<Iterable<Individual>> toDo_;

        QueryRunner(OntModel model, BlockingQueue<Iterable<Individual>> toDo) {
            this.model_ = model;
            this.toDo_ = toDo;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 5[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void printIterator(Iterator<?> iterator, String threadId) {
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    try {
                        System.err.println(threadId + ": " + iterator.next());
                    }
                    catch (ConversionException conversionException) {}
                }
            }
        }
    }
}

