/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.jena;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL2;
import java.io.FileNotFoundException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class MiscTests {
    private OntModel model;

    public static void configurePelletOptions() {
        PelletOptions.PROCESS_JENA_UPDATES_INCREMENTALLY = false;
        PelletOptions.ALWAYS_REBUILD_RETE = false;
        PelletOptions.USE_UNIQUE_NAME_ASSUMPTION = true;
        PelletOptions.USE_COMPLETION_QUEUE = false;
        PelletOptions.AUTO_REALIZE = false;
    }

    @Test
    public void dataAssertionTest() throws FileNotFoundException {
        this.model.read(this.getClass().getClassLoader().getResourceAsStream("test/data/misc/decimal-int.owl"), null);
        Individual entity = this.model.getIndividual("http://www.inmindcomputing.com/example/dataAssertion.owl#ENTITY");
        DatatypeProperty value = this.model.getDatatypeProperty("http://www.inmindcomputing.com/example/dataAssertion.owl#dataAssertionValue");
        Assert.assertTrue((boolean)value.isFunctionalProperty());
        Assert.assertEquals((long)1L, (long)entity.listPropertyValues((Property)value).toSet().size());
    }

    @Test
    public void incrementalDeletionTest() throws FileNotFoundException {
        Individual entity = this.model.createIndividual("http://www.inmindcomputing.com/example/dataAssertion.owl#ENTITY", null);
        DatatypeProperty property = this.model.createDatatypeProperty("http://www.inmindcomputing.com/example/dataAssertion.owl#ENTITY", true);
        Statement firstValue = this.model.createLiteralStatement((Resource)entity, (Property)property, (Object)"1");
        Statement secondValue = this.model.createLiteralStatement((Resource)entity, (Property)property, (Object)"2");
        this.model.prepare();
        this.model.add(firstValue);
        this.model.remove(firstValue);
        this.model.add(secondValue);
        try {
            this.model.listObjectsOfProperty((Property)property).toSet();
        }
        catch (InconsistentOntologyException e) {
            Assert.fail((String)"Both values are contained in the knowledge base.");
        }
    }

    @Before
    public void setUp() throws Exception {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        MiscTests.configurePelletOptions();
    }

    @After
    public void tearDown() throws Exception {
        this.model.close();
    }

    @Test
    public void universalTest() throws FileNotFoundException {
        this.model.read(this.getClass().getClassLoader().getResourceAsStream("test/data/misc/universal-property.owl"), null);
        ObjectProperty universal = this.model.getObjectProperty("http://www.inmindcomputing.com/example/universal.owl#universalProperty");
        ObjectProperty abstracT = this.model.getObjectProperty("http://www.inmindcomputing.com/example/universal.owl#abstractProperty");
        ObjectProperty concrete = this.model.getObjectProperty("http://www.inmindcomputing.com/example/universal.owl#concreteProperty");
        Assert.assertTrue((boolean)universal.getEquivalentProperty().equals(OWL2.topObjectProperty));
        Assert.assertTrue((boolean)universal.listSubProperties().toSet().contains(abstracT));
        Assert.assertTrue((boolean)universal.listSubProperties().toSet().contains(concrete));
    }
}

