/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.owlapi;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.test.owlapi.AbstractOWLAPITests;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class ABoxUpdateTests
extends AbstractOWLAPITests {
    public static Test suite() {
        return new JUnit4TestAdapter(ABoxUpdateTests.class);
    }

    @org.junit.Test
    public void removeType() throws OWLException {
        this.createReasoner(new OWLAxiom[]{OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C), OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D)));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D));
        Assert.assertTrue((boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D)));
    }

    @org.junit.Test
    public void removeTypeFromMergedNode() throws OWLException {
        this.createReasoner(new OWLAxiom[]{OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)OWL.oneOf((OWLIndividual[])new OWLIndividual[]{b, c})), OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A), OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)B), OWL.classAssertion((OWLIndividual)c, (OWLClassExpression)C), OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)B)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D)));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D));
        Assert.assertTrue((boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)B)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)D)));
    }

    @org.junit.Test
    public void removePropertyValue() throws OWLException {
        this.createReasoner(new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)c)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)c)));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)c));
        Assert.assertTrue((boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)));
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)c)));
    }
}

