/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.clarkparsia.pellet.test.query.ARQSparqlDawgTester;
import com.clarkparsia.pellet.test.query.ManifestEngine;
import com.clarkparsia.pellet.test.query.ManifestEngineProcessor;
import com.clarkparsia.pellet.test.query.PelletSparqlDawgTester;
import com.clarkparsia.pellet.test.query.SparqlDawgTestCase;
import com.clarkparsia.pellet.test.query.SparqlDawgTester;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.test.PelletTestSuite;

@RunWith(value=Parameterized.class)
public class SparqlDawgTestSuite {
    private final SparqlDawgTestCase test;

    private static String getName(String manifestName) {
        String name = manifestName;
        try {
            URI uri = URI.create(manifestName);
            String[] pathComponents = uri.getPath().split("/");
            name = pathComponents[pathComponents.length - 2];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    private static void addSuite(final List<Object[]> parameters, String manifest, final Map<SparqlDawgTester, Properties> testers) {
        final ManifestEngine engine = new ManifestEngine(null, manifest);
        engine.setProcessor(new ManifestEngineProcessor(){

            @Override
            public void manifestStarted(String manifestName) {
            }

            @Override
            public void test(Resource test) {
                for (Map.Entry entry : testers.entrySet()) {
                    SparqlDawgTester tester = (SparqlDawgTester)entry.getKey();
                    Properties options = (Properties)entry.getValue();
                    parameters.add(new Object[]{new SparqlDawgTestCase(tester, engine, test, options)});
                }
            }

            @Override
            public void manifestFinished(String manifestName) {
            }
        });
        engine.run();
    }

    @Parameterized.Parameters
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        ARQSparqlDawgTester arqTester = new ARQSparqlDawgTester();
        PelletSparqlDawgTester basicSparqlDLTester = new PelletSparqlDawgTester(SparqlDLExecutionFactory.QueryEngineType.PELLET, false);
        PelletSparqlDawgTester integratedSparqlDLTester = new PelletSparqlDawgTester(SparqlDLExecutionFactory.QueryEngineType.MIXED, false);
        String sparqldlTests = PelletTestSuite.base + "sparqldl-tests/manifest.ttl";
        String sparqlSameAsTests = PelletTestSuite.base + "query/sameAs/manifest.ttl";
        Properties noUndistVars = new Properties();
        noUndistVars.setProperty("IGNORE_UNSUPPORTED_AXIOMS", "false");
        noUndistVars.setProperty("TREAT_ALL_VARS_DISTINGUISHED", "true");
        Properties undistVars = new Properties();
        undistVars.setProperty("IGNORE_UNSUPPORTED_AXIOMS", "false");
        undistVars.setProperty("TREAT_ALL_VARS_DISTINGUISHED", "false");
        HashMap<ARQSparqlDawgTester, Properties> dawgTesters = new HashMap<ARQSparqlDawgTester, Properties>();
        dawgTesters.put(arqTester, noUndistVars);
        dawgTesters.put(basicSparqlDLTester, noUndistVars);
        dawgTesters.put(integratedSparqlDLTester, noUndistVars);
        HashMap<SparqlDawgTester, Properties> sparqldlTesters = new HashMap<SparqlDawgTester, Properties>();
        sparqldlTesters.put(basicSparqlDLTester, undistVars);
        sparqldlTesters.put(integratedSparqlDLTester, undistVars);
        SparqlDawgTestSuite.addSuite(parameters, sparqldlTests, sparqldlTesters);
        HashMap<SparqlDawgTester, Properties> sparqlSameAsTesters = new HashMap<SparqlDawgTester, Properties>();
        sparqlSameAsTesters.put(basicSparqlDLTester, undistVars);
        SparqlDawgTestSuite.addSuite(parameters, sparqlSameAsTests, sparqlSameAsTesters);
        return parameters;
    }

    public SparqlDawgTestSuite(SparqlDawgTestCase test) {
        this.test = test;
    }

    @Test
    public void run() throws IOException {
        this.test.runTest();
    }
}

