/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QuerySubsumption;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.parser.QueryParser;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class TestQuerySubsumption {
    String ont = "file:test/data/misc/family.owl";
    String family = "http://www.example.org/family#";
    String prefix = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\r\nPREFIX family: <" + this.family + ">\r\nSELECT * { ";
    String suffix = " }";
    KnowledgeBase kb;
    QueryParser parser;

    @Before
    public void setUp() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(this.ont);
        model.prepare();
        this.kb = ((PelletInfGraph)model.getGraph()).getKB();
        this.parser = QueryEngine.getParser();
    }

    private Query query(String queryStr) {
        return this.parser.parse(this.prefix + queryStr + this.suffix, this.kb);
    }

    @Test
    public void testIsEquivalentTo() {
        Query[] queries = new Query[2];
        queries = this.example1();
        Assert.assertFalse((boolean)QuerySubsumption.isEquivalentTo((Query)queries[0], (Query)queries[1]));
        queries = this.example2();
        Assert.assertFalse((boolean)QuerySubsumption.isEquivalentTo((Query)queries[1], (Query)queries[0]));
        queries = this.example3();
        Assert.assertTrue((boolean)QuerySubsumption.isEquivalentTo((Query)queries[1], (Query)queries[0]));
        queries = this.example4();
        Assert.assertFalse((boolean)QuerySubsumption.isEquivalentTo((Query)queries[1], (Query)queries[0]));
    }

    @Test
    public void testIsSubsumedBy() {
        Query[] queries = new Query[2];
        queries = this.example1();
        Assert.assertTrue((boolean)QuerySubsumption.isSubsumedBy((Query)queries[0], (Query)queries[1]));
        Assert.assertFalse((boolean)QuerySubsumption.isSubsumedBy((Query)queries[1], (Query)queries[0]));
        queries = this.example2();
        Assert.assertTrue((boolean)QuerySubsumption.isSubsumedBy((Query)queries[0], (Query)queries[1]));
        Assert.assertFalse((boolean)QuerySubsumption.isSubsumedBy((Query)queries[1], (Query)queries[0]));
        queries = this.example3();
        Assert.assertTrue((boolean)QuerySubsumption.isSubsumedBy((Query)queries[0], (Query)queries[1]));
        Assert.assertTrue((boolean)QuerySubsumption.isSubsumedBy((Query)queries[1], (Query)queries[0]));
        queries = this.example4();
        Assert.assertTrue((boolean)QuerySubsumption.isSubsumedBy((Query)queries[0], (Query)queries[1]));
        Assert.assertFalse((boolean)QuerySubsumption.isSubsumedBy((Query)queries[1], (Query)queries[0]));
    }

    private Query[] example1() {
        Query[] queries = new Query[]{this.query("?x a family:Male ."), this.query("?x a family:Person .")};
        return queries;
    }

    public Query[] example2() {
        Query[] queries = new Query[]{this.query("?x family:isMarriedTo ?y . ?y rdf:type family:Male"), this.query("?x a family:Female .")};
        return queries;
    }

    public Query[] example3() {
        Query[] queries = new Query[]{this.query("?x family:hasFather ?y . "), this.query("?x family:hasParent ?y . ?y a family:Male .")};
        return queries;
    }

    public Query[] example4() {
        Query[] queries = new Query[]{this.query("?x a family:Female; family:hasBrother ?y . "), this.query("?x a family:Female; family:hasSibling ?z .")};
        return queries;
    }
}

