/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class TestSingleSPARQLDLQueries {
    private final String NS = "http://example.org#";

    @Test
    public void testVariableSPO1() {
        String q = "SELECT * WHERE { ?s ?p ?o }";
        Resource s = ResourceFactory.createResource((String)"http://example.org#i");
        Property p = RDF.type;
        Resource o = ResourceFactory.createResource((String)"http://example.org#C");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(s, p, (RDFNode)o);
        Query query = QueryFactory.create((String)q);
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)model.listStatements().toList().size(), (long)rs.getRowNumber());
    }

    @Test
    public void testVariableSPO2() {
        String q = "SELECT * WHERE { ?s ?p ?o }";
        Resource s = ResourceFactory.createResource((String)"http://example.org#i");
        Property p = ResourceFactory.createProperty((String)"http://example.org#p");
        Resource o = ResourceFactory.createResource((String)"http://example.org#C");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(s, p, (RDFNode)o);
        Query query = QueryFactory.create((String)q);
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)model.listStatements().toList().size(), (long)rs.getRowNumber());
    }

    @Test
    public void testVariableSPO3() {
        String q = "PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX ex: <http://example.org#> SELECT * WHERE { ?s ?p ?o . ?p rdf:type owl:ObjectProperty }";
        Resource s = ResourceFactory.createResource((String)"http://example.org#i");
        Property p = ResourceFactory.createProperty((String)"http://example.org#p");
        Resource o = ResourceFactory.createResource((String)"http://example.org#j");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(s, p, (RDFNode)o);
        model.add((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        Query query = QueryFactory.create((String)q);
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)1L, (long)rs.getRowNumber());
    }

    @Test
    public void testVariableSPO4() {
        String q = "SELECT * WHERE { ?s ?p ?o }";
        Resource s = ResourceFactory.createResource((String)"http://example.org#i");
        Property p = ResourceFactory.createProperty((String)"http://example.org#p");
        Resource o = ResourceFactory.createResource((String)"http://example.org#C");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(s, p, (RDFNode)o);
        Query query = QueryFactory.create((String)q);
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Dataset)DatasetFactory.create((Model)model), null, (SparqlDLExecutionFactory.QueryEngineType)SparqlDLExecutionFactory.QueryEngineType.PELLET, (boolean)false);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)1L, (long)rs.getRowNumber());
    }

    @Test
    public void testDAWG1() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("file:test/data/sparql-dawg-tests/data-r2/basic/data-1.ttl", "N3");
        Query query = QueryFactory.read((String)"file:test/data/sparql-dawg-tests/data-r2/basic/base-prefix-1.rq");
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)4L, (long)rs.getRowNumber());
    }

    @Test
    public void testDAWG2() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("file:test/data/sparql-dawg-tests/data-r2/graph/data-g1.ttl", "N3");
        Query query = QueryFactory.read((String)"file:test/data/sparql-dawg-tests/data-r2/graph/graph-01.rq");
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)model.listStatements().toList().size(), (long)rs.getRowNumber());
    }

    @Test
    public void testDAWG3() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("file:test/data/sparql-dawg-tests/data-r2/graph/data-g1.ttl", "N3");
        Query query = QueryFactory.read((String)"file:test/data/sparql-dawg-tests/data-r2/graph/graph-01.rq");
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Dataset)DatasetFactory.create((Model)model), null, (SparqlDLExecutionFactory.QueryEngineType)SparqlDLExecutionFactory.QueryEngineType.MIXED, (boolean)false);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)2L, (long)rs.getRowNumber());
    }

    @Test
    public void testDAWG4() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("file:test/data/sparql-dawg-tests/data-r2/optional-filter/data-1.ttl", "N3");
        Query query = QueryFactory.read((String)"file:test/data/sparql-dawg-tests/data-r2/optional-filter/expr-5.rq");
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)3L, (long)rs.getRowNumber());
    }

    @Test
    public void testUnsupportedBuiltin() {
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String nc = "urn:test:";
        OntClass class1 = ontmodel.createClass(nc + "C1");
        Individual[] inds = new Individual[6];
        for (int j = 0; j < 6; ++j) {
            inds[j] = ontmodel.createIndividual(nc + "Ind" + j, OWL.Thing);
        }
        ontmodel.add((Resource)class1, RDFS.subClassOf, (RDFNode)ontmodel.createEnumeratedClass(null, ontmodel.createList((RDFNode[])inds)));
        Query query = QueryFactory.create((String)("PREFIX rdf:<" + RDF.getURI() + ">\nSELECT * WHERE {\n  ?x rdf:first ?y .\n}"));
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)ontmodel);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        Assert.assertEquals((long)6L, (long)rs.getRowNumber());
    }

    @Test
    public void testAnnotationQueryWithClassesAndProperties() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        Resource class1 = ResourceFactory.createResource((String)"http://example.org#class1");
        Property property1 = ResourceFactory.createProperty((String)"http://example.org#property1");
        Literal literal1 = ResourceFactory.createPlainLiteral((String)"Annotation 1");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(class1, RDF.type, (RDFNode)OWL.Class);
        model.add(class1, RDFS.label, (RDFNode)literal1);
        model.add((Resource)property1, RDF.type, (RDFNode)RDF.Property);
        model.add((Resource)property1, RDFS.label, (RDFNode)literal1);
        String q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nSELECT * WHERE { ?x rdfs:label ?y }";
        Query query = QueryFactory.create((String)q);
        QueryExecution qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        Assert.assertEquals((long)2L, (long)ResultSetFormatter.consume((ResultSet)rs));
        q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nPREFIX ex:<" + "http://example.org#" + ">\nSELECT * WHERE { ex:property1 rdfs:label ?y }";
        query = QueryFactory.create((String)q);
        qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        rs = qe.execSelect();
        Assert.assertEquals((long)1L, (long)ResultSetFormatter.consume((ResultSet)rs));
        q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nPREFIX ex:<" + "http://example.org#" + ">\nSELECT * WHERE { ?x rdfs:label \"Annotation 1\" }";
        query = QueryFactory.create((String)q);
        qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        rs = qe.execSelect();
        Assert.assertEquals((long)2L, (long)ResultSetFormatter.consume((ResultSet)rs));
    }

    @Test
    public void testAnnotationQueryWithGroundAtoms() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        Resource class1 = ResourceFactory.createResource((String)"http://example.org#class1");
        Literal literal1 = ResourceFactory.createPlainLiteral((String)"Annotation 1");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(class1, RDF.type, (RDFNode)OWL.Class);
        model.add(class1, RDFS.label, (RDFNode)literal1);
        String q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nSELECT * WHERE { ?x rdfs:label ?y }";
        Query query = QueryFactory.create((String)q);
        QueryExecution qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        Assert.assertEquals((long)1L, (long)ResultSetFormatter.consume((ResultSet)rs));
        q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nSELECT * WHERE { <" + "http://example.org#" + "class1> rdfs:label \"Annotation 1\" }";
        query = QueryFactory.create((String)q);
        qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        rs = qe.execSelect();
        Assert.assertEquals((long)1L, (long)ResultSetFormatter.consume((ResultSet)rs));
        q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nSELECT * WHERE { <" + "http://example.org#" + "class1> rdfs:label \"Random Annotation\" }";
        query = QueryFactory.create((String)q);
        qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        rs = qe.execSelect();
        Assert.assertEquals((long)0L, (long)ResultSetFormatter.consume((ResultSet)rs));
        q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nSELECT * WHERE { ?x rdfs:label \"Annotation 1\" }";
        query = QueryFactory.create((String)q);
        qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        rs = qe.execSelect();
        Assert.assertEquals((long)1L, (long)ResultSetFormatter.consume((ResultSet)rs));
        q = "PREFIX rdfs:<" + RDFS.getURI() + ">\nSELECT * WHERE { ?x rdfs:label \"Random Annotation \" }";
        query = QueryFactory.create((String)q);
        qe = SparqlDLExecutionFactory.createPelletExecution((Query)query, (Model)model);
        rs = qe.execSelect();
        Assert.assertEquals((long)0L, (long)ResultSetFormatter.consume((ResultSet)rs));
    }
}

