/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.rbox;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.KnowledgeBase;

public class TestTopBottom {
    public static Test suite() {
        return new JUnit4TestAdapter(TestTopBottom.class);
    }

    @org.junit.Test
    public void bottomDataAssertion() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.literal((String)"y");
        kb.addIndividual(x);
        Assert.assertFalse((boolean)kb.hasPropertyValue(x, TermFactory.BOTTOM_DATA_PROPERTY, y));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)TermFactory.BOTTOM_DATA_PROPERTY, (ATermAppl)TermFactory.TOP_LIT))));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.not((ATermAppl)TermFactory.hasValue((ATermAppl)TermFactory.BOTTOM_DATA_PROPERTY, (ATermAppl)y))));
        kb.addPropertyValue(TermFactory.BOTTOM_DATA_PROPERTY, x, y);
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @org.junit.Test
    public void bottomDataDomain() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.hasDomain(TermFactory.BOTTOM_DATA_PROPERTY, TermFactory.BOTTOM));
    }

    @org.junit.Test
    public void bottomDataFunctional() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isFunctionalProperty(TermFactory.BOTTOM_DATA_PROPERTY));
    }

    @org.junit.Test
    public void bottomDataRange() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.hasRange(TermFactory.BOTTOM_DATA_PROPERTY, TermFactory.BOTTOM_LIT));
    }

    @org.junit.Test
    public void bottomDataSuper() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        kb.addDatatypeProperty((ATerm)p);
        Assert.assertTrue((boolean)kb.isSubPropertyOf(TermFactory.BOTTOM_DATA_PROPERTY, p));
    }

    @org.junit.Test
    public void bottomObjectAssertion() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        kb.addIndividual(x);
        kb.addIndividual(y);
        Assert.assertFalse((boolean)kb.hasPropertyValue(x, TermFactory.BOTTOM_OBJECT_PROPERTY, x));
        Assert.assertFalse((boolean)kb.hasPropertyValue(x, TermFactory.BOTTOM_OBJECT_PROPERTY, y));
        Assert.assertFalse((boolean)kb.hasPropertyValue(y, TermFactory.BOTTOM_OBJECT_PROPERTY, x));
        Assert.assertFalse((boolean)kb.hasPropertyValue(y, TermFactory.BOTTOM_OBJECT_PROPERTY, y));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)TermFactory.BOTTOM_OBJECT_PROPERTY, (ATermAppl)TermFactory.TOP))));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.not((ATermAppl)TermFactory.hasValue((ATermAppl)TermFactory.BOTTOM_OBJECT_PROPERTY, (ATermAppl)x))));
        Assert.assertTrue((boolean)kb.isType(x, TermFactory.not((ATermAppl)TermFactory.hasValue((ATermAppl)TermFactory.BOTTOM_OBJECT_PROPERTY, (ATermAppl)y))));
        Assert.assertTrue((boolean)kb.isType(y, TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)TermFactory.BOTTOM_OBJECT_PROPERTY, (ATermAppl)TermFactory.TOP))));
        Assert.assertTrue((boolean)kb.isType(y, TermFactory.not((ATermAppl)TermFactory.hasValue((ATermAppl)TermFactory.BOTTOM_OBJECT_PROPERTY, (ATermAppl)x))));
        Assert.assertTrue((boolean)kb.isType(y, TermFactory.not((ATermAppl)TermFactory.hasValue((ATermAppl)TermFactory.BOTTOM_OBJECT_PROPERTY, (ATermAppl)y))));
        kb.addPropertyValue(TermFactory.BOTTOM_OBJECT_PROPERTY, x, y);
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @org.junit.Test
    public void bottomObjectAsymm() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isAsymmetricProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectFunc() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isFunctionalProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
        Assert.assertTrue((boolean)kb.getFunctionalProperties().contains(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectInverse() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isInverse(TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectInverseManual() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"_C_");
        ATermAppl notC = TermFactory.not((ATermAppl)c);
        ATermAppl r = TermFactory.BOTTOM_OBJECT_PROPERTY;
        ATermAppl test = TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)r, (ATermAppl)notC)), (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)r, (ATermAppl)notC))));
        Assert.assertFalse((boolean)kb.isSatisfiable(test));
    }

    @org.junit.Test
    public void bottomObjectInvFunc() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isInverseFunctionalProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectIrreflexive() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isIrreflexiveProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectReflexive() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertFalse((boolean)kb.isReflexiveProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectSuper() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        kb.addObjectProperty((ATerm)p);
        Assert.assertTrue((boolean)kb.isSubPropertyOf(TermFactory.BOTTOM_OBJECT_PROPERTY, p));
    }

    @org.junit.Test
    public void topEquivalent() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"concrete");
        ATermAppl r = TermFactory.term((String)"abstract");
        ATermAppl s = TermFactory.term((String)"universal");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addObjectProperty((ATerm)s);
        kb.addSubProperty((ATerm)p, r);
        kb.addSubProperty((ATerm)r, s);
        Assert.assertTrue((boolean)kb.isSubPropertyOf(p, s));
        Assert.assertTrue((boolean)kb.getSubProperties(s).contains(Collections.singleton(p)));
        kb.addEquivalentProperty(s, TermFactory.TOP_OBJECT_PROPERTY);
        Assert.assertTrue((boolean)kb.isSubPropertyOf(p, s));
        Assert.assertTrue((boolean)kb.getSubProperties(s).contains(Collections.singleton(p)));
    }

    @org.junit.Test
    public void bottomObjectSymm() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isSymmetricProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void bottomObjectTransitive() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isTransitiveProperty(TermFactory.BOTTOM_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topDataAssertion() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.literal((String)"y");
        kb.addDatatypeProperty((ATerm)r);
        kb.addIndividual(x);
        kb.addPropertyValue(r, x, y);
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, TermFactory.TOP_DATA_PROPERTY, y));
    }

    @org.junit.Test
    public void topDataFunctional() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertFalse((boolean)kb.isFunctionalProperty(TermFactory.TOP_DATA_PROPERTY));
    }

    @org.junit.Test
    public void topDataSuper() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        kb.addDatatypeProperty((ATerm)p);
        Assert.assertTrue((boolean)kb.isSubPropertyOf(p, TermFactory.TOP_DATA_PROPERTY));
    }

    @org.junit.Test
    public void topObjectAllValues() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        ATermAppl z = TermFactory.term((String)"z");
        kb.addClass(c);
        kb.addIndividual(x);
        kb.addIndividual(y);
        kb.addIndividual(z);
        kb.addDifferent(x, y);
        kb.addDifferent(x, z);
        kb.addSubClass(c, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{x, y}));
        kb.addSubClass(TermFactory.TOP, TermFactory.all((ATermAppl)TermFactory.TOP_OBJECT_PROPERTY, (ATermAppl)c));
        Assert.assertTrue((boolean)kb.isSameAs(y, z));
    }

    @org.junit.Test
    public void topObjectallValuesFreshInd() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"_C_");
        ATermAppl notC = TermFactory.not((ATermAppl)c);
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addIndividual(a);
        kb.addType(a, TermFactory.all((ATermAppl)TermFactory.TOP_OBJECT_PROPERTY, (ATermAppl)notC));
        kb.addIndividual(b);
        kb.addType(b, TermFactory.some((ATermAppl)TermFactory.TOP_OBJECT_PROPERTY, (ATermAppl)c));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @org.junit.Test
    public void topObjectAssertion() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        kb.addIndividual(x);
        kb.addIndividual(y);
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, TermFactory.TOP_OBJECT_PROPERTY, x));
        Assert.assertTrue((boolean)kb.hasPropertyValue(x, TermFactory.TOP_OBJECT_PROPERTY, y));
        Assert.assertTrue((boolean)kb.hasPropertyValue(y, TermFactory.TOP_OBJECT_PROPERTY, x));
        Assert.assertTrue((boolean)kb.hasPropertyValue(y, TermFactory.TOP_OBJECT_PROPERTY, y));
    }

    @org.junit.Test
    public void topObjectAsymm() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertFalse((boolean)kb.isAsymmetricProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectDomain() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        ATermAppl z = TermFactory.term((String)"z");
        kb.addClass(c);
        kb.addIndividual(x);
        kb.addIndividual(y);
        kb.addIndividual(z);
        kb.addDifferent(x, y);
        kb.addDifferent(x, z);
        kb.addSubClass(c, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{x, y}));
        kb.addDomain((ATerm)TermFactory.TOP_OBJECT_PROPERTY, c);
        Assert.assertTrue((boolean)kb.isSameAs(y, z));
    }

    @org.junit.Test
    public void topObjectFunc() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertFalse((boolean)kb.isFunctionalProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectInverse() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isInverse(TermFactory.TOP_OBJECT_PROPERTY, TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectInverseManual() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"_C_");
        ATermAppl notC = TermFactory.not((ATermAppl)c);
        ATermAppl r = TermFactory.TOP_OBJECT_PROPERTY;
        ATermAppl test = TermFactory.and((ATermAppl)c, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)r, (ATermAppl)notC)), (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)r, (ATermAppl)notC))));
        Assert.assertFalse((boolean)kb.isSatisfiable(test));
    }

    @org.junit.Test
    public void topObjectInvFunc() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertFalse((boolean)kb.isInverseFunctionalProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectIrreflexive() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertFalse((boolean)kb.isIrreflexiveProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectRange() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        ATermAppl z = TermFactory.term((String)"z");
        kb.addClass(c);
        kb.addIndividual(x);
        kb.addIndividual(y);
        kb.addIndividual(z);
        kb.addDifferent(x, y);
        kb.addDifferent(x, z);
        kb.addSubClass(c, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{x, y}));
        kb.addRange((ATerm)TermFactory.TOP_OBJECT_PROPERTY, c);
        Assert.assertTrue((boolean)kb.isSameAs(y, z));
    }

    @org.junit.Test
    public void topObjectReflexive() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isReflexiveProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectSomeValuesBottom() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.addSubClass(TermFactory.TOP, TermFactory.some((ATermAppl)TermFactory.TOP_OBJECT_PROPERTY, (ATermAppl)TermFactory.BOTTOM));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @org.junit.Test
    public void topObjectSuper() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        kb.addObjectProperty((ATerm)p);
        Assert.assertTrue((boolean)kb.isSubPropertyOf(p, TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectSymm() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isSymmetricProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectTransitive() {
        KnowledgeBase kb = new KnowledgeBase();
        Assert.assertTrue((boolean)kb.isTransitiveProperty(TermFactory.TOP_OBJECT_PROPERTY));
    }

    @org.junit.Test
    public void topObjectDisjoints() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl subP = TermFactory.term((String)"subP");
        ATermAppl q = TermFactory.term((String)"q");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)subP);
        kb.addObjectProperty((ATerm)q);
        kb.addSubProperty((ATerm)subP, p);
        kb.addDisjointProperty(p, q);
        kb.getRoleTaxonomy(true).getTop().print();
        kb.getRoleTaxonomy(false).getTop().print();
        Assert.assertTrue((boolean)kb.isDisjointProperty(TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.TOP_OBJECT_PROPERTY));
        Assert.assertTrue((boolean)kb.isDisjointProperty(TermFactory.TOP_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY));
        Assert.assertEquals(TestTopBottom.singletonSets(TermFactory.BOTTOM_OBJECT_PROPERTY), (Object)kb.getDisjointProperties(TermFactory.TOP_OBJECT_PROPERTY));
        Assert.assertEquals(TestTopBottom.singletonSets(TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.TOP_OBJECT_PROPERTY, p, subP, q), (Object)kb.getDisjointProperties(TermFactory.BOTTOM_OBJECT_PROPERTY));
        Assert.assertEquals(TestTopBottom.singletonSets(TermFactory.BOTTOM_OBJECT_PROPERTY, q), (Object)kb.getDisjointProperties(p));
        Assert.assertEquals(TestTopBottom.singletonSets(TermFactory.BOTTOM_OBJECT_PROPERTY, p, subP), (Object)kb.getDisjointProperties(q));
        Assert.assertEquals(TestTopBottom.singletonSets(TermFactory.BOTTOM_OBJECT_PROPERTY), (Object)kb.getDisjointProperties(TermFactory.TOP_OBJECT_PROPERTY, true));
        Assert.assertEquals(TestTopBottom.singletonSets(TermFactory.TOP_OBJECT_PROPERTY), (Object)kb.getDisjointProperties(TermFactory.BOTTOM_OBJECT_PROPERTY, true));
        Assert.assertEquals(TestTopBottom.singletonSets(q), (Object)kb.getDisjointProperties(p, true));
        Assert.assertEquals(TestTopBottom.singletonSets(p), (Object)kb.getDisjointProperties(q, true));
    }

    public static <T> Set<Set<T>> singletonSets(T ... es) {
        HashSet<Set<T>> set = new HashSet<Set<T>>();
        for (T e : es) {
            set.add(Collections.singleton(e));
        }
        return set;
    }
}

