/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.util;

import com.clarkparsia.pellint.util.OptimizedDirectedMultigraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OptimizedDirectedMultigraphTest {
    private static final String[] V = new String[]{"a", "b", "c"};
    private OptimizedDirectedMultigraph<String> m_Graph;

    @Before
    public void setUp() {
        this.m_Graph = new OptimizedDirectedMultigraph();
        for (String v : V) {
            this.m_Graph.addVertex((Object)v);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddEdgeToNonExistentVertices() {
        this.m_Graph.addEdge((Object)"alien1", (Object)"alien2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddEdgeLoop() {
        this.m_Graph.addEdge((Object)V[0], (Object)V[0]);
    }

    @Test
    public void testAddEdgeSimple() {
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)V[0], (Object)V[1]);
        Assert.assertNull((Object)edge);
        edge = this.m_Graph.addEdge((Object)"a", (Object)"b");
        Assert.assertEquals((long)1L, (long)this.m_Graph.getEdgeMultiplicity(edge));
        edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        Assert.assertEquals((long)1L, (long)this.m_Graph.getEdgeMultiplicity(edge));
    }

    @Test
    public void testAddEdgeMultiple() {
        this.m_Graph.addEdge((Object)"a", (Object)"b");
        this.m_Graph.addEdge((Object)"a", (Object)"b");
        this.m_Graph.addEdge((Object)"b", (Object)"a");
        this.m_Graph.addEdge((Object)"b", (Object)"a");
        this.m_Graph.addEdge((Object)"a", (Object)"c");
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        Assert.assertEquals((long)2L, (long)this.m_Graph.getEdgeMultiplicity(edge));
        edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"b", (Object)"a");
        Assert.assertEquals((long)2L, (long)this.m_Graph.getEdgeMultiplicity(edge));
        edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"c");
        Assert.assertEquals((long)1L, (long)this.m_Graph.getEdgeMultiplicity(edge));
    }

    @Test
    public void testAddEdgeWithMultiplicity() {
        this.m_Graph.addEdge((Object)"a", (Object)"b", 10);
        this.m_Graph.addEdge((Object)"a", (Object)"b", 1);
        this.m_Graph.addEdge((Object)"a", (Object)"b", 1);
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        Assert.assertEquals((long)12L, (long)this.m_Graph.getEdgeMultiplicity(edge));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddEdgeWithZeroMultiplicity() {
        this.m_Graph.addEdge((Object)"a", (Object)"b", 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddEdgeWithNegativeMultiplicity() {
        this.m_Graph.addEdge((Object)"a", (Object)"b", -1);
    }

    @Test
    public void testRemoveEdge() {
        this.m_Graph.addEdge((Object)"a", (Object)"b", 10);
        this.m_Graph.removeEdge((Object)"a", (Object)"b");
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.m_Graph.getEdge((Object)"a", (Object)"b");
        Assert.assertNull((Object)edge);
    }
}

