/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.PatternFilter;
import org.mindswap.pellet.utils.Timer;

public class DLBenchmarkTest {
    public static Logger log = Logger.getLogger(DLBenchmarkTest.class.getName());
    public static boolean PRINT_TIME = false;
    public static boolean PRINT_TREE = false;
    public static int SAT_LIMIT = 10;
    public static int TBOX_LIMIT = 20;
    public static int ABOX_LIMIT = 50;
    public static boolean FAST = false;
    public static boolean FORCE_UPPERCASE = true;
    private KRSSLoader loader = new KRSSLoader();
    private KnowledgeBase kb;

    public DLBenchmarkTest() {
        this.loader.setForceUppercase(FORCE_UPPERCASE);
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public KnowledgeBase initKB(long timeout) {
        KnowledgeBase kb = new KnowledgeBase();
        kb.setTimeout(timeout * 1000L);
        return kb;
    }

    public void doAllTBoxTests(String dirName) throws Exception {
        this.doAllTBoxTests(dirName, (FileFilter)new PatternFilter("*.akb"));
    }

    public void doAllTBoxTests(String dirName, FileFilter filter) throws Exception {
        File dir = new File(dirName);
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
        TableData table = new TableData(Arrays.asList("Name", "Size", "Time"));
        for (int i = 0; i < files.length; ++i) {
            System.out.print(i + 1 + ") ");
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(files[i]);
            try {
                this.doTBoxTest(files[i].toString());
                data.add(this.kb.getClasses().size());
                data.add(this.kb.timers.getTimer("test").getTotal() + "");
            }
            catch (TimeoutException e) {
                System.out.println(" ** Timeout: " + e.getMessage() + " ** ");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println();
            }
            catch (OutOfMemoryError e) {
                System.out.println(" ** Out of Memory ** ");
            }
            catch (StackOverflowError e) {
                System.out.println(" ** Stack Overflow ** ");
            }
            catch (Error e) {
                e.printStackTrace(System.err);
            }
            table.add(data);
        }
        System.out.print(table);
    }

    public boolean doTBoxTest(String file) throws Exception {
        String displayName;
        String ext = ".tkb";
        int index = file.lastIndexOf(46);
        if (index != -1) {
            ext = file.substring(index);
            file = file.substring(0, index);
        }
        String string = displayName = (index = file.lastIndexOf(File.separator)) == -1 ? file : file.substring(index + 1);
        if (log.isLoggable(Level.INFO)) {
            System.out.print(displayName + " ");
        }
        this.loader.clear();
        this.loader.getKB().timers.resetAll();
        this.kb = this.loader.createKB(new String[]{file + ext});
        this.kb.setTimeout((long)(TBOX_LIMIT * 1000));
        Timer t = this.kb.timers.startTimer("test");
        if (log.isLoggable(Level.INFO)) {
            System.out.print("preparing...");
        }
        this.kb.prepare();
        if (log.isLoggable(Level.INFO)) {
            System.out.print("classifying...");
        }
        this.kb.classify();
        t.stop();
        if (PRINT_TREE) {
            this.kb.printClassTree();
        }
        if (log.isLoggable(Level.INFO)) {
            System.out.print("verifying...");
        }
        this.loader.verifyTBox(file + ".tree", this.kb);
        if (log.isLoggable(Level.INFO)) {
            System.out.print("done");
        }
        if (log.isLoggable(Level.INFO)) {
            System.out.print(" Prepare " + this.kb.timers.getTimer("preprocessing").getTotal());
            System.out.print(" Classify " + this.kb.timers.getTimer("classify").getTotal());
            System.out.println(" " + t.getTotal());
        }
        if (PRINT_TIME) {
            this.kb.timers.print();
        }
        return true;
    }

    public void doAllSatTests(String dirName) throws Exception {
        File dir = new File(dirName);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            System.out.print(i + 1 + ") " + files[i] + " ");
            try {
                int count = this.doSatTest(dirName + files[i]);
                System.out.println(count);
                continue;
            }
            catch (TimeoutException e) {
                System.out.println(" ** Timeout ** ");
                System.out.println();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.out.println(" ** Out of Memory ** ");
                System.out.println();
                continue;
            }
            catch (Error e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public int doSatTest(String file) throws Exception {
        int count = 0;
        System.err.println("Sat test currently disabled!");
        return count;
    }

    public boolean doABoxTest(String file) throws Exception {
        String ext = ".tkb";
        int index = file.lastIndexOf(46);
        if (index != -1) {
            ext = file.substring(index);
            file = file.substring(0, index);
        }
        String displayName = (index = file.lastIndexOf(File.separator)) == -1 ? file : file.substring(index + 1);
        System.out.print(displayName + " ");
        this.kb = this.loader.createKB(new String[]{file + ext});
        this.kb.timers.resetAll();
        this.kb.setTimeout((long)(ABOX_LIMIT * 1000));
        Timer t = this.kb.timers.startTimer("test");
        System.out.print("preparing...");
        this.kb.prepare();
        if (!FAST) {
            System.out.print("classifying...");
            this.kb.realize();
        }
        t.stop();
        System.out.print("verifying...");
        this.loader.verifyABox(file + ".query", this.kb);
        System.out.print("done");
        System.out.print(" Prepare " + this.kb.timers.getTimer("preprocessing").getTotal());
        System.out.print(" Classify " + this.kb.timers.getTimer("classify").getTotal());
        System.out.println(" " + t.getTotal());
        if (PRINT_TIME) {
            this.kb.timers.print();
        }
        return true;
    }

    public void doAllABoxTests(String dirName) throws Exception {
        this.doAllABoxTests(dirName, "*.akb");
    }

    public void doAllABoxTests(String dirName, String pattern) throws Exception {
        File dir = new File(dirName);
        File[] files = dir.listFiles((FileFilter)new PatternFilter(pattern));
        Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
        for (int i = 0; i < files.length; ++i) {
            System.out.print(i + 1 + ") ");
            try {
                this.doABoxTest(files[i].getAbsolutePath());
                continue;
            }
            catch (TimeoutException e) {
                System.out.println(" ***** Timeout ***** ");
                System.out.println();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.out.println(" ***** Out of Memory ***** ");
                System.out.println();
                continue;
            }
            catch (Error e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void usage() {
        System.out.println("DLTest - Run the tests in DL-benchmark suite");
        System.out.println("");
        System.out.println("Usage: java DLTest [-timing] <input> <type>");
        System.out.println("   input    A single file or a directory that contains");
        System.out.println("            a set of test files");
        System.out.println("   type     Type of the test, one of [sat, tbox, abox]");
    }

    public static final void main(String[] args) throws Exception {
        if (args.length == 0) {
            DLBenchmarkTest.usage();
            return;
        }
        int base = 0;
        if (args[0].equals("-timing")) {
            PRINT_TIME = true;
            base = 1;
        } else if (args.length != 2) {
            System.out.println("Invalid arguments");
            DLBenchmarkTest.usage();
            return;
        }
        String in = args[base + 0];
        String type = args[base + 1];
        File file = new File(in);
        if (!file.exists()) {
            throw new FileNotFoundException(file + " does not exist!");
        }
        boolean singleTest = file.isFile();
        DLBenchmarkTest test = new DLBenchmarkTest();
        if (type.equals("sat")) {
            if (singleTest) {
                test.doSatTest(in);
            } else {
                test.doAllSatTests(in);
            }
        } else if (type.equals("tbox")) {
            if (singleTest) {
                test.doTBoxTest(in);
            } else {
                test.doAllTBoxTests(in);
            }
        } else if (type.equals("abox")) {
            if (singleTest) {
                test.doABoxTest(in);
            } else {
                test.doAllABoxTests(in);
            }
        } else {
            DLBenchmarkTest.usage();
        }
    }
}

