/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.junit.Assert;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.test.WebOntTester;

public class JenaWebOntTester
implements WebOntTester {
    private OntModel model;
    private LocationMapper mapper = new LocationMapper();

    public JenaWebOntTester() {
        FileManager manager = OntDocumentManager.getInstance().getFileManager();
        manager.setLocationMapper(this.mapper);
        manager.addLocator((Locator)new LocatorFile(null));
    }

    @Override
    public void classify() {
        ((PelletInfGraph)this.model.getGraph()).getKB().realize();
    }

    @Override
    public boolean isConsistent() {
        return ((PelletInfGraph)this.model.getGraph()).getKB().isConsistent();
    }

    @Override
    public void testEntailment(String entailmentFileURI, boolean positiveEntailment) {
        OntModel entailments = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        entailments.read(entailmentFileURI, entailmentFileURI, this.fileType(entailmentFileURI));
        Graph entailmentsGraph = entailments.getGraph();
        PelletInfGraph pellet = (PelletInfGraph)this.model.getGraph();
        GraphLoader savedLoader = pellet.attachTemporaryGraph(entailmentsGraph);
        ExtendedIterator i = entailmentsGraph.find(Triple.ANY);
        while (i.hasNext()) {
            Triple triple = (Triple)i.next();
            if (pellet.entails(triple)) continue;
            Assert.assertFalse((String)("Entailment failed for " + triple), (boolean)positiveEntailment);
            return;
        }
        pellet.detachTemporaryGraph(entailmentsGraph, savedLoader);
        Assert.assertTrue((String)"All axioms entailed in negative entailment test", (boolean)positiveEntailment);
    }

    @Override
    public void setInputOntology(String inputFileURI) {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        this.model.read(inputFileURI, inputFileURI, this.fileType(inputFileURI));
        this.model.prepare();
    }

    @Override
    public void setTimeout(long timeout) {
        ((PelletInfGraph)this.model.getGraph()).getKB().setTimeout(timeout);
    }

    @Override
    public void registerURIMapping(String fromURI, String toURI) {
        this.mapper.addAltEntry(fromURI, toURI);
    }

    private String fileType(String fileURI) {
        if (fileURI.endsWith(".n3")) {
            return "N3";
        }
        return "RDF/XML";
    }
}

