/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.inctest;

import com.clarkparsia.jena.test.AbstractJenaTests;
import com.clarkparsia.pellet.utils.PropertiesBuilder;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.PelletTestCase;

@RunWith(value=Parameterized.class)
public class IncJenaConsistencyTests
extends AbstractJenaTests {
    private Properties newOptions;
    private Properties oldOptions;

    @Parameterized.Parameters
    public static Collection<Object[]> getTestCases() {
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        cases.add(new Object[]{false, false, false});
        cases.add(new Object[]{true, false, false});
        cases.add(new Object[]{true, true, false});
        cases.add(new Object[]{true, true, true});
        return cases;
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(IncJenaConsistencyTests.class);
    }

    public IncJenaConsistencyTests(boolean ucq, boolean uic, boolean uid) {
        PropertiesBuilder pb = new PropertiesBuilder();
        pb.set("USE_COMPLETION_QUEUE", String.valueOf(ucq));
        pb.set("USE_INCREMENTAL_CONSISTENCY", String.valueOf(uic));
        pb.set("USE_INCREMENTAL_DELETION", String.valueOf(uid));
        this.newOptions = pb.build();
    }

    @Override
    @Before
    public void before() {
        this.oldOptions = PelletOptions.setOptions((Properties)this.newOptions);
        super.before();
    }

    @Override
    @After
    public void after() throws Exception {
        PelletOptions.setOptions((Properties)this.oldOptions);
        super.after();
    }

    @Test
    public void testTBoxChange() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRDFType(OWL.InverseFunctionalProperty);
        p.addRange(XSD.xboolean);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        Individual i1 = model.createIndividual(ns + "i1", (Resource)C);
        Individual i2 = model.createIndividual(ns + "i2", (Resource)C);
        Individual i3 = model.createIndividual(ns + "i3", (Resource)C);
        model.prepare();
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        D.addDisjointWith((Resource)E);
        Individual i4 = model.createIndividual(ns + "i4", (Resource)D);
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        model.prepare();
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(model.listIndividuals(), new Resource[]{i1, i2, i3, i4});
        i4.addRDFType((Resource)C);
        model.prepare();
        Assert.assertTrue((!PelletOptions.USE_INCREMENTAL_CONSISTENCY || graph.getKB().timers.getTimer("isIncConsistent").getCount() == 1L ? 1 : 0) != 0);
    }

    @Ignore(value="This test is know to fail when the processing order of disjoint axiom changes.")
    @Test
    public void testTypeAssertions() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRDFType(OWL.InverseFunctionalProperty);
        p.addRange(XSD.xboolean);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        D.addDisjointWith((Resource)E);
        RDFList conj = model.createList(new RDFNode[]{D, C});
        IntersectionClass CONJ = model.createIntersectionClass(null, conj);
        Individual i1 = model.createIndividual(ns + "i1", (Resource)C);
        i1.addRDFType((Resource)D);
        Individual i2 = model.createIndividual(ns + "i2", (Resource)C);
        i2.addRDFType((Resource)D);
        Individual i3 = model.createIndividual(ns + "i3", (Resource)C);
        i3.addRDFType((Resource)E);
        model.prepare();
        Individual i4 = model.createIndividual(ns + "i4", (Resource)D);
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        model.prepare();
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(model.listIndividuals(), new Resource[]{i1, i2, i3, i4});
        i4.addRDFType((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        model.prepare();
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        i4.addRDFType((Resource)E);
        Assert.assertFalse((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        i4.removeRDFType((Resource)E);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        ObjectProperty op = model.createObjectProperty(ns + "op");
        i2.addProperty((Property)op, (RDFNode)i4);
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
        i2.addRDFType((Resource)CONJ);
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent").getCount() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testPropertyAssertions() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        ObjectProperty op = model.createObjectProperty(ns + "op");
        OntClass C = model.createClass(ns + "C");
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Individual b = model.createIndividual(ns + "b", (Resource)C);
        Literal one = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        a.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)dp), new Literal[]{one});
        a.addProperty((Property)op, (RDFNode)b);
        model.prepare();
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)op), new Resource[]{b});
        Assert.assertTrue((!PelletOptions.USE_INCREMENTAL_CONSISTENCY || graph.getKB().timers.getTimer("isIncConsistent").getCount() == 1L ? 1 : 0) != 0);
        Literal two = model.createTypedLiteral("2", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        b.addProperty((Property)dp, (RDFNode)two);
        graph.getKB().isConsistent();
        PelletTestCase.assertIteratorValues(b.listPropertyValues((Property)dp), new Literal[]{two});
        Assert.assertTrue((!PelletOptions.USE_INCREMENTAL_CONSISTENCY || graph.getKB().timers.getTimer("isIncConsistent").getCount() == 2L ? 1 : 0) != 0);
    }

    @Test
    public void testBnodeUpdates() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        ObjectProperty op = model.createObjectProperty(ns + "op");
        OntClass C = model.createClass(ns + "C");
        Individual anon1 = model.createIndividual((Resource)C);
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Literal one = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        a.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        PelletInfGraph graph = (PelletInfGraph)model.getGraph();
        Assert.assertTrue((graph.getKB().timers.getTimer("isIncConsistent") == null ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)dp), new Literal[]{one});
        a.addProperty((Property)op, (RDFNode)anon1);
        model.prepare();
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)op), new Resource[]{anon1});
        Assert.assertTrue((!PelletOptions.USE_INCREMENTAL_CONSISTENCY || graph.getKB().timers.getTimer("isIncConsistent").getCount() > 0L ? 1 : 0) != 0);
        Individual anon2 = model.createIndividual((Resource)C);
        anon2.addProperty((Property)op, (RDFNode)a);
        model.prepare();
        PelletTestCase.assertIteratorValues(anon2.listPropertyValues((Property)op), new Resource[]{a});
        Assert.assertTrue((!PelletOptions.USE_INCREMENTAL_CONSISTENCY || graph.getKB().timers.getTimer("isIncConsistent").getCount() == 2L ? 1 : 0) != 0);
    }

    @Test
    public void testAnonClasses() {
        Assume.assumeTrue((boolean)PelletOptions.USE_INCREMENTAL_CONSISTENCY);
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String nc = "urn:test:";
        OntClass class1 = ontmodel.createClass(nc + "C1");
        OntClass class2 = ontmodel.createClass(nc + "C2");
        Individual[] inds = new Individual[6];
        for (int j = 0; j < 6; ++j) {
            inds[j] = ontmodel.createIndividual(nc + "Ind" + j, OWL.Thing);
        }
        inds[0].addRDFType((Resource)class1);
        inds[1].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class1);
        inds[3].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class2);
        inds[3].addRDFType((Resource)class2);
        inds[4].addRDFType((Resource)class2);
        inds[5].addRDFType((Resource)class2);
        ontmodel.prepare();
        PelletTestCase.assertIteratorValues(class1.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3]});
        PelletTestCase.assertIteratorValues(class2.listInstances(), new Resource[]{inds[2], inds[3], inds[4], inds[5]});
        PelletInfGraph graph = (PelletInfGraph)ontmodel.getGraph();
        long prevCount = graph.getKB().timers.getTimer("isIncConsistent") == null ? 0L : graph.getKB().timers.getTimer("isIncConsistent").getCount();
        inds[4].addRDFType((Resource)class1);
        inds[5].addRDFType((Resource)class1);
        ontmodel.prepare();
        PelletTestCase.assertIteratorValues(class1.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]});
        Assert.assertTrue((prevCount < graph.getKB().timers.getTimer("isIncConsistent").getCount() ? 1 : 0) != 0);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass class3 = ontmodel.createIntersectionClass(null, list);
        UnionClass class4 = ontmodel.createUnionClass(null, list);
        graph.getKB().timers.getTimer("isIncConsistent").reset();
        ontmodel.prepare();
        PelletTestCase.assertIteratorValues(class3.listInstances(), new Resource[]{inds[2], inds[3], inds[4], inds[5]});
        PelletTestCase.assertIteratorValues(class4.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]});
        Assert.assertEquals((long)0L, (long)graph.getKB().timers.getTimer("isIncConsistent").getCount());
        Individual newind = ontmodel.createIndividual(nc + "Ind7", (Resource)class4);
        ontmodel.prepare();
        PelletTestCase.assertIteratorValues(class4.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5], newind});
    }

    @Test
    public void testSimpleTypeAssertion() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass cls = model.createClass(ns + "C");
        Individual a = model.createIndividual(ns + "a", (Resource)cls);
        Assert.assertTrue((boolean)model.validate().isValid());
        a.addRDFType((Resource)cls);
        Assert.assertTrue((boolean)model.contains((Resource)a, RDF.type, (RDFNode)cls));
        PelletTestCase.assertIteratorValues(cls.listInstances(false), new Resource[]{a});
        PelletTestCase.assertIteratorValues(cls.listInstances(true), new Resource[]{a});
        Individual b = model.createIndividual(ns + "b", (Resource)cls);
        Assert.assertTrue((boolean)model.contains((Resource)b, RDF.type, (RDFNode)cls));
        PelletTestCase.assertIteratorValues(cls.listInstances(false), new Resource[]{a, b});
        PelletTestCase.assertIteratorValues(cls.listInstances(true), new Resource[]{a, b});
    }

    @Test
    public void testSimplePropertyAssertion() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        ObjectProperty q = model.createObjectProperty(ns + "q");
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        p.addSubProperty((Property)q);
        Model inferences = ModelFactory.createDefaultModel();
        PelletTestCase.assertPropertyValues((Model)model, (Property)q, inferences);
        model.add((Resource)a, (Property)q, (RDFNode)b);
        inferences = ModelFactory.createDefaultModel();
        inferences.add((Resource)a, (Property)p, (RDFNode)b);
        PelletTestCase.assertPropertyValues((Model)model, (Property)p, inferences);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        model.add((Resource)a, (Property)q, (RDFNode)c);
        inferences = ModelFactory.createDefaultModel();
        inferences.add((Resource)a, (Property)p, (RDFNode)b);
        inferences.add((Resource)a, (Property)p, (RDFNode)c);
        PelletTestCase.assertPropertyValues((Model)model, (Property)p, inferences);
    }

    @Test
    public void testSimpleDataPropertyAssertion() {
        Assume.assumeFalse((boolean)"true".equals(this.newOptions.getProperty("USE_INCREMENTAL_DELETION")));
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        DatatypeProperty q = model.createDatatypeProperty(ns + "q");
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Literal s1 = model.createLiteral("some test string 1");
        Literal s2 = model.createLiteral("some test string 2");
        p.addSubProperty((Property)q);
        Model inferences = ModelFactory.createDefaultModel();
        PelletTestCase.assertPropertyValues((Model)model, (Property)q, inferences);
        model.add((Resource)a, (Property)q, (RDFNode)s1);
        model.add((Resource)a, (Property)q, (RDFNode)s2);
        inferences = ModelFactory.createDefaultModel();
        inferences.add((Resource)a, (Property)p, (RDFNode)s1);
        inferences.add((Resource)a, (Property)p, (RDFNode)s2);
        PelletTestCase.assertPropertyValues((Model)model, (Property)p, inferences);
        model.remove((Resource)a, (Property)q, (RDFNode)s2);
        inferences = ModelFactory.createDefaultModel();
        inferences.add((Resource)a, (Property)p, (RDFNode)s1);
        PelletTestCase.assertPropertyValues((Model)model, (Property)p, inferences);
    }

    @Test
    public void addTypeToMergedNode() {
        this.classes(A, B, C);
        this.individuals(a, b, c);
        this.model.add(a, RDF.type, (RDFNode)this.oneOf(b, c));
        this.model.add(a, RDF.type, (RDFNode)A);
        this.model.add(b, RDF.type, (RDFNode)B);
        this.model.add(c, RDF.type, (RDFNode)C);
        this.assertConsistent();
        Assert.assertTrue((boolean)this.model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)B));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)C));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)D));
        this.model.add(a, RDF.type, (RDFNode)D);
        this.assertConsistent();
        Assert.assertTrue((boolean)this.model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)B));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)C));
        Assert.assertTrue((boolean)this.model.contains(a, RDF.type, (RDFNode)D));
    }

    @Test
    public void removeTypeFromMergedNode() {
        this.classes(A, B, C, D);
        this.individuals(a, b, c);
        this.model.add(a, RDF.type, (RDFNode)this.oneOf(b, c));
        this.model.add(a, RDF.type, (RDFNode)A);
        this.model.add(b, RDF.type, (RDFNode)B);
        this.model.add(c, RDF.type, (RDFNode)C);
        this.model.add(a, RDF.type, (RDFNode)D);
        this.assertConsistent();
        Assert.assertTrue((boolean)this.model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)B));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)C));
        Assert.assertTrue((boolean)this.model.contains(a, RDF.type, (RDFNode)D));
        this.model.remove(a, RDF.type, (RDFNode)D);
        this.assertConsistent();
        Assert.assertTrue((boolean)this.model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)B));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)C));
        Assert.assertFalse((boolean)this.model.contains(a, RDF.type, (RDFNode)D));
    }

    public static void main(String[] args) {
        IncJenaConsistencyTests test = new IncJenaConsistencyTests(true, true, false);
        test.before();
        test.testTBoxChange();
    }
}

