/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.SWRL;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;

public class MiscRuleTests
extends AbstractKBTests {
    public static final String base = "file:" + PelletTestSuite.base + "swrl-test/misc/";
    private static final IRI luigiFamily = IRI.create((String)"http://www.csc.liv.ac.uk/~luigi/ontologies/basicFamily");

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(MiscRuleTests.class);
    }

    private void nonTrivialBuiltInTest() {
        ATermAppl d1 = TermFactory.literal((String)"1", (ATermAppl)Datatypes.INT);
        ATermAppl d2 = TermFactory.literal((String)"2", (ATermAppl)Datatypes.INT);
        ATermAppl d12 = TermFactory.literal((String)"3", (ATermAppl)Datatypes.INTEGER);
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addDatatypeProperty((ATerm)q);
        this.kb.addDatatypeProperty((ATerm)r);
        this.kb.addIndividual(i);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.hasValue((ATermAppl)p, (ATermAppl)d1));
        this.kb.addSubClass(TermFactory.TOP, TermFactory.hasValue((ATermAppl)q, (ATermAppl)d2));
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable z1 = new AtomDVariable("z1");
        AtomDVariable z2 = new AtomDVariable("z2");
        AtomDVariable z3 = new AtomDVariable("z3");
        ArrayList<Object> body = new ArrayList<Object>();
        body.add(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z1));
        body.add(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)z2));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#add", new AtomDObject[]{z3, z1, z2}));
        ArrayList<DatavaluedPropertyAtom> head = new ArrayList<DatavaluedPropertyAtom>();
        head.add(new DatavaluedPropertyAtom(r, (AtomIObject)x, (AtomDObject)z3));
        this.kb.addRule(new Rule(head, body));
        this.kb.realize();
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, r, d12));
    }

    @Test
    public void builtInDateTime() {
        ATermAppl amy = TermFactory.term((String)"Amy");
        ATermAppl basil = TermFactory.term((String)"Basil");
        ATermAppl clara = TermFactory.term((String)"Clara");
        ATermAppl desmond = TermFactory.term((String)"Desmond");
        ATermAppl bDate = TermFactory.term((String)"bDate");
        ATermAppl bYear = TermFactory.term((String)"bYear");
        ATermAppl bMonth = TermFactory.term((String)"bMonth");
        ATermAppl bDay = TermFactory.term((String)"bDay");
        ATermAppl bTZ = TermFactory.term((String)"bTZ");
        this.kb.addDatatypeProperty((ATerm)bDate);
        this.kb.addDatatypeProperty((ATerm)bYear);
        this.kb.addDatatypeProperty((ATerm)bMonth);
        this.kb.addDatatypeProperty((ATerm)bDay);
        this.kb.addDatatypeProperty((ATerm)bTZ);
        this.kb.addIndividual(amy);
        this.kb.addPropertyValue(bDate, amy, TermFactory.literal((String)"2001-01-11", (ATermAppl)Datatypes.DATE));
        this.kb.addIndividual(basil);
        this.kb.addPropertyValue(bDate, basil, TermFactory.literal((String)"2002-02-12Z", (ATermAppl)Datatypes.DATE));
        this.kb.addIndividual(clara);
        this.kb.addPropertyValue(bYear, clara, TermFactory.literal((String)"2003", (ATermAppl)Datatypes.INTEGER));
        this.kb.addPropertyValue(bMonth, clara, TermFactory.literal((String)"3", (ATermAppl)Datatypes.INTEGER));
        this.kb.addPropertyValue(bDay, clara, TermFactory.literal((String)"13", (ATermAppl)Datatypes.INTEGER));
        this.kb.addIndividual(desmond);
        this.kb.addPropertyValue(bYear, desmond, TermFactory.literal((String)"2004", (ATermAppl)Datatypes.INTEGER));
        this.kb.addPropertyValue(bMonth, desmond, TermFactory.literal((String)"4", (ATermAppl)Datatypes.INTEGER));
        this.kb.addPropertyValue(bDay, desmond, TermFactory.literal((String)"14", (ATermAppl)Datatypes.INTEGER));
        this.kb.addPropertyValue(bTZ, desmond, TermFactory.literal((String)"+01:01"));
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable xDate = new AtomDVariable("xDate");
        AtomDVariable xYear = new AtomDVariable("xYear");
        AtomDVariable xMonth = new AtomDVariable("xMonth");
        AtomDVariable xDay = new AtomDVariable("xDay");
        AtomDVariable xTZ = new AtomDVariable("xTZ");
        BuiltInAtom dateBuiltIn = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#date", new AtomDObject[]{xDate, xYear, xMonth, xDay});
        BuiltInAtom dateBuiltInTZ = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#date", new AtomDObject[]{xDate, xYear, xMonth, xDay, xTZ});
        DatavaluedPropertyAtom bDateAtom = new DatavaluedPropertyAtom(bDate, (AtomIObject)x, (AtomDObject)xDate);
        DatavaluedPropertyAtom bYearAtom = new DatavaluedPropertyAtom(bYear, (AtomIObject)x, (AtomDObject)xYear);
        DatavaluedPropertyAtom bMonthAtom = new DatavaluedPropertyAtom(bMonth, (AtomIObject)x, (AtomDObject)xMonth);
        DatavaluedPropertyAtom bDayAtom = new DatavaluedPropertyAtom(bDay, (AtomIObject)x, (AtomDObject)xDay);
        DatavaluedPropertyAtom bTZAtom = new DatavaluedPropertyAtom(bTZ, (AtomIObject)x, (AtomDObject)xTZ);
        Rule fromDate = new Rule(Arrays.asList(bYearAtom, bMonthAtom, bDayAtom), Arrays.asList(dateBuiltIn, bDateAtom));
        this.kb.addRule(fromDate);
        Rule fromDateTZ = new Rule(Arrays.asList(bYearAtom, bMonthAtom, bDayAtom, bTZAtom), Arrays.asList(dateBuiltInTZ, bDateAtom));
        this.kb.addRule(fromDateTZ);
        Rule toDate = new Rule(Arrays.asList(bDateAtom), Arrays.asList(dateBuiltIn, bYearAtom, bMonthAtom, bDayAtom));
        this.kb.addRule(toDate);
        Rule toDateTZ = new Rule(Arrays.asList(bDateAtom), Arrays.asList(dateBuiltInTZ, bYearAtom, bMonthAtom, bDayAtom, bTZAtom));
        this.kb.addRule(toDateTZ);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(amy, bYear, TermFactory.literal((String)"2001", (ATermAppl)Datatypes.INTEGER)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(amy, bMonth, TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(amy, bDay, TermFactory.literal((String)"11", (ATermAppl)Datatypes.INTEGER)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(basil, bYear, TermFactory.literal((String)"2002", (ATermAppl)Datatypes.INTEGER)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(basil, bMonth, TermFactory.literal((String)"2", (ATermAppl)Datatypes.INTEGER)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(basil, bDay, TermFactory.literal((String)"12", (ATermAppl)Datatypes.INTEGER)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(basil, bTZ, TermFactory.literal((String)"Z")));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(clara, bDate, TermFactory.literal((String)"2003-03-13", (ATermAppl)Datatypes.DATE)));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(desmond, bDate, TermFactory.literal((String)"2004-04-14+01:01", (ATermAppl)Datatypes.DATE)));
    }

    @Test
    public void builtInMath() {
        ATermAppl d1 = TermFactory.literal((String)"1", (ATermAppl)Datatypes.INT);
        ATermAppl d2 = TermFactory.literal((String)"1.5", (ATermAppl)Datatypes.FLOAT);
        ATermAppl dif11 = TermFactory.literal((String)"0", (ATermAppl)Datatypes.INTEGER);
        ATermAppl dif12 = TermFactory.literal((String)"-0.5", (ATermAppl)Datatypes.FLOAT);
        ATermAppl dif21 = TermFactory.literal((String)"0.5", (ATermAppl)Datatypes.FLOAT);
        ATermAppl dif22 = TermFactory.literal((String)"0", (ATermAppl)Datatypes.FLOAT);
        ATermAppl prod11 = TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER);
        ATermAppl prod12 = TermFactory.literal((String)"1.5", (ATermAppl)Datatypes.FLOAT);
        ATermAppl prod22 = TermFactory.literal((String)"2.25", (ATermAppl)Datatypes.FLOAT);
        ATermAppl quot11 = TermFactory.literal((String)"1", (ATermAppl)Datatypes.DECIMAL);
        ATermAppl quot12 = TermFactory.literal((String)Float.toString(0.6666667f), (ATermAppl)Datatypes.FLOAT);
        ATermAppl quot21 = TermFactory.literal((String)"1.5", (ATermAppl)Datatypes.FLOAT);
        ATermAppl quot22 = TermFactory.literal((String)"1", (ATermAppl)Datatypes.FLOAT);
        ATermAppl sum11 = TermFactory.literal((String)"2", (ATermAppl)Datatypes.INTEGER);
        ATermAppl sum12 = TermFactory.literal((String)"2.5", (ATermAppl)Datatypes.FLOAT);
        ATermAppl sum22 = TermFactory.literal((String)"3.0", (ATermAppl)Datatypes.FLOAT);
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl sum = TermFactory.term((String)"sum");
        ATermAppl product = TermFactory.term((String)"product");
        ATermAppl difference = TermFactory.term((String)"difference");
        ATermAppl quotient = TermFactory.term((String)"quotient");
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addDatatypeProperty((ATerm)sum);
        this.kb.addDatatypeProperty((ATerm)difference);
        this.kb.addDatatypeProperty((ATerm)product);
        this.kb.addDatatypeProperty((ATerm)quotient);
        this.kb.addIndividual(i);
        this.kb.addPropertyValue(p, i, d1);
        this.kb.addPropertyValue(p, i, d2);
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable z1 = new AtomDVariable("z1");
        AtomDVariable z2 = new AtomDVariable("z2");
        AtomDVariable z3 = new AtomDVariable("z3");
        AtomDVariable z4 = new AtomDVariable("z4");
        AtomDVariable z5 = new AtomDVariable("z5");
        AtomDVariable z6 = new AtomDVariable("z6");
        ArrayList<Object> body = new ArrayList<Object>();
        body.add(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z1));
        body.add(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z2));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#add", new AtomDObject[]{z3, z1, z2}));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#subtract", new AtomDObject[]{z4, z1, z2}));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#multiply", new AtomDObject[]{z5, z1, z2}));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#divide", new AtomDObject[]{z6, z1, z2}));
        ArrayList<DatavaluedPropertyAtom> head = new ArrayList<DatavaluedPropertyAtom>();
        head.add(new DatavaluedPropertyAtom(sum, (AtomIObject)x, (AtomDObject)z3));
        head.add(new DatavaluedPropertyAtom(difference, (AtomIObject)x, (AtomDObject)z4));
        head.add(new DatavaluedPropertyAtom(product, (AtomIObject)x, (AtomDObject)z5));
        head.add(new DatavaluedPropertyAtom(quotient, (AtomIObject)x, (AtomDObject)z6));
        Rule rule = new Rule(head, body);
        this.kb.addRule(rule);
        this.kb.realize();
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, sum, sum11));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, sum, sum12));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, sum, sum22));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, difference, dif11));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, difference, dif12));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, difference, dif21));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, difference, dif22));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, product, prod11));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, product, prod12));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, product, prod22));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, quotient, quot11));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, quotient, quot12));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, quotient, quot21));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(i, quotient, quot22));
    }

    @Test
    public void builtInNonTrivialOldStrategy() {
        boolean whichStrategy = PelletOptions.USE_CONTINUOUS_RULES;
        PelletOptions.USE_CONTINUOUS_RULES = false;
        try {
            this.nonTrivialBuiltInTest();
        }
        finally {
            PelletOptions.USE_CONTINUOUS_RULES = whichStrategy;
        }
    }

    @Test
    public void builtInNonTrivialNewStrategy() {
        boolean whichStrategy = PelletOptions.USE_CONTINUOUS_RULES;
        PelletOptions.USE_CONTINUOUS_RULES = true;
        try {
            this.nonTrivialBuiltInTest();
        }
        finally {
            PelletOptions.USE_CONTINUOUS_RULES = whichStrategy;
        }
    }

    @Test
    public void dataPropertyChain1() {
        ATermAppl d = TermFactory.literal((String)"d");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl k = TermFactory.term((String)"k");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)r);
        this.kb.addIndividual(i);
        this.kb.addIndividual(j);
        this.kb.addIndividual(k);
        this.kb.addPropertyValue(p, i, d);
        this.kb.addPropertyValue(r, i, j);
        this.kb.addPropertyValue(r, j, k);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        IndividualPropertyAtom body1 = new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y);
        DatavaluedPropertyAtom body2 = new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z);
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)z);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        this.kb.addRule(rule);
        this.kb.realize();
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(j, p, d));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(k, p, d));
    }

    @Test
    public void dataPropertyChain2() {
        ATermAppl d = TermFactory.literal((String)"d");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl k = TermFactory.term((String)"k");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)r);
        this.kb.addIndividual(i);
        this.kb.addIndividual(j);
        this.kb.addIndividual(k);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{i, j, k}));
        this.kb.addSubClass(TermFactory.TOP, TermFactory.min((ATermAppl)r, (int)3, (ATermAppl)TermFactory.TOP));
        this.kb.addPropertyValue(p, i, d);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        IndividualPropertyAtom body1 = new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y);
        DatavaluedPropertyAtom body2 = new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z);
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)z);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        this.kb.addRule(rule);
        this.kb.realize();
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(j, p, d));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(k, p, d));
    }

    @Test
    public void inferredProperties() throws Exception {
        ATermAppl d = TermFactory.literal((String)"foo");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl k = TermFactory.term((String)"k");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addIndividual(i);
        this.kb.addIndividual(j);
        this.kb.addIndividual(k);
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)r);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.min((ATermAppl)r, (int)3, (ATermAppl)TermFactory.TOP));
        this.kb.addSubClass(TermFactory.TOP, TermFactory.or((ATermAppl[])new ATermAppl[]{TermFactory.value((ATermAppl)i), TermFactory.value((ATermAppl)j), TermFactory.value((ATermAppl)k)}));
        this.kb.addPropertyValue(p, i, d);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z);
        DatavaluedPropertyAtom body1 = new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)z);
        IndividualPropertyAtom body2 = new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        this.kb.addRule(rule);
        this.kb.ensureConsistency();
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(j, r, i));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(k, r, i));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(j, p, d));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(k, p, d));
    }

    @Test
    public void testRuleIndividuals() throws Exception {
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl d = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        this.kb.addClass(c);
        this.kb.addClass(d);
        this.kb.addIndividual(i);
        this.kb.addType(i, c);
        this.kb.addRule(new Rule(Arrays.asList(new ClassAtom(d, (AtomIObject)new AtomIConstant(i))), Arrays.asList(new ClassAtom(c, (AtomIObject)new AtomIConstant(i)))));
        this.kb.realize();
        Assert.assertTrue((boolean)this.kb.getTypes(i).contains(Collections.singleton(d)));
    }

    @Test
    public void testRuleEquality() {
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        this.kb.addIndividual(i);
        this.kb.addIndividual(j);
        this.kb.addObjectProperty((ATerm)r);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.min((ATermAppl)r, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addSubClass(TermFactory.TOP, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{i, j}));
        this.kb.addRule(new Rule(Collections.singletonList(new DifferentIndividualsAtom((AtomIObject)x, (AtomIObject)y)), Collections.singletonList(new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y))));
        this.kb.realize();
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(i, j));
    }

    public void testLuigiFamilyJena() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ontModel.read(base + "basicFamilyReference.owl");
        ontModel.read(base + "basicFamilyRules.owl");
        Resource nella = ontModel.createResource(luigiFamily.resolve("#Nella").toString());
        Property hasUncle = ontModel.createProperty(luigiFamily.resolve("#hasUncle").toString());
        Resource dino = ontModel.createResource(luigiFamily.resolve("#Dino").toString());
        Assert.assertFalse((boolean)ontModel.contains(nella, hasUncle, (RDFNode)dino));
    }

    public void testLuigiFamilyOWLApi() throws Exception {
        OWLOntologyManager manager = OWL.manager;
        OWLOntology familyRef = manager.loadOntology(IRI.create((String)(base + "basicFamilyReference.owl")));
        OWLOntology familyRules = manager.loadOntology(IRI.create((String)(base + "basicFamilyRules.owl")));
        HashSet axioms = new HashSet();
        axioms.addAll(familyRef.getAxioms());
        axioms.addAll(familyRules.getAxioms());
        OWLOntology mergedOntology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(mergedOntology);
        OWLNamedIndividual nella = OWL.Individual((IRI)luigiFamily.resolve("#Nella"));
        OWLObjectProperty hasUncle = OWL.ObjectProperty((IRI)luigiFamily.resolve("#hasUncle"));
        OWLNamedIndividual dino = OWL.Individual((IRI)luigiFamily.resolve("#Dino"));
        Assert.assertFalse((boolean)reasoner.isEntailed((OWLAxiom)OWL.propertyAssertion((OWLIndividual)nella, (OWLObjectPropertyExpression)hasUncle, (OWLIndividual)dino)));
    }

    public void testUncleRule() {
        ATermAppl hasParent = TermFactory.term((String)"hasParent");
        ATermAppl hasSibling = TermFactory.term((String)"hasSibling");
        ATermAppl hasUncle = TermFactory.term((String)"hasUncle");
        ATermAppl male = TermFactory.term((String)"Male");
        ATermAppl c11 = TermFactory.term((String)"c11");
        ATermAppl c12 = TermFactory.term((String)"c12");
        ATermAppl p1a = TermFactory.term((String)"p1a");
        ATermAppl p2a = TermFactory.term((String)"p2a");
        this.kb.addClass(male);
        this.kb.addObjectProperty((ATerm)hasParent);
        this.kb.addObjectProperty((ATerm)hasSibling);
        this.kb.addObjectProperty((ATerm)hasUncle);
        this.kb.addIndividual(c11);
        this.kb.addIndividual(c12);
        this.kb.addIndividual(p1a);
        this.kb.addIndividual(p2a);
        this.kb.addPropertyValue(hasParent, c11, p1a);
        this.kb.addPropertyValue(hasSibling, c11, c12);
        this.kb.addPropertyValue(hasParent, c12, p1a);
        this.kb.addPropertyValue(hasSibling, c12, c11);
        this.kb.addPropertyValue(hasSibling, p1a, p2a);
        this.kb.addType(p2a, male);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomIVariable z = new AtomIVariable("z");
        this.kb.addRule(new Rule(Arrays.asList(new IndividualPropertyAtom(hasUncle, (AtomIObject)y, (AtomIObject)z)), Arrays.asList(new IndividualPropertyAtom(hasParent, (AtomIObject)y, (AtomIObject)x), new ClassAtom(male, (AtomIObject)z), new IndividualPropertyAtom(hasSibling, (AtomIObject)x, (AtomIObject)z))));
        PelletTestCase.assertIteratorValues(this.kb.getObjectPropertyValues(hasUncle, c11).iterator(), p2a);
    }

    public void testVariableUtils1() {
        AtomIVariable var1 = new AtomIVariable("var1");
        AtomIVariable var2 = new AtomIVariable("var2");
        SameIndividualAtom atom = new SameIndividualAtom((AtomIObject)var1, (AtomIObject)var2);
        PelletTestCase.assertIteratorValues(VariableUtils.getVars((RuleAtom)atom).iterator(), var1, var2);
    }

    public void testVariableUtils2() {
        ATermAppl p = TermFactory.term((String)"p");
        AtomIVariable var1 = new AtomIVariable("var1");
        AtomIVariable var2 = new AtomIVariable("var2");
        IndividualPropertyAtom atom = new IndividualPropertyAtom(p, (AtomIObject)var1, (AtomIObject)var2);
        PelletTestCase.assertIteratorValues(VariableUtils.getVars((RuleAtom)atom).iterator(), var1, var2);
    }

    @Test
    public void reteRestoreTest1() {
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl G = TermFactory.term((String)"G");
        ATermAppl H = TermFactory.term((String)"H");
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addIndividual(x);
        this.kb.addIndividual(y);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addClass(A);
        this.kb.addClass(B);
        this.kb.addClass(C);
        this.kb.addClass(G);
        this.kb.addClass(H);
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addType(c, C);
        this.kb.addType(x, TermFactory.or((ATermAppl)G, (ATermAppl)TermFactory.all((ATermAppl)q, (ATermAppl)TermFactory.not((ATermAppl)H))));
        this.kb.addType(x, TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        this.kb.addType(y, H);
        this.kb.addPropertyValue(p, x, a);
        this.kb.addPropertyValue(p, x, b);
        this.kb.addPropertyValue(p, x, c);
        AtomIVariable v = new AtomIVariable("v");
        ClassAtom body = new ClassAtom(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)A, (ATermAppl)B), (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)A, (ATermAppl)C), (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)C)))), (AtomIObject)v);
        IndividualPropertyAtom head = new IndividualPropertyAtom(q, (AtomIObject)v, (AtomIObject)new AtomIConstant(y));
        Rule rule = new Rule(Collections.singleton(head), Collections.singleton(body));
        this.kb.addRule(rule);
        v = new AtomIVariable("v");
        body = new ClassAtom(G, (AtomIObject)v);
        head = new IndividualPropertyAtom(p, (AtomIObject)v, (AtomIObject)new AtomIConstant(y));
        rule = new Rule(Collections.singleton(head), Collections.singleton(body));
        this.kb.addRule(rule);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        System.err.println("***************************");
        System.err.println(this.kb.getPropertyValues(p, x));
        PelletTestCase.assertIteratorValues(this.kb.getPropertyValues(p, x).iterator(), a, b, c, y);
        Assert.assertEquals(Collections.singletonList(y), (Object)this.kb.getPropertyValues(q, x));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(x, q, c));
    }

    @Test
    public void testQualifiedCardinality() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl p = TermFactory.term((String)"p");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addClass(E);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addType(b, C);
        this.kb.addType(c, C);
        this.kb.addEquivalentClass(D, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)E));
        this.kb.addEquivalentClass(E, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, a, c);
        this.kb.addPropertyValue(p, b, b);
        this.kb.addPropertyValue(p, c, c);
        this.kb.addDifferent(b, c);
        AtomIVariable x = new AtomIVariable("x");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)x));
        ArrayList<ClassAtom> head = new ArrayList<ClassAtom>();
        head.add(new ClassAtom(C, (AtomIObject)x));
        Rule rule = new Rule(head, body);
        this.kb.addRule(rule);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        Assert.assertTrue((boolean)this.kb.isType(b, E));
        Assert.assertTrue((boolean)this.kb.isType(c, E));
    }

    @Test
    public void reteRestoreTest2() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addType(b, C);
        AtomIVariable x = new AtomIVariable("x");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)x));
        ArrayList<ClassAtom> head = new ArrayList<ClassAtom>();
        head.add(new ClassAtom(D, (AtomIObject)x));
        Rule rule = new Rule(head, body);
        this.kb.addRule(rule);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, D));
        Assert.assertFalse((boolean)this.kb.isDifferentFrom(a, b));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
    }

    @Test
    public void testEmptyRuleHead1() {
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        AtomIVariable x = new AtomIVariable("x");
        this.kb.addClass(C);
        this.kb.addIndividual(i);
        this.kb.addType(i, C);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(C, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead2() {
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        AtomIVariable x = new AtomIVariable("x");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addSubClass(C, D);
        this.kb.addIndividual(i);
        this.kb.addType(i, C);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(C, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead3() {
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        AtomIVariable x = new AtomIVariable("x");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addSubClass(C, D);
        this.kb.addIndividual(i);
        this.kb.addType(i, D);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(D, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead4() {
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl R = TermFactory.term((String)"R");
        ATermAppl l = TermFactory.literal((String)"l");
        AtomIVariable v = new AtomIVariable("v");
        AtomDConstant c = new AtomDConstant(l);
        this.kb.addIndividual(i);
        this.kb.addDatatypeProperty((ATerm)R);
        this.kb.addPropertyValue(R, i, l);
        ArrayList<DatavaluedPropertyAtom> body = new ArrayList<DatavaluedPropertyAtom>();
        ArrayList head = new ArrayList();
        body.add(new DatavaluedPropertyAtom(R, (AtomIObject)v, (AtomDObject)c));
        this.kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead5() {
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl CuD = TermFactory.or((ATermAppl)C, (ATermAppl)D);
        AtomIVariable x = new AtomIVariable("x");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addClass(CuD);
        this.kb.addIndividual(i);
        this.kb.addType(i, C);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(CuD, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @Test
    public void testTransitiveProperty() {
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addTransitiveProperty(p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, b, c);
        ArrayList<IndividualPropertyAtom> body = new ArrayList<IndividualPropertyAtom>();
        ArrayList<IndividualPropertyAtom> head = new ArrayList<IndividualPropertyAtom>();
        body.add(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)y));
        head.add(new IndividualPropertyAtom(q, (AtomIObject)x, (AtomIObject)y));
        this.kb.addRule(new Rule(head, body));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, c));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(b, p, c));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, q, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, q, c));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(b, q, c));
        Map results = this.kb.getPropertyValues(p);
        PelletTestCase.assertIteratorValues(((List)results.get(b)).iterator(), c);
        PelletTestCase.assertIteratorValues(((List)results.get(a)).iterator(), b, c);
        results = this.kb.getPropertyValues(q);
        PelletTestCase.assertIteratorValues(((List)results.get(b)).iterator(), c);
        PelletTestCase.assertIteratorValues(((List)results.get(a)).iterator(), b, c);
    }

    @Test
    public void testUnsafeVariable() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addEquivalentClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP));
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)x));
        ArrayList<IndividualPropertyAtom> head = new ArrayList<IndividualPropertyAtom>();
        head.add(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)y));
        Rule rule = new Rule(head, body);
        this.kb.addRule(rule);
        Assert.assertEquals(Collections.singleton(rule), (Object)this.kb.getRules());
        Assert.assertNull(this.kb.getNormalizedRules().get(rule));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, C));
    }

    @Test
    public void reflexiveRule() {
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        this.kb.addClass(A);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addPropertyValue(p, a, a);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addPropertyValue(p, b, c);
        AtomIVariable x = new AtomIVariable("x");
        List<RuleAtom> body = Arrays.asList(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)x));
        List<RuleAtom> head = Arrays.asList(new ClassAtom(A, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(b, A));
        Assert.assertFalse((boolean)this.kb.isType(c, A));
    }

    @Test
    public void propertyAtomWithAConstant() {
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        this.kb.addClass(A);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, b, c);
        this.kb.addPropertyValue(p, c, c);
        AtomIVariable x = new AtomIVariable("x");
        List<RuleAtom> body = Arrays.asList(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)new AtomIConstant(c)));
        List<RuleAtom> head = Arrays.asList(new ClassAtom(A, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(a, A));
        Assert.assertTrue((boolean)this.kb.isType(b, A));
        Assert.assertTrue((boolean)this.kb.isType(c, A));
    }

    @Test
    public void complexConsequent() {
        HashSet<SWRLClassAtom> bodyAtoms = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> headAtoms = new HashSet<SWRLClassAtom>();
        OWLNamedIndividual individualA = OWL.Individual((String)"a");
        OWLClass classC = OWL.Class((String)"C");
        OWLClass classD = OWL.Class((String)"D");
        OWLClass classE = OWL.Class((String)"E");
        OWLObjectProperty propertyP = OWL.ObjectProperty((String)"p");
        SWRLVariable variable = SWRL.variable((String)"x");
        OWLObjectSomeValuesFrom restriction = OWL.some((OWLObjectPropertyExpression)propertyP, (OWLClassExpression)classD);
        bodyAtoms.add(SWRL.classAtom((OWLClassExpression)classC, (SWRLIArgument)variable));
        headAtoms.add(SWRL.classAtom((OWLClassExpression)restriction, (SWRLIArgument)variable));
        OWLAxiom[] axioms = new OWLAxiom[]{SWRL.rule(bodyAtoms, headAtoms), OWL.equivalentClasses((OWLClassExpression)classE, (OWLClassExpression)restriction), OWL.classAssertion((OWLIndividual)individualA, (OWLClassExpression)classC), OWL.classAssertion((OWLIndividual)individualA, (OWLClassExpression)classE)};
        OWLOntology ontology = OWL.Ontology((OWLAxiom[])axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createNonBufferingReasoner(ontology);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        Assert.assertTrue((boolean)reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)individualA, (OWLClassExpression)classE)));
        OWL.manager.removeOntology(ontology);
    }

    @Test
    public void testDifferentFromInBody() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ontModel.read(base + "sibling-rule.n3", "TTL");
        Resource alice = ontModel.createResource("family:alice");
        Property sibling = ontModel.createProperty("family:sibling");
        Resource bob = ontModel.createResource("family:bob");
        Assert.assertTrue((boolean)ontModel.contains(alice, sibling, (RDFNode)bob));
        Assert.assertTrue((boolean)ontModel.contains(bob, sibling, (RDFNode)alice));
        Assert.assertEquals(Collections.singletonList(bob), (Object)ontModel.listObjectsOfProperty(alice, sibling).toList());
        Assert.assertEquals(Collections.singletonList(alice), (Object)ontModel.listObjectsOfProperty(bob, sibling).toList());
    }

    @Test
    public void testRepeatedVars() throws Exception {
        StringDocumentSource source = new StringDocumentSource("Prefix(owl:=<http://www.w3.org/2002/07/owl#>)\nPrefix(rdf:=<http://www.w3.org/1999/02/22-rdf-syntax-ns#>)\nPrefix(xml:=<http://www.w3.org/XML/1998/namespace>)\nPrefix(xsd:=<http://www.w3.org/2001/XMLSchema#>)\nPrefix(rdfs:=<http://www.w3.org/2000/01/rdf-schema#>)\n\nOntology(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215>\nImport(<http://www.w3.org/2006/time>)\n\nEquivalentClasses(<http://www.w3.org/2006/time#Instant> ObjectHasSelf(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#R_Instant>))\nDeclaration(ObjectProperty(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#R_Instant>))\nDeclaration(NamedIndividual(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#Instant1>))\nClassAssertion(<http://www.w3.org/2006/time#Instant> <http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#Instant1>)\nDataPropertyAssertion(<http://www.w3.org/2006/time#inXSDDateTime> <http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#Instant1> \"2000-01-01T00:00:00\"^^xsd:dateTime)\nDeclaration(NamedIndividual(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#Instant2>))\nClassAssertion(<http://www.w3.org/2006/time#Instant> <http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#Instant2>)\nDataPropertyAssertion(<http://www.w3.org/2006/time#inXSDDateTime> <http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#Instant2> \"2003-01-01T00:00:00\"^^xsd:dateTime)\nDLSafeRule(Body(ObjectPropertyAtom(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#R_Instant> Variable(<urn:swrl#x>) Variable(<urn:swrl#x>)) ObjectPropertyAtom(<http://www.semanticweb.org/ontologies/2014/3/untitled-ontology-215#R_Instant> Variable(<urn:swrl#z>) Variable(<urn:swrl#z>)) DataPropertyAtom(<http://www.w3.org/2006/time#inXSDDateTime> Variable(<urn:swrl#x>) Variable(<urn:swrl#y>)) DataPropertyAtom(<http://www.w3.org/2006/time#inXSDDateTime> Variable(<urn:swrl#z>) Variable(<urn:swrl#w>)) BuiltInAtom(<http://www.w3.org/2003/11/swrlb#lessThan> Variable(<urn:swrl#y>) Variable(<urn:swrl#w>)))Head(ObjectPropertyAtom(<http://www.w3.org/2006/time#before> Variable(<urn:swrl#x>) Variable(<urn:swrl#z>))))\n)");
        OWLOntology ont = OWL.manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)source);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ont);
        reasoner.getKB().realize();
    }

    @Test
    public void testNoVarPropertyAtom() {
        this.classes(A);
        this.dataProperties(p, q);
        this.individuals(a, b);
        this.kb.addType(a, A);
        this.kb.addPropertyValue(p, b, TermFactory.literal((boolean)true));
        ATermAppl t = TermFactory.literal((String)"t");
        ATermAppl f = TermFactory.literal((String)"f");
        AtomIVariable x = new AtomIVariable("x");
        List<RuleAtom> body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new DatavaluedPropertyAtom(p, (AtomIObject)new AtomIConstant(b), (AtomDObject)new AtomDConstant(TermFactory.literal((boolean)true))));
        List<RuleAtom> head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(t)));
        this.kb.addRule(new Rule(head, body));
        body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new DatavaluedPropertyAtom(p, (AtomIObject)new AtomIConstant(b), (AtomDObject)new AtomDConstant(TermFactory.literal((boolean)false))));
        head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(f)));
        this.kb.addRule(new Rule(head, body));
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, a).iterator(), t);
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, b).iterator(), new ATermAppl[0]);
    }

    @Test
    public void testNoVarTypeAtom() {
        this.classes(A, B, C);
        this.dataProperties(q);
        this.individuals(a, b);
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        ATermAppl t = TermFactory.literal((String)"t");
        ATermAppl f = TermFactory.literal((String)"f");
        AtomIVariable x = new AtomIVariable("x");
        List<RuleAtom> body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new ClassAtom(B, (AtomIObject)new AtomIConstant(b)));
        List<RuleAtom> head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(t)));
        this.kb.addRule(new Rule(head, body));
        body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new ClassAtom(A, (AtomIObject)new AtomIConstant(b)));
        head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(f)));
        this.kb.addRule(new Rule(head, body));
        body = Arrays.asList(new ClassAtom(B, (AtomIObject)x));
        head = Arrays.asList(new ClassAtom(C, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, a).iterator(), t);
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, b).iterator(), new ATermAppl[0]);
        PelletTestCase.assertIteratorValues(this.kb.getInstances(C).iterator(), b);
    }

    @Test
    public void testNoSharedVar() {
        this.classes(A);
        this.dataProperties(p, q);
        this.objectProperties(r);
        this.individuals(a, b, c);
        this.kb.addType(a, A);
        this.kb.addPropertyValue(p, b, TermFactory.literal((boolean)true));
        this.kb.addPropertyValue(r, b, c);
        ATermAppl t = TermFactory.literal((String)"t");
        ATermAppl f = TermFactory.literal((String)"f");
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable y = new AtomDVariable("y");
        List<RuleAtom> body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new DatavaluedPropertyAtom(p, (AtomIObject)new AtomIConstant(b), (AtomDObject)y), new BuiltInAtom("http://www.w3.org/2003/11/swrlb#equal", new AtomDObject[]{y, new AtomDConstant(TermFactory.literal((boolean)true))}));
        List<RuleAtom> head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(t)));
        this.kb.addRule(new Rule(head, body));
        body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new DatavaluedPropertyAtom(p, (AtomIObject)new AtomIConstant(b), (AtomDObject)y), new BuiltInAtom("http://www.w3.org/2003/11/swrlb#equal", new AtomDObject[]{y, new AtomDConstant(TermFactory.literal((boolean)false))}));
        head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(f)));
        this.kb.addRule(new Rule(head, body));
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, a).iterator(), t);
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, b).iterator(), new ATermAppl[0]);
    }

    @Test
    public void testNoSharedVarFixedObject() {
        this.classes(A);
        this.dataProperties(p, q);
        this.objectProperties(r, s);
        this.individuals(a, b, c, d);
        this.kb.addType(a, A);
        this.kb.addPropertyValue(r, c, b);
        this.kb.addPropertyValue(p, c, TermFactory.literal((boolean)true));
        this.kb.addPropertyValue(s, d, b);
        this.kb.addPropertyValue(p, d, TermFactory.literal((boolean)false));
        ATermAppl t = TermFactory.literal((String)"t");
        ATermAppl f = TermFactory.literal((String)"f");
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        List<RuleAtom> body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new IndividualPropertyAtom(r, (AtomIObject)y, (AtomIObject)new AtomIConstant(b)), new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)new AtomDConstant(TermFactory.literal((boolean)true))));
        List<RuleAtom> head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(t)));
        this.kb.addRule(new Rule(head, body));
        body = Arrays.asList(new ClassAtom(A, (AtomIObject)x), new IndividualPropertyAtom(r, (AtomIObject)y, (AtomIObject)new AtomIConstant(b)), new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)new AtomDConstant(TermFactory.literal((boolean)false))));
        head = Arrays.asList(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)new AtomDConstant(f)));
        this.kb.addRule(new Rule(head, body));
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, a).iterator(), t);
        PelletTestCase.assertIteratorValues(this.kb.getDataPropertyValues(q, b).iterator(), new ATermAppl[0]);
    }

    @Test
    public void testBindingBuiltins() {
        this.classes(A);
        this.dataProperties(p, q);
        this.individuals(a, b, c, d);
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)1));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)5));
        this.kb.addPropertyValue(p, c, TermFactory.literal((int)10));
        this.kb.addPropertyValue(p, d, TermFactory.literal((int)15));
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable y = new AtomDVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        List<RuleAtom> body = Arrays.asList(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)y), new BuiltInAtom("http://www.w3.org/2003/11/swrlb#pow", new AtomDObject[]{z, y, new AtomDConstant(TermFactory.literal((int)2))}), new BuiltInAtom("http://www.w3.org/2003/11/swrlb#lessThan", new AtomDObject[]{z, new AtomDConstant(TermFactory.literal((int)100))}));
        List<RuleAtom> head = Arrays.asList(new ClassAtom(A, (AtomIObject)x));
        this.kb.addRule(new Rule(head, body));
        PelletTestCase.assertIteratorValues(this.kb.getInstances(A).iterator(), a, b);
    }

    @Test
    public void testTriangle() {
        this.objectProperties(p, q);
        this.individuals(a, b, c, d, e);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, b, c);
        this.kb.addPropertyValue(p, a, c);
        this.kb.addPropertyValue(p, b, e);
        this.kb.addPropertyValue(p, c, e);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomIVariable z = new AtomIVariable("z");
        List<RuleAtom> body = Arrays.asList(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)y), new IndividualPropertyAtom(p, (AtomIObject)y, (AtomIObject)z), new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)z));
        List<RuleAtom> head = Arrays.asList(new IndividualPropertyAtom(q, (AtomIObject)x, (AtomIObject)z));
        this.kb.addRule(new Rule(head, body));
        PelletTestCase.assertIteratorValues(this.kb.getObjectPropertyValues(q, a).iterator(), c);
        PelletTestCase.assertIteratorValues(this.kb.getObjectPropertyValues(q, b).iterator(), e);
        PelletTestCase.assertIteratorValues(this.kb.getObjectPropertyValues(q, c).iterator(), new ATermAppl[0]);
        PelletTestCase.assertIteratorValues(this.kb.getObjectPropertyValues(q, d).iterator(), new ATermAppl[0]);
    }
}

