/*
 * Decompiled with CFR 0.152.
 */
package com.github.sgov.server;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.progress.SimpleProgressMonitor;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.rules.RuleUtil;
import org.topbraid.shacl.validation.ResourceValidationReport;
import org.topbraid.shacl.validation.ValidationReport;
import org.topbraid.shacl.validation.ValidationUtil;

public class Validator {
    private final Set<URL> glossaryRules = new HashSet<URL>();
    private final Set<URL> modelRules = new HashSet<URL>();
    private final Set<URL> vocabularyRules = new HashSet<URL>();

    public Validator() {
        int i;
        for (i = 1; i <= 12; ++i) {
            this.glossaryRules.add(this.resource("g" + i));
        }
        for (i = 1; i <= 7; ++i) {
            this.modelRules.add(this.resource("m" + i));
        }
        for (i = 1; i <= 2; ++i) {
            this.vocabularyRules.add(this.resource("s" + i));
        }
    }

    private URL resource(String name) {
        return this.getClass().getResource("/rules/" + name + ".ttl");
    }

    public Set<URL> getModelRules() {
        return this.modelRules;
    }

    public Set<URL> getGlossaryRules() {
        return this.glossaryRules;
    }

    public Set<URL> getVocabularyRules() {
        return this.vocabularyRules;
    }

    private Model getRulesModel(Collection<URL> rules) throws IOException {
        Model shapesModel = JenaUtil.createMemoryModel();
        for (URL r : rules) {
            shapesModel.read(r.openStream(), null, "TURTLE");
        }
        return shapesModel;
    }

    public ValidationReport validate(Model dataModel, Set<URL> ruleSet, Model inferenceModel) throws IOException {
        Model shapesModel = this.getRulesModel(ruleSet);
        shapesModel.read(Validator.class.getResourceAsStream("/inference-rules.ttl"), null, "TURTLE");
        if (inferenceModel != null) {
            shapesModel.add(inferenceModel);
        }
        Model inferredModel = RuleUtil.executeRules((Model)dataModel, (Model)shapesModel, null, (ProgressMonitor)new SimpleProgressMonitor("inference"));
        dataModel.add(inferredModel);
        Resource report = ValidationUtil.validateModel((Model)dataModel, (Model)shapesModel, (boolean)true);
        return new ResourceValidationReport(report);
    }

    public ValidationReport validate(Model dataModel, Set<URL> ruleSet) throws IOException {
        return this.validate(dataModel, ruleSet, null);
    }
}

