/*
 * Decompiled with CFR 0.152.
 */
package com.github.sgov.server;

import com.github.sgov.server.Rule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ValidationRules {
    private static final String RULES_DIR = "/rules";
    private static final String RULE_TEMPLATES_DIR = "/rule-templates";
    private static final String GLOSSARY_RULES_PREFIX = "g";
    private static final String MODEL_RULES_PREFIX = "m";
    private static final String VOCABULARY_RULES_PREFIX = "s";
    private static final List<Rule> GLOSSARY_RULES = ValidationRules.loadResources("/rules", "g");
    private static final List<Rule> GLOSSARY_RULE_TEMPLATES = ValidationRules.loadResources("/rule-templates", "g");
    private static final List<Rule> MODEL_RULES = ValidationRules.loadResources("/rules", "m");
    private static final List<Rule> MODEL_RULE_TEMPLATES = ValidationRules.loadResources("/rule-templates", "m");
    private static final List<Rule> VOCABULARY_RULES = ValidationRules.loadResources("/rules", "s");
    private static final List<Rule> VOCABULARY_RULE_TEMPLATES = ValidationRules.loadResources("/rule-templates", "s");

    private ValidationRules() {
        throw new AssertionError();
    }

    private static List<Rule> loadResources(String dir, String prefix) {
        String fileName;
        InputStream stream;
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (int i = 1; i < Short.MAX_VALUE && (stream = ValidationRules.class.getResourceAsStream(dir + "/" + (fileName = prefix + i + ".ttl"))) != null; ++i) {
            result.add(ValidationRules.loadFile(fileName.substring(0, fileName.indexOf(46)), stream));
        }
        return result;
    }

    private static Rule loadFile(String fileName, InputStream stream) {
        Rule rule;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            rule = new Rule(fileName, reader.lines().collect(Collectors.joining("\n")));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load file " + fileName, e);
            }
        }
        reader.close();
        return rule;
    }

    public static List<Rule> glossaryRules(String language) {
        Objects.requireNonNull(language);
        return ValidationRules.rulesAndTemplates(GLOSSARY_RULES, GLOSSARY_RULE_TEMPLATES, language);
    }

    private static List<Rule> rulesAndTemplates(List<Rule> rules, List<Rule> templates, String language) {
        return Stream.concat(rules.stream(), templates.stream().map(r -> r.withContent(r.content().replace("${lang}", language)))).collect(Collectors.toList());
    }

    public static List<Rule> modelRules(String language) {
        Objects.requireNonNull(language);
        return ValidationRules.rulesAndTemplates(MODEL_RULES, MODEL_RULE_TEMPLATES, language);
    }

    public static List<Rule> vocabularyRules(String language) {
        Objects.requireNonNull(language);
        return ValidationRules.rulesAndTemplates(VOCABULARY_RULES, VOCABULARY_RULE_TEMPLATES, language);
    }

    public static List<Rule> rules(String language) {
        return Stream.concat(ValidationRules.glossaryRules(language).stream(), Stream.concat(ValidationRules.modelRules(language).stream(), ValidationRules.vocabularyRules(language).stream())).collect(Collectors.toList());
    }
}

