/*
 * Decompiled with CFR 0.152.
 */
package com.github.sgov.server;

import com.github.sgov.server.Rule;
import com.github.sgov.server.ValidationRules;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.progress.NullProgressMonitor;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.rules.RuleUtil;
import org.topbraid.shacl.validation.ResourceValidationReport;
import org.topbraid.shacl.validation.ValidationReport;
import org.topbraid.shacl.validation.ValidationUtil;

public class Validator {
    private final Model shapesModel = ModelFactory.createDefaultModel();
    private final Model mappingModel;

    public Validator() {
        this.shapesModel.read(Validator.class.getResourceAsStream("/inference-rules.ttl"), null, "TURTLE");
        this.mappingModel = ModelFactory.createDefaultModel();
        this.mappingModel.read(Validator.class.getResourceAsStream("/z-sgov-mapping.ttl"), null, "TURTLE");
    }

    public ValidationReport validate(Model dataModel, String language) {
        Model shapesModel = Validator.getRulesModel(ValidationRules.rules(language).stream().map(Rule::content).collect(Collectors.toSet()));
        ValidationReport result = this.validate(dataModel, shapesModel);
        shapesModel.close();
        return result;
    }

    public ValidationReport validate(Model dataModel, Model shapesModel) {
        shapesModel.add(this.shapesModel);
        dataModel.add(this.mappingModel);
        Model inferredModel = RuleUtil.executeRules((Model)dataModel, (Model)shapesModel, null, (ProgressMonitor)new NullProgressMonitor());
        dataModel.add(inferredModel);
        Resource report = ValidationUtil.validateModel((Model)dataModel, (Model)shapesModel, (boolean)true);
        return new ResourceValidationReport(report);
    }

    private static Model getRulesModel(Collection<String> rules) {
        Model shapesModel = JenaUtil.createMemoryModel();
        for (String r : rules) {
            shapesModel.read((InputStream)new ByteArrayInputStream(r.getBytes(StandardCharsets.UTF_8)), null, "TURTLE");
        }
        return shapesModel;
    }
}

