/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi;

import gnu.trove.TFloatArrayList;
import gnu.trove.TLongArrayList;

public class PriorityQueue {
    public static final boolean SORT_ORDER_ASCENDING = true;
    public static final boolean SORT_ORDER_DESCENDING = false;
    private TLongArrayList values = null;
    private TFloatArrayList priorities = null;
    private boolean sortOrder = true;
    private static boolean INTERNAL_CONSISTENCY_CHECKING = false;

    public PriorityQueue(boolean bl) {
        this(bl, 10);
    }

    public PriorityQueue(boolean bl, int n) {
        this.sortOrder = bl;
        this.values = new TLongArrayList(n);
        this.priorities = new TFloatArrayList(n);
    }

    private boolean sortsEarlierThan(float f, float f2) {
        if (this.sortOrder) {
            return f < f2;
        }
        return f2 < f;
    }

    public void insert(long l, float f) {
        this.values.add(l);
        this.priorities.add(f);
        this.promote(this.values.size() - 1, l, f);
    }

    private void promote(int n, long l, float f) {
        int n2;
        float f2;
        while (n > 0 && !this.sortsEarlierThan(f2 = this.priorities.get(n2 = (n - 1) / 2), f)) {
            this.values.set(n, this.values.get(n2));
            this.priorities.set(n, f2);
            n = n2;
        }
        this.values.set(n, l);
        this.priorities.set(n, f);
        if (INTERNAL_CONSISTENCY_CHECKING) {
            this.check();
        }
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
        this.priorities.clear();
    }

    public void reset() {
        this.values.reset();
        this.priorities.reset();
    }

    public long getValue() {
        return this.values.get(0);
    }

    public float getPriority() {
        return this.priorities.get(0);
    }

    private void demote(int n, long l, float f) {
        int n2 = n * 2 + 1;
        while (n2 < this.values.size()) {
            float f2;
            float f3 = this.priorities.get(n2);
            if (n2 + 1 < this.values.size() && this.sortsEarlierThan(f2 = this.priorities.get(n2 + 1), f3)) {
                f3 = f2;
                ++n2;
            }
            if (!this.sortsEarlierThan(f3, f)) break;
            this.priorities.set(n, f3);
            this.values.set(n, this.values.get(n2));
            n = n2;
            n2 = n * 2 + 1;
        }
        this.values.set(n, l);
        this.priorities.set(n, f);
    }

    public long pop() {
        long l = this.values.get(0);
        int n = this.values.size() - 1;
        long l2 = this.values.get(n);
        float f = this.priorities.get(n);
        this.values.remove(n);
        this.priorities.remove(n);
        if (n > 0) {
            this.demote(0, l2, f);
        }
        if (INTERNAL_CONSISTENCY_CHECKING) {
            this.check();
        }
        return l;
    }

    public void setSortOrder(boolean bl) {
        if (this.sortOrder != bl) {
            this.sortOrder = bl;
            for (int i = this.values.size() / 2 - 1; i >= 0; --i) {
                this.demote(i, this.values.get(i), this.priorities.get(i));
            }
        }
        if (INTERNAL_CONSISTENCY_CHECKING) {
            this.check();
        }
    }

    private void check() {
        int n = this.values.size() - 1;
        for (int i = 0; i < this.values.size() / 2; ++i) {
            float f;
            int n2;
            float f2;
            float f3 = this.priorities.get(i);
            int n3 = i * 2 + 1;
            if (n3 <= n && this.sortsEarlierThan(f2 = this.priorities.get(n3), f3)) {
                System.err.println("Internal error in PriorityQueue");
            }
            if ((n2 = i * 2 + 2) > n || !this.sortsEarlierThan(f = this.priorities.get(n2), f3)) continue;
            System.err.println("Internal error in PriorityQueue");
        }
    }
}

