/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi;

import com.infomatiq.jsi.Point;

public class Rectangle {
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;

    public Rectangle() {
        this.minX = Float.MAX_VALUE;
        this.maxX = -3.4028235E38f;
        this.minY = Float.MAX_VALUE;
        this.maxY = -3.4028235E38f;
    }

    public Rectangle(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public void set(float f, float f2, float f3, float f4) {
        this.minX = Math.min(f, f3);
        this.maxX = Math.max(f, f3);
        this.minY = Math.min(f2, f4);
        this.maxY = Math.max(f2, f4);
    }

    public void set(Rectangle rectangle) {
        this.minX = rectangle.minX;
        this.minY = rectangle.minY;
        this.maxX = rectangle.maxX;
        this.maxY = rectangle.maxY;
    }

    public Rectangle copy() {
        return new Rectangle(this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean edgeOverlaps(Rectangle rectangle) {
        return this.minX == rectangle.minX || this.maxX == rectangle.maxX || this.minY == rectangle.minY || this.maxY == rectangle.maxY;
    }

    public boolean intersects(Rectangle rectangle) {
        return this.maxX >= rectangle.minX && this.minX <= rectangle.maxX && this.maxY >= rectangle.minY && this.minY <= rectangle.maxY;
    }

    public static boolean intersects(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return f3 >= f5 && f <= f7 && f4 >= f6 && f2 <= f8;
    }

    public boolean contains(Rectangle rectangle) {
        return this.maxX >= rectangle.maxX && this.minX <= rectangle.minX && this.maxY >= rectangle.maxY && this.minY <= rectangle.minY;
    }

    public static boolean contains(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return f3 >= f7 && f <= f5 && f4 >= f8 && f2 <= f6;
    }

    public boolean containedBy(Rectangle rectangle) {
        return rectangle.maxX >= this.maxX && rectangle.minX <= this.minX && rectangle.maxY >= this.maxY && rectangle.minY <= this.minY;
    }

    public float distance(Point point) {
        float f = 0.0f;
        float f2 = this.minX - point.x;
        if (f2 < 0.0f) {
            f2 = point.x - this.maxX;
        }
        if (f2 > 0.0f) {
            f += f2 * f2;
        }
        if ((f2 = this.minY - point.y) < 0.0f) {
            f2 = point.y - this.maxY;
        }
        if (f2 > 0.0f) {
            f += f2 * f2;
        }
        return (float)Math.sqrt(f);
    }

    public static float distance(float f, float f2, float f3, float f4, float f5, float f6) {
        return (float)Math.sqrt(Rectangle.distanceSq(f, f2, f3, f4, f5, f6));
    }

    public static float distanceSq(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (f > f5) {
            f7 = f - f5;
            f7 *= f7;
        } else if (f5 > f3) {
            f7 = f5 - f3;
            f7 *= f7;
        }
        if (f2 > f6) {
            f8 = f2 - f6;
            f8 *= f8;
        } else if (f6 > f4) {
            f8 = f6 - f4;
            f8 *= f8;
        }
        return f7 + f8;
    }

    public float distance(Rectangle rectangle) {
        float f;
        float f2 = 0.0f;
        float f3 = Math.max(this.minX, rectangle.minX);
        if (f3 > (f = Math.min(this.maxX, rectangle.maxX))) {
            f2 += (f3 - f) * (f3 - f);
        }
        if ((f3 = Math.max(this.minY, rectangle.minY)) > (f = Math.min(this.maxY, rectangle.maxY))) {
            f2 += (f3 - f) * (f3 - f);
        }
        return (float)Math.sqrt(f2);
    }

    public float enlargement(Rectangle rectangle) {
        float f = (Math.max(this.maxX, rectangle.maxX) - Math.min(this.minX, rectangle.minX)) * (Math.max(this.maxY, rectangle.maxY) - Math.min(this.minY, rectangle.minY));
        return f - this.area();
    }

    public static float enlargement(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10 = (f3 - f) * (f4 - f2);
        if (f10 == Float.POSITIVE_INFINITY) {
            return 0.0f;
        }
        if (f5 < f) {
            f = f5;
        }
        if (f6 < f2) {
            f2 = f6;
        }
        if (f7 > f3) {
            f3 = f7;
        }
        if (f8 > f4) {
            f4 = f8;
        }
        if ((f9 = (f3 - f) * (f4 - f2)) == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        return f9 - f10;
    }

    public float area() {
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }

    public static float area(float f, float f2, float f3, float f4) {
        return (f3 - f) * (f4 - f2);
    }

    public void add(Rectangle rectangle) {
        if (rectangle.minX < this.minX) {
            this.minX = rectangle.minX;
        }
        if (rectangle.maxX > this.maxX) {
            this.maxX = rectangle.maxX;
        }
        if (rectangle.minY < this.minY) {
            this.minY = rectangle.minY;
        }
        if (rectangle.maxY > this.maxY) {
            this.maxY = rectangle.maxY;
        }
    }

    public void add(Point point) {
        if (point.x < this.minX) {
            this.minX = point.x;
        }
        if (point.x > this.maxX) {
            this.maxX = point.x;
        }
        if (point.y < this.minY) {
            this.minY = point.y;
        }
        if (point.y > this.maxY) {
            this.maxY = point.y;
        }
    }

    public Rectangle union(Rectangle rectangle) {
        Rectangle rectangle2 = this.copy();
        rectangle2.add(rectangle);
        return rectangle2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            if (this.minX == rectangle.minX && this.minY == rectangle.minY && this.maxX == rectangle.maxX && this.maxY == rectangle.maxY) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean sameObject(Object object) {
        return super.equals(object);
    }

    public String toString() {
        return "(" + this.minX + ", " + this.minY + "), (" + this.maxX + ", " + this.maxY + ")";
    }

    public float width() {
        return this.maxX - this.minX;
    }

    public float height() {
        return this.maxY - this.minY;
    }

    public float aspectRatio() {
        return this.width() / this.height();
    }

    public Point centre() {
        return new Point((this.minX + this.maxX) / 2.0f, (this.minY + this.maxY) / 2.0f);
    }
}

