/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.rtree.RTree;

public class Node {
    long nodeId = 0L;
    float mbrMinX = Float.MAX_VALUE;
    float mbrMinY = Float.MAX_VALUE;
    float mbrMaxX = -3.4028235E38f;
    float mbrMaxY = -3.4028235E38f;
    float[] entriesMinX = null;
    float[] entriesMinY = null;
    float[] entriesMaxX = null;
    float[] entriesMaxY = null;
    long[] ids = null;
    int level;
    int entryCount;

    Node(long l, int n, int n2) {
        this.nodeId = l;
        this.level = n;
        this.entriesMinX = new float[n2];
        this.entriesMinY = new float[n2];
        this.entriesMaxX = new float[n2];
        this.entriesMaxY = new float[n2];
        this.ids = new long[n2];
    }

    void addEntry(float f, float f2, float f3, float f4, long l) {
        this.ids[this.entryCount] = l;
        this.entriesMinX[this.entryCount] = f;
        this.entriesMinY[this.entryCount] = f2;
        this.entriesMaxX[this.entryCount] = f3;
        this.entriesMaxY[this.entryCount] = f4;
        if (f < this.mbrMinX) {
            this.mbrMinX = f;
        }
        if (f2 < this.mbrMinY) {
            this.mbrMinY = f2;
        }
        if (f3 > this.mbrMaxX) {
            this.mbrMaxX = f3;
        }
        if (f4 > this.mbrMaxY) {
            this.mbrMaxY = f4;
        }
        ++this.entryCount;
    }

    int findEntry(float f, float f2, float f3, float f4, long l) {
        for (int i = 0; i < this.entryCount; ++i) {
            if (l != this.ids[i] || this.entriesMinX[i] != f || this.entriesMinY[i] != f2 || this.entriesMaxX[i] != f3 || this.entriesMaxY[i] != f4) continue;
            return i;
        }
        return -1;
    }

    void deleteEntry(int n, int n2) {
        int n3 = this.entryCount - 1;
        float f = this.entriesMinX[n];
        float f2 = this.entriesMinY[n];
        float f3 = this.entriesMaxX[n];
        float f4 = this.entriesMaxY[n];
        if (n != n3) {
            this.entriesMinX[n] = this.entriesMinX[n3];
            this.entriesMinY[n] = this.entriesMinY[n3];
            this.entriesMaxX[n] = this.entriesMaxX[n3];
            this.entriesMaxY[n] = this.entriesMaxY[n3];
            this.ids[n] = this.ids[n3];
        }
        --this.entryCount;
        if (this.entryCount >= n2) {
            this.recalculateMBRIfInfluencedBy(f, f2, f3, f4);
        }
    }

    void recalculateMBRIfInfluencedBy(float f, float f2, float f3, float f4) {
        if (this.mbrMinX == f || this.mbrMinY == f2 || this.mbrMaxX == f3 || this.mbrMaxY == f4) {
            this.recalculateMBR();
        }
    }

    void recalculateMBR() {
        this.mbrMinX = this.entriesMinX[0];
        this.mbrMinY = this.entriesMinY[0];
        this.mbrMaxX = this.entriesMaxX[0];
        this.mbrMaxY = this.entriesMaxY[0];
        for (int i = 1; i < this.entryCount; ++i) {
            if (this.entriesMinX[i] < this.mbrMinX) {
                this.mbrMinX = this.entriesMinX[i];
            }
            if (this.entriesMinY[i] < this.mbrMinY) {
                this.mbrMinY = this.entriesMinY[i];
            }
            if (this.entriesMaxX[i] > this.mbrMaxX) {
                this.mbrMaxX = this.entriesMaxX[i];
            }
            if (!(this.entriesMaxY[i] > this.mbrMaxY)) continue;
            this.mbrMaxY = this.entriesMaxY[i];
        }
    }

    void reorganize(RTree rTree) {
        int n = rTree.maxNodeEntries - 1;
        for (int i = 0; i < this.entryCount; ++i) {
            if (this.ids[i] != -1L) continue;
            while (this.ids[n] == -1L && n > i) {
                --n;
            }
            this.entriesMinX[i] = this.entriesMinX[n];
            this.entriesMinY[i] = this.entriesMinY[n];
            this.entriesMaxX[i] = this.entriesMaxX[n];
            this.entriesMaxY[i] = this.entriesMaxY[n];
            this.ids[i] = this.ids[n];
            this.ids[n] = -1L;
        }
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public long getId(int n) {
        if (n < this.entryCount) {
            return this.ids[n];
        }
        return -1L;
    }

    boolean isLeaf() {
        return this.level == 1;
    }

    public int getLevel() {
        return this.level;
    }
}

