/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.PriorityQueue;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.Node;
import com.infomatiq.jsi.rtree.SortedList;
import gnu.trove.TIntStack;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongProcedure;
import gnu.trove.TLongStack;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RTree
implements SpatialIndex {
    private static final Logger log = Logger.getLogger((String)(class$com$infomatiq$jsi$rtree$RTree == null ? (class$com$infomatiq$jsi$rtree$RTree = RTree.class$("com.infomatiq.jsi.rtree.RTree")) : class$com$infomatiq$jsi$rtree$RTree).getName());
    private static final Logger deleteLog = Logger.getLogger((String)((class$com$infomatiq$jsi$rtree$RTree == null ? (class$com$infomatiq$jsi$rtree$RTree = RTree.class$("com.infomatiq.jsi.rtree.RTree")) : class$com$infomatiq$jsi$rtree$RTree).getName() + "-delete"));
    private static final String version = "1.0b6";
    private static final int DEFAULT_MAX_NODE_ENTRIES = 10;
    int maxNodeEntries;
    int minNodeEntries;
    private TLongObjectHashMap nodeMap = new TLongObjectHashMap();
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    private byte[] entryStatus = null;
    private byte[] initialEntryStatus = null;
    private TLongStack parents = new TLongStack();
    private TIntStack parentsEntry = new TIntStack();
    private int treeHeight = 1;
    private long rootNodeId = 0L;
    private int size = 0;
    private long highestUsedNodeId = this.rootNodeId;
    private TLongStack deletedNodeIds = new TLongStack();
    private TLongArrayList nearestIds = new TLongArrayList();
    private TLongArrayList savedValues = new TLongArrayList();
    private float savedPriority = 0.0f;
    private SortedList nearestNIds = new SortedList();
    private PriorityQueue distanceQueue = new PriorityQueue(true);
    static /* synthetic */ Class class$com$infomatiq$jsi$rtree$RTree;

    public void init(Properties properties) {
        this.maxNodeEntries = Integer.parseInt(properties.getProperty("MaxNodeEntries", "0"));
        this.minNodeEntries = Integer.parseInt(properties.getProperty("MinNodeEntries", "0"));
        if (this.maxNodeEntries < 2) {
            log.warn((Object)("Invalid MaxNodeEntries = " + this.maxNodeEntries + " Resetting to default value of " + 10));
            this.maxNodeEntries = 10;
        }
        if (this.minNodeEntries < 1 || this.minNodeEntries > this.maxNodeEntries / 2) {
            log.warn((Object)"MinNodeEntries must be between 1 and MaxNodeEntries / 2");
            this.minNodeEntries = this.maxNodeEntries / 2;
        }
        this.entryStatus = new byte[this.maxNodeEntries];
        this.initialEntryStatus = new byte[this.maxNodeEntries];
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            this.initialEntryStatus[i] = 1;
        }
        Node node = new Node(this.rootNodeId, 1, this.maxNodeEntries);
        this.nodeMap.put(this.rootNodeId, (Object)node);
        log.debug((Object)("init()  MaxNodeEntries = " + this.maxNodeEntries + ", MinNodeEntries = " + this.minNodeEntries));
    }

    public void add(Rectangle rectangle, long l) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding rectangle " + rectangle + ", id " + l));
        }
        this.add(rectangle.minX, rectangle.minY, rectangle.maxX, rectangle.maxY, l, 1);
        ++this.size;
    }

    private void add(float f, float f2, float f3, float f4, long l, int n) {
        Node node = this.chooseNode(f, f2, f3, f4, n);
        Node node2 = null;
        if (node.entryCount < this.maxNodeEntries) {
            node.addEntry(f, f2, f3, f4, l);
        } else {
            node2 = this.splitNode(node, f, f2, f3, f4, l);
        }
        Node node3 = this.adjustTree(node, node2);
        if (node3 != null) {
            long l2 = this.rootNodeId;
            Node node4 = this.getNode(l2);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node node5 = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            node5.addEntry(node3.mbrMinX, node3.mbrMinY, node3.mbrMaxX, node3.mbrMaxY, node3.nodeId);
            node5.addEntry(node4.mbrMinX, node4.mbrMinY, node4.mbrMaxX, node4.mbrMaxY, node4.nodeId);
            this.nodeMap.put(this.rootNodeId, (Object)node5);
        }
    }

    public boolean delete(Rectangle rectangle, long l) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        Node node = null;
        int n = -1;
        while (n == -1 && this.parents.size() > 0) {
            node = this.getNode(this.parents.peek());
            int n2 = this.parentsEntry.peek() + 1;
            if (!node.isLeaf()) {
                deleteLog.debug((Object)("searching node " + node.nodeId + ", from index " + n2));
                boolean bl = false;
                for (int i = n2; i < node.entryCount; ++i) {
                    if (!Rectangle.contains(node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i], rectangle.minX, rectangle.minY, rectangle.maxX, rectangle.maxY)) continue;
                    this.parents.push(node.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    bl = true;
                    break;
                }
                if (bl) {
                    continue;
                }
            } else {
                n = node.findEntry(rectangle.minX, rectangle.minY, rectangle.maxX, rectangle.maxY, l);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (n != -1) {
            node.deleteEntry(n, this.minNodeEntries);
            this.condenseTree(node);
            --this.size;
        }
        Node node2 = this.getNode(this.rootNodeId);
        while (node2.entryCount == 1 && this.treeHeight > 1) {
            this.deletedNodeIds.push(this.rootNodeId);
            node2.entryCount = 0;
            this.rootNodeId = node2.ids[0];
            --this.treeHeight;
            node2 = this.getNode(this.rootNodeId);
        }
        if (this.size == 0) {
            node2.mbrMinX = Float.MAX_VALUE;
            node2.mbrMaxX = -3.4028235E38f;
            node2.mbrMinY = Float.MAX_VALUE;
            node2.mbrMaxY = -3.4028235E38f;
        }
        return n != -1;
    }

    public void nearest(Point point, TLongProcedure tLongProcedure, float f) {
        Node node = this.getNode(this.rootNodeId);
        float f2 = f * f;
        this.nearest(point, node, f2);
        this.nearestIds.forEach(tLongProcedure);
        this.nearestIds.reset();
    }

    private void createNearestNDistanceQueue(Point point, int n, float f) {
        this.distanceQueue.reset();
        this.distanceQueue.setSortOrder(false);
        if (n <= 0) {
            return;
        }
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        float f2 = f * f;
        while (this.parents.size() > 0) {
            int n2;
            Node node = this.getNode(this.parents.peek());
            int n3 = this.parentsEntry.peek() + 1;
            if (!node.isLeaf()) {
                n2 = 0;
                for (int i = n3; i < node.entryCount; ++i) {
                    if (!(Rectangle.distanceSq(node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i], point.x, point.y) <= f2)) continue;
                    this.parents.push(node.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    n2 = 1;
                    break;
                }
                if (n2 != 0) {
                    continue;
                }
            } else {
                for (n2 = 0; n2 < node.entryCount; ++n2) {
                    float f3 = Rectangle.distanceSq(node.entriesMinX[n2], node.entriesMinY[n2], node.entriesMaxX[n2], node.entriesMaxY[n2], point.x, point.y);
                    long l = node.ids[n2];
                    if (!(f3 <= f2)) continue;
                    this.distanceQueue.insert(l, f3);
                    while (this.distanceQueue.size() > n) {
                        long l2 = this.distanceQueue.getValue();
                        float f4 = this.distanceQueue.getPriority();
                        this.distanceQueue.pop();
                        if (f4 == this.distanceQueue.getPriority()) {
                            this.savedValues.add(l2);
                            this.savedPriority = f4;
                            continue;
                        }
                        this.savedValues.reset();
                    }
                    if (this.savedValues.size() > 0 && this.savedPriority == this.distanceQueue.getPriority()) {
                        for (int i = 0; i < this.savedValues.size(); ++i) {
                            this.distanceQueue.insert(this.savedValues.get(i), this.savedPriority);
                        }
                        this.savedValues.reset();
                    }
                    if (!(this.distanceQueue.getPriority() < f2) || this.distanceQueue.size() < n) continue;
                    f2 = this.distanceQueue.getPriority();
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    public void nearestNUnsorted(Point point, TLongProcedure tLongProcedure, int n, float f) {
        this.createNearestNDistanceQueue(point, n, f);
        while (this.distanceQueue.size() > 0) {
            tLongProcedure.execute(this.distanceQueue.getValue());
            this.distanceQueue.pop();
        }
    }

    public void nearestN(Point point, TLongProcedure tLongProcedure, int n, float f) {
        this.createNearestNDistanceQueue(point, n, f);
        this.distanceQueue.setSortOrder(true);
        while (this.distanceQueue.size() > 0) {
            tLongProcedure.execute(this.distanceQueue.getValue());
            this.distanceQueue.pop();
        }
    }

    public void nearestN_orig(Point point, TLongProcedure tLongProcedure, int n, float f) {
        if (n <= 0) {
            return;
        }
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        this.nearestNIds.init(n);
        float f2 = f * f;
        while (this.parents.size() > 0) {
            int n2;
            Node node = this.getNode(this.parents.peek());
            int n3 = this.parentsEntry.peek() + 1;
            if (!node.isLeaf()) {
                n2 = 0;
                for (int i = n3; i < node.entryCount; ++i) {
                    if (!(Rectangle.distanceSq(node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i], point.x, point.y) <= f2)) continue;
                    this.parents.push(node.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    n2 = 1;
                    break;
                }
                if (n2 != 0) {
                    continue;
                }
            } else {
                for (n2 = 0; n2 < node.entryCount; ++n2) {
                    float f3 = Rectangle.distanceSq(node.entriesMinX[n2], node.entriesMinY[n2], node.entriesMaxX[n2], node.entriesMaxY[n2], point.x, point.y);
                    long l = node.ids[n2];
                    if (!(f3 <= f2)) continue;
                    this.nearestNIds.add(l, -f3);
                    float f4 = -this.nearestNIds.getLowestPriority();
                    if (!(f4 < f2)) continue;
                    f2 = f4;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        this.nearestNIds.forEachId(tLongProcedure);
    }

    public void intersects(Rectangle rectangle, TLongProcedure tLongProcedure) {
        Node node = this.getNode(this.rootNodeId);
        this.intersects(rectangle, tLongProcedure, node);
    }

    public void contains(Rectangle rectangle, TLongProcedure tLongProcedure) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        while (this.parents.size() > 0) {
            int n;
            Node node = this.getNode(this.parents.peek());
            int n2 = this.parentsEntry.peek() + 1;
            if (!node.isLeaf()) {
                n = 0;
                for (int i = n2; i < node.entryCount; ++i) {
                    if (!Rectangle.intersects(rectangle.minX, rectangle.minY, rectangle.maxX, rectangle.maxY, node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i])) continue;
                    this.parents.push(node.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    n = 1;
                    break;
                }
                if (n != 0) {
                    continue;
                }
            } else {
                for (n = 0; n < node.entryCount; ++n) {
                    if (!Rectangle.contains(rectangle.minX, rectangle.minY, rectangle.maxX, rectangle.maxY, node.entriesMinX[n], node.entriesMinY[n], node.entriesMaxX[n], node.entriesMaxY[n]) || tLongProcedure.execute(node.ids[n])) continue;
                    return;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    public int size() {
        return this.size;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = null;
        Node node = this.getNode(this.getRootNodeId());
        if (node != null && node.entryCount > 0) {
            rectangle = new Rectangle();
            rectangle.minX = node.mbrMinX;
            rectangle.minY = node.mbrMinY;
            rectangle.maxX = node.mbrMaxX;
            rectangle.maxY = node.mbrMaxY;
        }
        return rectangle;
    }

    public String getVersion() {
        return "RTree-1.0b6";
    }

    private long getNextNodeId() {
        long l = 0L;
        l = this.deletedNodeIds.size() > 0 ? this.deletedNodeIds.pop() : 1L + this.highestUsedNodeId++;
        return l;
    }

    public Node getNode(long l) {
        return (Node)this.nodeMap.get(l);
    }

    public long getHighestUsedNodeId() {
        return this.highestUsedNodeId;
    }

    public long getRootNodeId() {
        return this.rootNodeId;
    }

    private Node splitNode(Node node, float f, float f2, float f3, float f4, long l) {
        float f5;
        float f6;
        float f7 = 0.0f;
        if (log.isDebugEnabled()) {
            float f8 = Math.min(node.mbrMinX, f);
            f6 = Math.min(node.mbrMinY, f2);
            f5 = Math.max(node.mbrMaxX, f3);
            float f9 = Math.max(node.mbrMaxY, f4);
            f7 = (f5 - f8) * (f9 - f6);
        }
        System.arraycopy(this.initialEntryStatus, 0, this.entryStatus, 0, this.maxNodeEntries);
        Node node2 = null;
        node2 = new Node(this.getNextNodeId(), node.level, this.maxNodeEntries);
        this.nodeMap.put(node2.nodeId, (Object)node2);
        this.pickSeeds(node, f, f2, f3, f4, l, node2);
        while (node.entryCount + node2.entryCount < this.maxNodeEntries + 1) {
            if (this.maxNodeEntries + 1 - node2.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    if (node.entriesMinX[i] < node.mbrMinX) {
                        node.mbrMinX = node.entriesMinX[i];
                    }
                    if (node.entriesMinY[i] < node.mbrMinY) {
                        node.mbrMinY = node.entriesMinY[i];
                    }
                    if (node.entriesMaxX[i] > node.mbrMaxX) {
                        node.mbrMaxX = node.entriesMaxX[i];
                    }
                    if (node.entriesMaxY[i] > node.mbrMaxY) {
                        node.mbrMaxY = node.entriesMaxY[i];
                    }
                    ++node.entryCount;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - node.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    node2.addEntry(node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i], node.ids[i]);
                    node.ids[i] = -1L;
                }
                break;
            }
            this.pickNext(node, node2);
        }
        node.reorganize(this);
        if (log.isDebugEnabled()) {
            f6 = Rectangle.area(node.mbrMinX, node.mbrMinY, node.mbrMaxX, node.mbrMaxY) + Rectangle.area(node2.mbrMinX, node2.mbrMinY, node2.mbrMaxX, node2.mbrMaxY);
            f5 = 100.0f * (f6 - f7) / f7;
            log.debug((Object)("Node " + node.nodeId + " split. New area increased by " + f5 + "%"));
        }
        return node2;
    }

    private void pickSeeds(Node node, float f, float f2, float f3, float f4, long l, Node node2) {
        float f5;
        float f6;
        int n;
        float f7 = -1.0f;
        int n2 = -1;
        int n3 = -1;
        if (f < node.mbrMinX) {
            node.mbrMinX = f;
        }
        if (f2 < node.mbrMinY) {
            node.mbrMinY = f2;
        }
        if (f3 > node.mbrMaxX) {
            node.mbrMaxX = f3;
        }
        if (f4 > node.mbrMaxY) {
            node.mbrMaxY = f4;
        }
        float f8 = node.mbrMaxX - node.mbrMinX;
        float f9 = node.mbrMaxY - node.mbrMinY;
        if (log.isDebugEnabled()) {
            log.debug((Object)("pickSeeds(): NodeId = " + node.nodeId));
        }
        float f10 = f;
        int n4 = -1;
        float f11 = f3;
        int n5 = -1;
        for (n = 0; n < node.entryCount; ++n) {
            f6 = node.entriesMinX[n];
            if (f6 >= f10) {
                f10 = f6;
                n4 = n;
            } else {
                f5 = node.entriesMaxX[n];
                if (f5 <= f11) {
                    f11 = f5;
                    n5 = n;
                }
            }
            float f12 = f5 = f8 == 0.0f ? 1.0f : (f10 - f11) / f8;
            if (f5 > 1.0f || f5 < -1.0f) {
                log.error((Object)"Invalid normalized separation X");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry " + n + ", dimension X: HighestLow = " + f10 + " (index " + n4 + ")" + ", LowestHigh = " + f11 + " (index " + n5 + ", NormalizedSeparation = " + f5));
            }
            if (!(f5 >= f7)) continue;
            n2 = n4;
            n3 = n5;
            f7 = f5;
        }
        f10 = f2;
        n4 = -1;
        f11 = f4;
        n5 = -1;
        for (n = 0; n < node.entryCount; ++n) {
            f6 = node.entriesMinY[n];
            if (f6 >= f10) {
                f10 = f6;
                n4 = n;
            } else {
                f5 = node.entriesMaxY[n];
                if (f5 <= f11) {
                    f11 = f5;
                    n5 = n;
                }
            }
            float f13 = f5 = f9 == 0.0f ? 1.0f : (f10 - f11) / f9;
            if (f5 > 1.0f || f5 < -1.0f) {
                log.error((Object)"Invalid normalized separation Y");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry " + n + ", dimension Y: HighestLow = " + f10 + " (index " + n4 + ")" + ", LowestHigh = " + f11 + " (index " + n5 + ", NormalizedSeparation = " + f5));
            }
            if (!(f5 >= f7)) continue;
            n2 = n4;
            n3 = n5;
            f7 = f5;
        }
        if (n2 == n3) {
            n2 = -1;
            float f14 = f2;
            n3 = 0;
            f6 = node.entriesMaxX[0];
            for (int i = 1; i < node.entryCount; ++i) {
                if (node.entriesMinY[i] < f14) {
                    f14 = node.entriesMinY[i];
                    n2 = i;
                    continue;
                }
                if (!(node.entriesMaxX[i] > f6)) continue;
                f6 = node.entriesMaxX[i];
                n3 = i;
            }
        }
        if (n2 == -1) {
            node2.addEntry(f, f2, f3, f4, l);
        } else {
            node2.addEntry(node.entriesMinX[n2], node.entriesMinY[n2], node.entriesMaxX[n2], node.entriesMaxY[n2], node.ids[n2]);
            node.ids[n2] = -1L;
            node.entriesMinX[n2] = f;
            node.entriesMinY[n2] = f2;
            node.entriesMaxX[n2] = f3;
            node.entriesMaxY[n2] = f4;
            node.ids[n2] = l;
        }
        if (n3 == -1) {
            n3 = n2;
        }
        this.entryStatus[n3] = 0;
        node.entryCount = 1;
        node.mbrMinX = node.entriesMinX[n3];
        node.mbrMinY = node.entriesMinY[n3];
        node.mbrMaxX = node.entriesMaxX[n3];
        node.mbrMaxY = node.entriesMaxY[n3];
    }

    private int pickNext(Node node, Node node2) {
        float f = Float.NEGATIVE_INFINITY;
        int n = 0;
        boolean bl = false;
        f = Float.NEGATIVE_INFINITY;
        if (log.isDebugEnabled()) {
            log.debug((Object)"pickNext()");
        }
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            float f2;
            float f3;
            float f4;
            if (this.entryStatus[i] != 1) continue;
            if (node.ids[i] == -1L) {
                log.error((Object)("Error: Node " + node.nodeId + ", entry " + i + " is null"));
            }
            if ((f4 = Math.abs((f3 = Rectangle.enlargement(node.mbrMinX, node.mbrMinY, node.mbrMaxX, node.mbrMaxY, node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i])) - (f2 = Rectangle.enlargement(node2.mbrMinX, node2.mbrMinY, node2.mbrMaxX, node2.mbrMaxY, node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i])))) > f) {
                n = i;
                bl = f3 < f2 ? false : (f2 < f3 ? true : (Rectangle.area(node.mbrMinX, node.mbrMinY, node.mbrMaxX, node.mbrMaxY) < Rectangle.area(node2.mbrMinX, node2.mbrMinY, node2.mbrMaxX, node2.mbrMaxY) ? false : (Rectangle.area(node2.mbrMinX, node2.mbrMinY, node2.mbrMaxX, node2.mbrMaxY) < Rectangle.area(node.mbrMinX, node.mbrMinY, node.mbrMaxX, node.mbrMaxY) ? true : node2.entryCount >= this.maxNodeEntries / 2)));
                f = f4;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Entry " + i + " group0 increase = " + f3 + ", group1 increase = " + f2 + ", diff = " + f4 + ", MaxDiff = " + f + " (entry " + n + ")"));
        }
        this.entryStatus[n] = 0;
        if (!bl) {
            if (node.entriesMinX[n] < node.mbrMinX) {
                node.mbrMinX = node.entriesMinX[n];
            }
            if (node.entriesMinY[n] < node.mbrMinY) {
                node.mbrMinY = node.entriesMinY[n];
            }
            if (node.entriesMaxX[n] > node.mbrMaxX) {
                node.mbrMaxX = node.entriesMaxX[n];
            }
            if (node.entriesMaxY[n] > node.mbrMaxY) {
                node.mbrMaxY = node.entriesMaxY[n];
            }
            ++node.entryCount;
        } else {
            node2.addEntry(node.entriesMinX[n], node.entriesMinY[n], node.entriesMaxX[n], node.entriesMaxY[n], node.ids[n]);
            node.ids[n] = -1L;
        }
        return n;
    }

    private float nearest(Point point, Node node, float f) {
        for (int i = 0; i < node.entryCount; ++i) {
            float f2 = Rectangle.distanceSq(node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i], point.x, point.y);
            if (node.isLeaf()) {
                if (f2 < f) {
                    f = f2;
                    this.nearestIds.reset();
                }
                if (!(f2 <= f)) continue;
                this.nearestIds.add(node.ids[i]);
                continue;
            }
            if (!(f2 <= f)) continue;
            f = this.nearest(point, this.getNode(node.ids[i]), f);
        }
        return f;
    }

    private boolean intersects(Rectangle rectangle, TLongProcedure tLongProcedure, Node node) {
        for (int i = 0; i < node.entryCount; ++i) {
            Node node2;
            if (!Rectangle.intersects(rectangle.minX, rectangle.minY, rectangle.maxX, rectangle.maxY, node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i]) || !(node.isLeaf() ? !tLongProcedure.execute(node.ids[i]) : !this.intersects(rectangle, tLongProcedure, node2 = this.getNode(node.ids[i])))) continue;
            return false;
        }
        return true;
    }

    private void condenseTree(Node node) {
        Node node2 = node;
        Node node3 = null;
        int n = 0;
        TLongStack tLongStack = new TLongStack();
        while (node2.level != this.treeHeight) {
            node3 = this.getNode(this.parents.pop());
            n = this.parentsEntry.pop();
            if (node2.entryCount < this.minNodeEntries) {
                node3.deleteEntry(n, this.minNodeEntries);
                tLongStack.push(node2.nodeId);
            } else if (node2.mbrMinX != node3.entriesMinX[n] || node2.mbrMinY != node3.entriesMinY[n] || node2.mbrMaxX != node3.entriesMaxX[n] || node2.mbrMaxY != node3.entriesMaxY[n]) {
                float f = node3.entriesMinX[n];
                float f2 = node3.entriesMinY[n];
                float f3 = node3.entriesMaxX[n];
                float f4 = node3.entriesMaxY[n];
                node3.entriesMinX[n] = node2.mbrMinX;
                node3.entriesMinY[n] = node2.mbrMinY;
                node3.entriesMaxX[n] = node2.mbrMaxX;
                node3.entriesMaxY[n] = node2.mbrMaxY;
                node3.recalculateMBRIfInfluencedBy(f, f2, f3, f4);
            }
            node2 = node3;
        }
        while (tLongStack.size() > 0) {
            Node node4 = this.getNode(tLongStack.pop());
            for (int i = 0; i < node4.entryCount; ++i) {
                this.add(node4.entriesMinX[i], node4.entriesMinY[i], node4.entriesMaxX[i], node4.entriesMaxY[i], node4.ids[i], node4.level);
                node4.ids[i] = -1L;
            }
            node4.entryCount = 0;
            this.deletedNodeIds.push(node4.nodeId);
        }
    }

    private Node chooseNode(float f, float f2, float f3, float f4, int n) {
        Node node = this.getNode(this.rootNodeId);
        this.parents.reset();
        this.parentsEntry.reset();
        while (true) {
            if (node == null) {
                log.error((Object)("Could not get root node (" + this.rootNodeId + ")"));
            }
            if (node.level == n) {
                return node;
            }
            float f5 = Rectangle.enlargement(node.entriesMinX[0], node.entriesMinY[0], node.entriesMaxX[0], node.entriesMaxY[0], f, f2, f3, f4);
            int n2 = 0;
            for (int i = 1; i < node.entryCount; ++i) {
                float f6 = node.entriesMinX[i];
                float f7 = node.entriesMinY[i];
                float f8 = node.entriesMaxX[i];
                float f9 = node.entriesMaxY[i];
                float f10 = Rectangle.enlargement(f6, f7, f8, f9, f, f2, f3, f4);
                if (!(f10 < f5) && (f10 != f5 || !(Rectangle.area(f6, f7, f8, f9) < Rectangle.area(node.entriesMinX[n2], node.entriesMinY[n2], node.entriesMaxX[n2], node.entriesMaxY[n2])))) continue;
                n2 = i;
                f5 = f10;
            }
            this.parents.push(node.nodeId);
            this.parentsEntry.push(n2);
            node = this.getNode(node.ids[n2]);
        }
    }

    private Node adjustTree(Node node, Node node2) {
        while (node.level != this.treeHeight) {
            Node node3 = this.getNode(this.parents.pop());
            int n = this.parentsEntry.pop();
            if (node3.ids[n] != node.nodeId) {
                log.error((Object)("Error: entry " + n + " in node " + node3.nodeId + " should point to node " + node.nodeId + "; actually points to node " + node3.ids[n]));
            }
            if (node3.entriesMinX[n] != node.mbrMinX || node3.entriesMinY[n] != node.mbrMinY || node3.entriesMaxX[n] != node.mbrMaxX || node3.entriesMaxY[n] != node.mbrMaxY) {
                node3.entriesMinX[n] = node.mbrMinX;
                node3.entriesMinY[n] = node.mbrMinY;
                node3.entriesMaxX[n] = node.mbrMaxX;
                node3.entriesMaxY[n] = node.mbrMaxY;
                node3.recalculateMBR();
            }
            Node node4 = null;
            if (node2 != null) {
                if (node3.entryCount < this.maxNodeEntries) {
                    node3.addEntry(node2.mbrMinX, node2.mbrMinY, node2.mbrMaxX, node2.mbrMaxY, node2.nodeId);
                } else {
                    node4 = this.splitNode(node3, node2.mbrMinX, node2.mbrMinY, node2.mbrMaxX, node2.mbrMaxY, node2.nodeId);
                }
            }
            node = node3;
            node2 = node4;
            node3 = null;
            node4 = null;
        }
        return node2;
    }

    public boolean checkConsistency() {
        return this.checkConsistency(this.rootNodeId, this.treeHeight, null);
    }

    private boolean checkConsistency(long l, int n, Rectangle rectangle) {
        Node node = this.getNode(l);
        if (node == null) {
            log.error((Object)("Error: Could not read node " + l));
            return false;
        }
        if (l == this.rootNodeId && this.size() == 0 && node.level != 1) {
            log.error((Object)"Error: tree is empty but root node is not at level 1");
            return false;
        }
        if (node.level != n) {
            log.error((Object)("Error: Node " + l + ", expected level " + n + ", actual level " + node.level));
            return false;
        }
        Rectangle rectangle2 = this.calculateMBR(node);
        Rectangle rectangle3 = new Rectangle();
        rectangle3.minX = node.mbrMinX;
        rectangle3.minY = node.mbrMinY;
        rectangle3.maxX = node.mbrMaxX;
        rectangle3.maxY = node.mbrMaxY;
        if (!rectangle3.equals(rectangle2)) {
            log.error((Object)("Error: Node " + l + ", calculated MBR does not equal stored MBR"));
            return false;
        }
        if (rectangle != null && !rectangle3.equals(rectangle)) {
            log.error((Object)("Error: Node " + l + ", expected MBR (from parent) does not equal stored MBR"));
            return false;
        }
        if (rectangle != null && rectangle3.sameObject(rectangle)) {
            log.error((Object)("Error: Node " + l + " MBR using same rectangle object as parent's entry"));
            return false;
        }
        for (int i = 0; i < node.entryCount; ++i) {
            if (node.ids[i] == -1L) {
                log.error((Object)("Error: Node " + l + ", Entry " + i + " is null"));
                return false;
            }
            if (node.level <= 1 || this.checkConsistency(node.ids[i], node.level - 1, new Rectangle(node.entriesMinX[i], node.entriesMinY[i], node.entriesMaxX[i], node.entriesMaxY[i]))) continue;
            return false;
        }
        return true;
    }

    private Rectangle calculateMBR(Node node) {
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < node.entryCount; ++i) {
            if (node.entriesMinX[i] < rectangle.minX) {
                rectangle.minX = node.entriesMinX[i];
            }
            if (node.entriesMinY[i] < rectangle.minY) {
                rectangle.minY = node.entriesMinY[i];
            }
            if (node.entriesMaxX[i] > rectangle.maxX) {
                rectangle.maxX = node.entriesMaxX[i];
            }
            if (!(node.entriesMaxY[i] > rectangle.maxY)) continue;
            rectangle.maxY = node.entriesMaxY[i];
        }
        return rectangle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

