/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import gnu.trove.TFloatArrayList;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongProcedure;

public class SortedList {
    private static final int DEFAULT_PREFERRED_MAXIMUM_SIZE = 10;
    private int preferredMaximumSize = 1;
    private TLongArrayList ids = new TLongArrayList(10);
    private TFloatArrayList priorities = new TFloatArrayList(10);

    public void init(int n) {
        this.preferredMaximumSize = n;
        this.ids.clear(n);
        this.priorities.clear(n);
    }

    public void reset() {
        this.ids.reset();
        this.priorities.reset();
    }

    public void add(long l, float f) {
        float f2 = Float.NEGATIVE_INFINITY;
        if (this.priorities.size() > 0) {
            f2 = this.priorities.get(this.priorities.size() - 1);
        }
        if (f == f2 || f < f2 && this.ids.size() < this.preferredMaximumSize) {
            this.ids.add(l);
            this.priorities.add(f);
        } else if (f > f2) {
            int n;
            if (this.ids.size() >= this.preferredMaximumSize) {
                n = this.ids.size() - 1;
                while (n - 1 >= 0 && this.priorities.get(n - 1) == f2) {
                    --n;
                }
                if (n >= this.preferredMaximumSize - 1) {
                    this.ids.remove(n, this.ids.size() - n);
                    this.priorities.remove(n, this.priorities.size() - n);
                }
            }
            n = this.ids.size();
            while (n - 1 >= 0 && f > this.priorities.get(n - 1)) {
                --n;
            }
            this.ids.insert(n, l);
            this.priorities.insert(n, f);
        }
    }

    public float getLowestPriority() {
        float f = Float.NEGATIVE_INFINITY;
        if (this.priorities.size() >= this.preferredMaximumSize) {
            f = this.priorities.get(this.priorities.size() - 1);
        }
        return f;
    }

    public void forEachId(TLongProcedure tLongProcedure) {
        for (int i = 0; i < this.ids.size() && tLongProcedure.execute(this.ids.get(i)); ++i) {
        }
    }

    public long[] toNativeArray() {
        return this.ids.toNativeArray();
    }
}

