/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.xml.XmlResponse;
import org.geotools.data.ws.WSDataStoreFactory;
import org.geotools.data.ws.WS_DataStore;
import org.geotools.data.ws.protocol.ws.WSProtocol;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.util.Converters;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public class XmlDataStoreTest
extends TestCase {
    private static final String MOCK_DS_PARAM_KEY = "DATA_FILE_DIRECTORY_PARAM_KEY";
    private static final SAXBuilder sax = new SAXBuilder();
    private static final String schemaBase = "/test-data/";
    private static final String CGINS = "urn:cgi:xmlns:CGI:Utilities:1.0";
    private final int MAX_FEATURES = 1;
    private AppSchemaDataAccess mappingDataStore;
    private Name typeName;
    static FilterFactory ff;

    protected void setUp() throws Exception {
        super.setUp();
        this.setFilterFactory();
        this.buildXmlBackedDataAccess();
        this.typeName = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnit");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        DataAccessRegistry.unregisterAndDisposeAll();
    }

    public void testDataStoreCreated() throws Exception {
        XmlDataStoreTest.assertNotNull((Object)this.mappingDataStore);
        FeatureType mappedFeatureType = this.mappingDataStore.getSchema(this.typeName);
        XmlDataStoreTest.assertNotNull((Object)mappedFeatureType);
    }

    public void testFilterTranslation() throws Exception {
        PropertyIsEqualTo inputFilter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"Unit Name1233811724109 UC1233811724109 description name"));
        FeatureCollection features = this.getFeatures(Integer.MAX_VALUE, (Filter)inputFilter);
        XmlDataStoreTest.assertEquals((int)1, (int)DataUtilities.count((FeatureCollection)features));
        FeatureIterator iterator = features.features();
        Feature f = iterator.next();
        XmlDataStoreTest.assertEquals((String)f.getIdentifier().toString(), (String)"lithostratigraphic.unit.1679161041155866313");
        iterator.close();
    }

    public void testFeatureCounting() throws Exception {
        PropertyIsLike inputFilter = ff.like((Expression)ff.property("gml:name"), "*description name*");
        FeatureCollection features = this.getFeatures(Integer.MAX_VALUE, (Filter)inputFilter);
        XmlDataStoreTest.assertEquals((int)3, (int)DataUtilities.count((FeatureCollection)features));
        FeatureIterator iterator = features.features();
        Feature f = iterator.next();
        XmlDataStoreTest.assertEquals((String)f.getIdentifier().toString(), (String)"lithostratigraphic.unit.1679161021439131319");
        XmlDataStoreTest.assertTrue((boolean)iterator.hasNext());
        f = iterator.next();
        XmlDataStoreTest.assertEquals((String)f.getIdentifier().toString(), (String)"lithostratigraphic.unit.1679161041155866313");
        XmlDataStoreTest.assertTrue((boolean)iterator.hasNext());
        f = iterator.next();
        XmlDataStoreTest.assertEquals((String)f.getIdentifier().toString(), (String)"lithostratigraphic.unit.1679161021439938381");
        iterator.close();
        features = this.getFeatures(1, (Filter)inputFilter);
        XmlDataStoreTest.assertEquals((int)1, (int)DataUtilities.count((FeatureCollection)features));
        iterator = features.features();
        f = iterator.next();
        XmlDataStoreTest.assertEquals((String)f.getIdentifier().toString(), (String)"lithostratigraphic.unit.1679161021439131319");
        iterator.close();
    }

    public void testNoElementsReturned() throws Exception {
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"invalid name"));
        FeatureCollection features = this.getFeatures(1, (Filter)filter);
        XmlDataStoreTest.assertEquals((int)0, (int)DataUtilities.count((FeatureCollection)features));
        ArrayList<Feature> results = new ArrayList<Feature>();
        FeatureIterator it = features.features();
        while (it.hasNext()) {
            results.add(it.next());
        }
        it.close();
        XmlDataStoreTest.assertEquals((int)0, (int)results.size());
    }

    public void testFeaturesCreatedCorrectly() throws Exception {
        NameImpl GeologicUnitName = new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "GeologicUnit");
        NameImpl GeologicUnitType = new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "GeologicUnitType");
        ArrayList<Feature> results = new ArrayList<Feature>();
        FeatureCollection features = this.getFeatures(Integer.MAX_VALUE, (Filter)Filter.INCLUDE);
        FeatureIterator it = features.features();
        while (it.hasNext()) {
            results.add(it.next());
        }
        it.close();
        int EXPECTED_SIZE = 3;
        XmlDataStoreTest.assertEquals((int)3, (int)results.size());
        String[] ids = new String[]{"lithostratigraphic.unit.1679161021439131319", "lithostratigraphic.unit.1679161041155866313", "lithostratigraphic.unit.1679161021439938381"};
        for (int i = 0; i < 3; ++i) {
            Feature f = (Feature)results.get(i);
            XmlDataStoreTest.assertEquals((String)ids[i], (String)f.getIdentifier().getID());
            XmlDataStoreTest.assertEquals((Object)GeologicUnitName, (Object)f.getName());
            XmlDataStoreTest.assertEquals((Object)GeologicUnitType, (Object)f.getDescriptor().getType().getName());
            List<Attribute> attPurposeList = this.getAttributesForProperty(f, "purpose");
            XmlDataStoreTest.assertEquals((int)1, (int)attPurposeList.size());
            Attribute at = attPurposeList.get(0);
            XmlDataStoreTest.assertEquals((String)"CONSTANT", (String)this.getValueForAttribute(at));
            XmlDataStoreTest.assertFalse((boolean)at.getUserData().containsKey(Attributes.class));
            List<Attribute> attGUTypeList = this.getAttributesForProperty(f, "rank");
            XmlDataStoreTest.assertEquals((int)1, (int)attGUTypeList.size());
            at = attGUTypeList.get(0);
            XmlDataStoreTest.assertEquals((String)"", (String)this.getValueForAttribute(at));
            XmlDataStoreTest.assertEquals((int)1, (int)((Map)at.getUserData().get(Attributes.class)).size());
            XmlDataStoreTest.assertEquals((String)"urn:cgi:classifier:GSV:LithostratigraphicUnitRank:formation", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("http://www.w3.org/1999/xlink", "href")));
            List<Attribute> attObMethList = this.getAttributesForProperty(f, "observationMethod");
            XmlDataStoreTest.assertEquals((int)1, (int)attObMethList.size());
            at = attObMethList.get(0);
            XmlDataStoreTest.assertEquals(null, (Object)at.getIdentifier());
            XmlDataStoreTest.assertEquals((Object)new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "observationMethod"), (Object)at.getName());
            XmlDataStoreTest.assertEquals((Object)new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "CGI_TermValuePropertyType"), (Object)at.getDescriptor().getType().getName());
            ComplexAttributeImpl ob = this.getNestedComplexValueForAttribute(at);
            XmlDataStoreTest.assertEquals(null, (Object)ob.getIdentifier());
            XmlDataStoreTest.assertEquals((Object)new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "CGI_TermValue"), (Object)ob.getName());
            XmlDataStoreTest.assertEquals((Object)new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "CGI_TermValueType"), (Object)ob.getDescriptor().getType().getName());
            ComplexAttributeImpl ob2 = this.getNestedComplexValueForAttribute((Attribute)ob);
            XmlDataStoreTest.assertEquals(null, (Object)ob2.getIdentifier());
            XmlDataStoreTest.assertEquals((Object)new NameImpl("urn:cgi:xmlns:CGI:GeoSciML:2.0", "value"), (Object)ob2.getName());
            XmlDataStoreTest.assertEquals((Object)new NameImpl(CGINS, "CodeWithAuthorityType"), (Object)ob2.getDescriptor().getType().getName());
            XmlDataStoreTest.assertEquals((String)"CONSTANT", (String)this.getValueForAttribute((Attribute)ob2));
            XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute((Attribute)ob2, (Name)new NameImpl("codeSpace")));
        }
        Feature feature = (Feature)results.get(0);
        List<Attribute> attDescList = this.getAttributesForProperty(feature, "description");
        XmlDataStoreTest.assertEquals((int)1, (int)attDescList.size());
        Attribute at = attDescList.get(0);
        XmlDataStoreTest.assertEquals((String)"Test description 1", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertFalse((boolean)at.getUserData().containsKey(Attributes.class));
        List<Attribute> attNameList = this.getAttributesForProperty(feature, "name");
        XmlDataStoreTest.assertEquals((int)2, (int)attNameList.size());
        at = attNameList.get(0);
        XmlDataStoreTest.assertEquals((String)"Unit Name1248396531312 UC1248396531312 description name", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)1, (int)((Map)at.getUserData().get(Attributes.class)).size());
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        at = attNameList.get(1);
        XmlDataStoreTest.assertEquals((String)"urn:cgi:feature:GSV:1679161021439131319", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertTrue((at.getUserData() != null && ((Map)at.getUserData().get(Attributes.class)).size() == 1 ? 1 : 0) != 0);
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        feature = (Feature)results.get(1);
        attDescList = this.getAttributesForProperty(feature, "description");
        XmlDataStoreTest.assertEquals((int)1, (int)attDescList.size());
        at = attDescList.get(0);
        XmlDataStoreTest.assertEquals((String)"Test description 1", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertFalse((boolean)at.getUserData().containsKey(Attributes.class));
        attNameList = this.getAttributesForProperty(feature, "name");
        XmlDataStoreTest.assertEquals((int)2, (int)attNameList.size());
        at = attNameList.get(0);
        XmlDataStoreTest.assertEquals((String)"Unit Name1233811724109 UC1233811724109 description name", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)1, (int)((Map)at.getUserData().get(Attributes.class)).size());
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        at = attNameList.get(1);
        XmlDataStoreTest.assertEquals((String)"urn:cgi:feature:GSV:1679161041155866313", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertTrue((at.getUserData() != null && ((Map)at.getUserData().get(Attributes.class)).size() == 1 ? 1 : 0) != 0);
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        feature = (Feature)results.get(2);
        attDescList = this.getAttributesForProperty(feature, "description");
        XmlDataStoreTest.assertEquals((int)1, (int)attDescList.size());
        at = attDescList.get(0);
        XmlDataStoreTest.assertEquals((String)"Test description 2", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertFalse((boolean)at.getUserData().containsKey(Attributes.class));
        attNameList = this.getAttributesForProperty(feature, "name");
        XmlDataStoreTest.assertEquals((int)2, (int)attNameList.size());
        at = attNameList.get(0);
        XmlDataStoreTest.assertEquals((String)"Unit Name1248396020281 UC1248396020281 description name 2", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)1, (int)((Map)at.getUserData().get(Attributes.class)).size());
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        at = attNameList.get(1);
        XmlDataStoreTest.assertEquals((String)"urn:cgi:feature:GSV:1679161021439938381", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertTrue((at.getUserData() != null && ((Map)at.getUserData().get(Attributes.class)).size() == 1 ? 1 : 0) != 0);
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
    }

    private String getValueForAttribute(Attribute sv) {
        Object value;
        if (sv instanceof ComplexAttribute && (value = GML3EncodingUtils.getSimpleContent((ComplexAttribute)((ComplexAttribute)sv))) != null) {
            return (String)Converters.convert((Object)value, String.class);
        }
        value = null;
        Object ob = sv.getValue();
        if (ob instanceof String) {
            value = (String)ob;
        } else {
            List values = (List)ob;
            if (values != null && values.size() > 0) {
                value = values.get(0).toString();
            }
        }
        return value;
    }

    private ComplexAttributeImpl getNestedComplexValueForAttribute(Attribute sv) {
        Object value = null;
        Object ob = sv.getValue();
        List values = (List)ob;
        if (values != null && values.size() > 0) {
            value = values.get(0);
        }
        return value;
    }

    private String getUserDataForAttribute(Attribute sv, Name key) {
        String value = null;
        Map userData = sv.getUserData();
        if (userData.containsKey(Attributes.class)) {
            Map map = (Map)userData.get(Attributes.class);
            value = (String)map.get(key);
        }
        return value;
    }

    private List<Attribute> getAttributesForProperty(Feature feature, String propertyName) {
        ArrayList<Attribute> returnValues = new ArrayList<Attribute>();
        Collection cs = feature.getProperties(propertyName);
        for (Attribute sv : cs) {
            returnValues.add(sv);
        }
        return returnValues;
    }

    private Query namedQuery(Filter filter, int count) throws Exception {
        return new Query("GeologicUnit", new URI("urn:cgi:xmlns:CGI:GeoSciML:2.0"), filter, count, new String[0], "test");
    }

    private void setFilterFactory() {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        ff = new FilterFactoryImplNamespaceAware(namespaces);
    }

    private void buildXmlBackedDataAccess() throws IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("/test-data/xmlDataAccessConfig.xml");
        XmlDataStoreTest.assertNotNull((Object)url);
        AppSchemaDataAccessDTO config = new XMLConfigDigester().parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        this.mappingDataStore = new AppSchemaDataAccess(mappings);
    }

    private String getExpectedFilter() {
        String prefix = "/soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/";
        return "[[ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:formattedName = Unit Name1233811724109 UC1233811724109 description name ] OR [ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:urn[@domain='GSV'] = Unit Name1233811724109 UC1233811724109 description name ]]";
    }

    private String getReversedExpectedFilter() {
        String prefix = "/soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/";
        return "[[ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:urn[@domain='GSV'] = Unit Name1233811724109 UC1233811724109 description name ] OR [ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:formattedName = Unit Name1233811724109 UC1233811724109 description name ]]";
    }

    private FeatureCollection getFeatures(int maxFeatures, Filter inputFilter) throws Exception {
        FeatureSource fSource = this.mappingDataStore.getFeatureSource(this.typeName);
        FeatureCollection features = fSource.getFeatures(this.namedQuery(inputFilter, new Integer(maxFeatures)));
        return features;
    }

    public static final class XmlDataStore
    extends WS_DataStore {
        private String fileName;

        public XmlDataStore(WSProtocol protocol) {
            super(protocol);
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public XmlResponse getXmlReader(Query query) throws IOException {
            if (Filter.EXCLUDE.equals(query.getFilter())) {
                return null;
            }
            Query callQuery = new Query(query);
            Filter[] filters = this.getProtocol().splitFilters(query.getFilter());
            Filter supportedFilter = filters[0];
            Filter postFilter = filters[1];
            callQuery.setFilter(supportedFilter);
            Document doc = this.getXmlResponse();
            List validFeatureIndex = this.determineValidFeatures(postFilter, doc, query.getMaxFeatures());
            return new XmlResponse(doc, validFeatureIndex);
        }

        public XmlResponse getXmlReader(Query query, String xpath, String value) throws IOException {
            Document doc = this.getXmlResponse();
            List validFeatureIndex = this.determineValidFeatures(xpath, value, doc, query.getMaxFeatures());
            return new XmlResponse(doc, validFeatureIndex);
        }

        private Document getXmlResponse() throws IOException {
            Document doc = null;
            BufferedInputStream dos = null;
            try {
                File outFile = new File(this.fileName);
                dos = new BufferedInputStream(new FileInputStream(outFile));
                doc = sax.build((InputStream)dos);
            }
            catch (JDOMException e1) {
                throw new RuntimeException("error reading xml from file ", e1);
            }
            finally {
                if (dos != null) {
                    dos.close();
                }
            }
            return doc;
        }
    }

    public static class MockXmlDataStoreFactory
    extends WSDataStoreFactory {
        public boolean isAvailable() {
            return true;
        }

        public boolean canProcess(Map params) {
            return params.get(XmlDataStoreTest.MOCK_DS_PARAM_KEY) != null;
        }

        public XmlDataStore createDataStore(Map params) throws IOException {
            XmlDataStore ds = null;
            HashMap<String, Object> wsParams = new HashMap<String, Object>();
            wsParams.put("WSDataStoreFactory:GET_CONNECTION_URL", "http://d00109:8080/xaware/XADocSoapServlet");
            wsParams.put("WSDataStoreFactory:TIMEOUT", new Integer(30000));
            wsParams.put("WSDataStoreFactory:TEMPLATE_DIRECTORY", ((Object)((Object)this)).getClass().getResource(XmlDataStoreTest.schemaBase));
            wsParams.put("WSDataStoreFactory:TEMPLATE_NAME", "request.ftl");
            wsParams.put("WSDataStoreFactory:CAPABILITIES_FILE_LOCATION", ((Object)((Object)this)).getClass().getResource("/test-data/ws_capabilities_equals_removed.xml"));
            org.geotools.data.ws.XmlDataStore wsStore = super.createDataStore(wsParams);
            ds = new XmlDataStore(((WS_DataStore)wsStore).getProtocol());
            ds.setFileName((String)params.get(XmlDataStoreTest.MOCK_DS_PARAM_KEY));
            return ds;
        }
    }
}

