/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.XmlDataStoreTest;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.junit.BeforeClass;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaWithBackendDataAccessIntegrationTest
extends TestCase {
    static FilterFactory ff;
    private final int MAX_FEATURES = 5;
    private Name typeName;
    private static final String schemaBase = "/test-data/";
    private static AppSchemaDataAccess newGuDataAccess;

    @BeforeClass
    protected void setUp() throws Exception {
        super.setUp();
        this.setFilterFactory();
        this.typeName = Types.typeName((String)"GeologicUnit1");
        URL url = XmlDataStoreTest.class.getResource("/test-data/xmlDataAccessConfig.xml");
        AppSchemaWithBackendDataAccessIntegrationTest.assertNotNull((Object)url);
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        newGuDataAccess = (AppSchemaDataAccess)DataAccessFinder.getDataStore(dsParams);
        AppSchemaWithBackendDataAccessIntegrationTest.assertNotNull((Object)newGuDataAccess);
    }

    protected void tearDown() throws Exception {
        DataAccessRegistry.unregisterAndDisposeAll();
        super.tearDown();
    }

    public void testSimplePropertyFilter() throws Exception {
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("gml:name/@codeSpace"), (Expression)ff.literal((Object)"gsv:NameSpace"));
        this.runAppSchemaBackendTests((Filter)filter);
    }

    public void testComplexPropertyFilter() throws Exception {
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("gsml:observationMethod/gsml:CGI_TermValue/gsml:value"), (Expression)ff.literal((Object)"CONSTANT"));
        this.runAppSchemaBackendTests((Filter)filter);
    }

    private void runAppSchemaBackendTests(Filter filter) throws Exception {
        Name GEOLOGIC_UNIT1 = Types.typeName((String)"GeologicUnit1");
        FeatureSource guFeatureSource = newGuDataAccess.getFeatureSourceByName(GEOLOGIC_UNIT1);
        AppSchemaWithBackendDataAccessIntegrationTest.assertNotNull((Object)guFeatureSource);
        ArrayList<Feature> results = new ArrayList<Feature>();
        FeatureCollection<FeatureType, Feature> features = this.getFeatures(5, filter);
        FeatureIterator it = features.features();
        while (it.hasNext()) {
            results.add(it.next());
        }
        it.close();
    }

    private void setFilterFactory() {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        ff = new FilterFactoryImplNamespaceAware(namespaces);
    }

    private FeatureCollection<FeatureType, Feature> getFeatures(int maxFeatures, Filter inputFilter) throws Exception {
        FeatureSource fSource = newGuDataAccess.getFeatureSourceByName(this.typeName);
        FeatureCollection features = fSource.getFeatures(this.namedQuery(inputFilter, new Integer(maxFeatures)));
        return features;
    }

    private Query namedQuery(Filter filter, int count) throws Exception {
        return new Query("GeologicUnit", new URI("urn:cgi:xmlns:CGI:GeoSciML:2.0"), filter, count, new String[0], "test");
    }
}

