/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.ws.WSDataStoreFactory;
import org.geotools.data.ws.WS_DataStore;
import org.geotools.data.ws.XmlDataStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WSDataStoreFactoryTest {
    private static final String BASE_DIRECTORY = "./src/test/resources/test-data/";
    private WSDataStoreFactory dsf;
    private Map<String, Serializable> params;

    @Before
    public void setUp() throws Exception {
        this.dsf = new WSDataStoreFactory();
        this.params = new HashMap<String, Serializable>();
    }

    @After
    public void tearDown() throws Exception {
        this.dsf = null;
        this.params = null;
    }

    @Test
    public void testCanProcess() {
        Assert.assertFalse((boolean)this.dsf.canProcess(this.params));
        this.params.put(WSDataStoreFactory.GET_CONNECTION_URL.key, (Serializable)((Object)"http://someserver.example.org/wfs?request=GetCapabilities"));
        Assert.assertFalse((boolean)this.dsf.canProcess(this.params));
        this.params.put(WSDataStoreFactory.TEMPLATE_NAME.key, (Serializable)((Object)"request.ftl"));
        Assert.assertFalse((boolean)this.dsf.canProcess(this.params));
        try {
            this.params.put(WSDataStoreFactory.TEMPLATE_DIRECTORY.key, new URL("file:./src/test/resources/test-data"));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)this.dsf.canProcess(this.params));
        try {
            this.params.put(WSDataStoreFactory.CAPABILITIES_FILE_LOCATION.key, new URL("file:./src/test/resources/test-data/ws_capabilities.xml"));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)this.dsf.canProcess(this.params));
        this.params.put(WSDataStoreFactory.TIMEOUT.key, (Serializable)((Object)"30000"));
        Assert.assertTrue((boolean)this.dsf.canProcess(this.params));
    }

    @Test
    public void testCreateDataStoreWS() throws IOException {
        String capabilitiesFile = "ws_capabilities_equals_removed.xml";
        this.testCreateDataStore_WS(capabilitiesFile);
    }

    private void testCreateDataStore_WS(String capabilitiesFile) throws IOException {
        WSDataStoreFactory dsf = new WSDataStoreFactory();
        HashMap<String, Object> params = new HashMap<String, Object>();
        File file = new File(BASE_DIRECTORY + capabilitiesFile);
        if (!file.exists()) {
            throw new IllegalArgumentException(capabilitiesFile + " not found");
        }
        URL url = file.toURL();
        params.put(WSDataStoreFactory.GET_CONNECTION_URL.key, url);
        params.put(WSDataStoreFactory.TEMPLATE_DIRECTORY.key, new URL("file:./src/test/resources/test-data/"));
        params.put(WSDataStoreFactory.TEMPLATE_NAME.key, "request.ftl");
        params.put(WSDataStoreFactory.CAPABILITIES_FILE_LOCATION.key, url);
        XmlDataStore dataStore = dsf.createDataStore(params);
        Assert.assertTrue((boolean)(dataStore instanceof WS_DataStore));
    }
}

