/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import java.io.IOException;
import org.geotools.data.Query;
import org.geotools.data.complex.xml.XmlFeatureCollection;
import org.geotools.data.complex.xml.XmlResponse;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.data.ws.XmlDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

public class WSFeatureCollection
extends DataFeatureCollection
implements XmlFeatureCollection {
    private Query query;
    private XmlDataStore dataStore;
    private XmlResponse xmlResponse;
    private int cachedSize = -1;

    public WSFeatureCollection(XmlDataStore dataStore, Query query) throws IOException {
        this.dataStore = dataStore;
        this.query = query;
    }

    public SimpleFeatureType getSchema() {
        throw new UnsupportedOperationException("No schema for WS!");
    }

    public ReferencedEnvelope getBounds() {
        throw new UnsupportedOperationException("No bounds for WS!");
    }

    public int getCount() throws IOException {
        if (this.cachedSize != -1) {
            return this.cachedSize;
        }
        this.cachedSize = this.dataStore.getCount(this.query);
        if (this.cachedSize == -1) {
            this.getBounds();
        }
        return this.cachedSize;
    }

    public XmlResponse xmlResponse(String xpath, String value) {
        try {
            this.xmlResponse = this.dataStore.getXmlReader(this.query, xpath, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.xmlResponse;
    }

    public XmlResponse xmlResponse() {
        try {
            this.xmlResponse = this.dataStore.getXmlReader(this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.xmlResponse;
    }
}

