/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.complex.xml.XmlFeatureSource;
import org.geotools.data.ws.WSFeatureCollection;
import org.geotools.data.ws.WS_DataStore;
import org.geotools.data.ws.XmlDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.xml.sax.helpers.NamespaceSupport;

public class WSFeatureSource
implements XmlFeatureSource {
    private String typeName;
    private XmlDataStore dataStore;
    private QueryCapabilities queryCapabilities;

    public WSFeatureSource(WS_DataStore dataStore, String typeName, Name name) throws IOException {
        this.typeName = typeName;
        this.dataStore = dataStore;
        this.queryCapabilities = new QueryCapabilities();
    }

    public Name getName() {
        return this.dataStore.getName();
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public SimpleFeatureType getSchema() {
        throw new UnsupportedOperationException("getSchema not supported");
    }

    public void setNamespaces(NamespaceSupport namespaces) {
        this.dataStore.setNamespaces(namespaces);
    }

    public void setItemXpath(String itemXpath) {
        this.dataStore.setItemXpath(itemXpath);
    }

    public ResourceInfo getInfo() {
        throw new UnsupportedOperationException("getInfo not supported");
    }

    public void addFeatureListener(FeatureListener listener) {
    }

    public void removeFeatureListener(FeatureListener listener) {
    }

    public ReferencedEnvelope getBounds() throws IOException {
        throw new UnsupportedOperationException("getBounds not supported");
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        throw new UnsupportedOperationException("getBounds not supported");
    }

    public int getCount(Query query) throws IOException {
        Query namedQuery = this.namedQuery(this.typeName, query);
        int count = this.dataStore.getCount(namedQuery);
        return count;
    }

    public WSFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.typeName, filter));
    }

    public WSFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.typeName));
    }

    public WSFeatureCollection getFeatures(Query query) throws IOException {
        Query namedQuery = this.namedQuery(this.typeName, query);
        return new WSFeatureCollection(this.dataStore, namedQuery);
    }

    public Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }

    private Query namedQuery(String typeName, Query query) {
        String quertyTypeName = query.getTypeName();
        if (quertyTypeName != null && !quertyTypeName.equals(typeName)) {
            throw new IllegalArgumentException("Wrong query type name: " + quertyTypeName + ". Name should be " + typeName);
        }
        DefaultQuery named = new DefaultQuery(query);
        named.setTypeName(typeName);
        return named;
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }
}

