/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.wfs.FeatureTypeType;
import net.opengis.wfs.WFSCapabilitiesType;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.ws.WSStrategy;
import org.geotools.data.ws.protocol.http.HTTPProtocol;
import org.geotools.data.ws.protocol.http.HTTPResponse;
import org.geotools.data.ws.protocol.ws.WSProtocol;
import org.geotools.data.ws.protocol.ws.WSResponse;
import org.geotools.filter.Capabilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.FilterCapabilities;
import org.xml.sax.SAXException;

public class WS_Protocol
implements WSProtocol {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.ws");
    private WSStrategy strategy;
    private final Map<String, FeatureTypeType> typeInfos;
    private HTTPProtocol http;
    private URL url;
    final WFSCapabilitiesType capabilities;
    private InputStream capabilitiesStream;

    public WS_Protocol(InputStream capabilitiesReader, WSStrategy strategy, URL query, HTTPProtocol http) throws IOException {
        this.strategy = strategy;
        this.capabilitiesStream = capabilitiesReader;
        this.capabilities = this.parseCapabilities(capabilitiesReader);
        this.http = http;
        this.url = query;
        this.typeInfos = new HashMap<String, FeatureTypeType>();
    }

    public void setStrategy(WSStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public URL getOperationURL() {
        return this.url;
    }

    @Override
    public void clean() throws IOException {
        if (this.capabilitiesStream != null) {
            this.capabilitiesStream.close();
        }
    }

    @Override
    public Set<QName> getFeatureTypeNames() {
        HashSet<QName> typeNames = new HashSet<QName>();
        for (FeatureTypeType typeInfo : this.typeInfos.values()) {
            QName name = typeInfo.getName();
            typeNames.add(name);
        }
        return typeNames;
    }

    @Override
    public WSResponse issueGetFeature(Query query) throws IOException {
        Map dataValues = this.strategy.getRequestData(query);
        return this.issuePostRequest(dataValues, this.url);
    }

    private WSResponse issuePostRequest(final Map request, URL url) throws IOException {
        HTTPProtocol.POSTCallBack requestBodyCallback = new HTTPProtocol.POSTCallBack(){

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public String getContentType() {
                return "text/xml";
            }

            @Override
            public void writeBody(OutputStream out) throws IOException {
                WS_Protocol.encode(request, WS_Protocol.this.strategy, out);
            }
        };
        HTTPResponse httpResponse = this.http.issuePost(url, requestBodyCallback);
        InputStream responseStream = httpResponse.getResponseStream();
        return new WSResponse(responseStream);
    }

    public static void encode(EObject request, Configuration configuration, OutputStream out, Charset charset) throws IOException {
        Encoder encoder = new Encoder(configuration);
        encoder.setEncoding(charset);
    }

    private static void encode(Map data, WSStrategy strategy, OutputStream out) throws IOException {
        Template template = strategy.getTemplate();
        OutputStreamWriter wr = new OutputStreamWriter(out);
        try {
            template.process((Object)data, (Writer)wr);
        }
        catch (TemplateException e) {
            throw new RuntimeException("error creating request template", e);
        }
    }

    private WFSCapabilitiesType parseCapabilities(InputStream capabilitiesReader) throws IOException {
        Object parsed;
        Configuration wsConfig = this.strategy.getWsConfiguration();
        Parser parser = new Parser(wsConfig);
        try {
            parsed = parser.parse(capabilitiesReader);
        }
        catch (SAXException e) {
            throw new DataSourceException("Exception parsing WFS 1.1.0 capabilities", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new DataSourceException("WFS 1.1.0 parsing configuration error", (Throwable)e);
        }
        if (parsed == null) {
            throw new DataSourceException("WFS 1.1.0 capabilities was not parsed");
        }
        if (!(parsed instanceof WFSCapabilitiesType)) {
            throw new DataSourceException("Expected WFS Capabilities, got " + parsed);
        }
        return (WFSCapabilitiesType)parsed;
    }

    @Override
    public FilterCapabilities getFilterCapabilities() {
        return this.capabilities.getFilterCapabilities();
    }

    @Override
    public Filter[] splitFilters(Filter filter) {
        FilterCapabilities filterCapabilities = this.getFilterCapabilities();
        Capabilities filterCaps = new Capabilities();
        if (filterCapabilities != null) {
            filterCaps.addAll(filterCapabilities);
        }
        return this.strategy.splitFilters(filterCaps, filter);
    }
}

