/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.ws.WSStrategy;
import org.geotools.filter.Capabilities;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class DefaultWSStrategy
implements WSStrategy {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.ws");
    private Configuration cfg;
    private Template requestTemplate;
    private final org.geotools.xml.Configuration ws_Configuration = new WFSConfiguration();

    public DefaultWSStrategy(URL templateDirectory, String templateName) {
        LOGGER.info("template directory is: " + templateDirectory);
        this.initialiseFreeMarkerConfiguration(templateDirectory);
        try {
            this.requestTemplate = this.cfg.getTemplate(templateName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initialiseFreeMarkerConfiguration(URL templateDirectory) {
        this.cfg = new Configuration();
        try {
            this.cfg.setDirectoryForTemplateLoading(DataUtilities.urlToFile((URL)templateDirectory));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    @Override
    public Template getTemplate() {
        return this.requestTemplate;
    }

    @Override
    public Map getRequestData(Query query) throws IOException {
        HashMap<String, String> root = new HashMap<String, String>();
        Filter filter = query.getFilter();
        Integer maxfeatures = query.getMaxFeatures();
        if (maxfeatures == null) {
            maxfeatures = new Integer(0);
        }
        String filterString = filter.toString();
        String cqlFilter = CQL.toCQL((Filter)filter);
        LOGGER.info("Filter string: " + filterString);
        LOGGER.info("Filter CQL: " + cqlFilter);
        LOGGER.info("MaxFeatures: " + maxfeatures);
        root.put("filterString", filterString);
        root.put("filterCql", cqlFilter);
        root.put("maxFeatures", maxfeatures.toString());
        root.put("query", (String)query);
        return root;
    }

    @Override
    public org.geotools.xml.Configuration getWsConfiguration() {
        return this.ws_Configuration;
    }

    @Override
    public Filter[] splitFilters(Capabilities caps, Filter queryFilter) {
        CapabilitiesFilterSplitter splitter = new CapabilitiesFilterSplitter(caps, null, null);
        queryFilter.accept((FilterVisitor)splitter, null);
        Filter server = splitter.getFilterPre();
        Filter post = splitter.getFilterPost();
        return new Filter[]{server, post};
    }
}

