/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.ws.DefaultWSStrategy;
import org.geotools.data.ws.WSStrategy;
import org.geotools.data.ws.WS_DataStore;
import org.geotools.data.ws.WS_Protocol;
import org.geotools.data.ws.XmlDataStore;
import org.geotools.data.ws.protocol.http.SimpleHttpProtocol;
import org.geotools.util.logging.Logging;

public class WSDataStoreFactory
extends AbstractDataStoreFactory {
    private static final Logger logger = Logging.getLogger((String)"org.geotools.data.ws");
    private static final WSFactoryParam[] parametersInfo = new WSFactoryParam[7];
    public static final WSFactoryParam<URL> GET_CONNECTION_URL;
    public static final WSFactoryParam<Integer> TIMEOUT;
    public static final WSFactoryParam<Boolean> TRY_GZIP;
    public static final WSFactoryParam<String> TEMPLATE_NAME;
    public static final WSFactoryParam<URL> TEMPLATE_DIRECTORY;
    public static final WSFactoryParam<URL> CAPABILITIES_FILE_LOCATION;
    protected Map<Map, XmlDataStore> perParameterSetDataStoreCache = new HashMap<Map, XmlDataStore>();

    public XmlDataStore createDataStore(Map params) throws IOException {
        if (this.perParameterSetDataStoreCache.containsKey(params)) {
            return this.perParameterSetDataStoreCache.get(params);
        }
        URL getQueryRequest = GET_CONNECTION_URL.lookUp(params);
        int timeoutMillis = TIMEOUT.lookUp(params);
        boolean tryGZIP = TRY_GZIP.lookUp(params);
        String templateName = TEMPLATE_NAME.lookUp(params);
        URL templateDirectory = TEMPLATE_DIRECTORY.lookUp(params);
        URL capabilitiesDirectory = CAPABILITIES_FILE_LOCATION.lookUp(params);
        SimpleHttpProtocol http = new SimpleHttpProtocol();
        http.setTryGzip(tryGZIP);
        http.setTimeoutMillis(timeoutMillis);
        BufferedInputStream capsIn = new BufferedInputStream(new FileInputStream(DataUtilities.urlToFile((URL)capabilitiesDirectory)));
        WSStrategy strategy = WSDataStoreFactory.determineCorrectStrategy(templateDirectory, templateName);
        WS_Protocol ws = new WS_Protocol(capsIn, strategy, getQueryRequest, http);
        WS_DataStore dataStore = new WS_DataStore(ws);
        this.perParameterSetDataStoreCache.put(new HashMap(params), dataStore);
        return dataStore;
    }

    static WSStrategy determineCorrectStrategy(URL templateDirectory, String templateName) {
        DefaultWSStrategy strategy = new DefaultWSStrategy(templateDirectory, templateName);
        logger.info("Using WS Strategy: " + strategy.getClass().getName());
        return strategy;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Operation not applicable to a WS service");
    }

    public String getDescription() {
        return "The XmlDataStore represents a connection to a Web Feature Server. This connection provides access to the Features published by the server, and the ability to perform transactions on the server (when supported / allowed).";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        int length = parametersInfo.length;
        DataAccessFactory.Param[] params = new DataAccessFactory.Param[length];
        System.arraycopy(parametersInfo, 0, params, 0, length);
        return params;
    }

    public boolean canProcess(Map params) {
        if (params == null) {
            throw new NullPointerException("params");
        }
        try {
            GET_CONNECTION_URL.lookUp(params);
            TEMPLATE_NAME.lookUp(params);
            TEMPLATE_DIRECTORY.lookUp(params);
            CAPABILITIES_FILE_LOCATION.lookUp(params);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getDisplayName() {
        return "Web Service Server";
    }

    public boolean isAvailable() {
        return true;
    }

    static {
        String name = "WSDataStoreFactory:GET_CONNECTION_URL";
        Class clazz = URL.class;
        String description = "Represents a URL to the getCapabilities document or a server instance.";
        WSDataStoreFactory.parametersInfo[0] = new WSFactoryParam(name, clazz, description);
        name = "WSDataStoreFactory:TIMEOUT";
        clazz = Integer.class;
        description = "This allows the user to specify a timeout in milliseconds. This param has a default value of unlimited.";
        WSDataStoreFactory.parametersInfo[1] = new WSFactoryParam<Integer>(name, clazz, description, -1);
        name = "WSDataStoreFactory:TRY_GZIP";
        clazz = Boolean.class;
        description = "Indicates that datastore should use gzip to transfer data if the server supports it. Default is true";
        WSDataStoreFactory.parametersInfo[2] = new WSFactoryParam<Boolean>(name, clazz, description, Boolean.TRUE);
        name = "WSDataStoreFactory:MAXFEATURES";
        clazz = Integer.class;
        description = "Positive integer used as a hard limit for the amount of Features to retrieve for each FeatureType. A value of zero or not providing this parameter means no limit.";
        WSDataStoreFactory.parametersInfo[3] = new WSFactoryParam<Integer>(name, clazz, description, 0);
        name = "WSDataStoreFactory:TEMPLATE_NAME";
        clazz = String.class;
        description = "File name of the template used to create the XML request";
        WSDataStoreFactory.parametersInfo[4] = new WSFactoryParam(name, clazz, description);
        name = "WSDataStoreFactory:TEMPLATE_DIRECTORY";
        clazz = URL.class;
        description = "Directory where the template used to create the XML request has been put";
        WSDataStoreFactory.parametersInfo[5] = new WSFactoryParam(name, clazz, description);
        name = "WSDataStoreFactory:CAPABILITIES_FILE_LOCATION";
        clazz = URL.class;
        description = "The location of the capabilities file";
        WSDataStoreFactory.parametersInfo[6] = new WSFactoryParam(name, clazz, description);
        GET_CONNECTION_URL = parametersInfo[0];
        TIMEOUT = parametersInfo[1];
        TRY_GZIP = parametersInfo[2];
        TEMPLATE_NAME = parametersInfo[4];
        TEMPLATE_DIRECTORY = parametersInfo[5];
        CAPABILITIES_FILE_LOCATION = parametersInfo[6];
    }

    public static class WSFactoryParam<T>
    extends DataAccessFactory.Param {
        private T defaultValue;

        public WSFactoryParam(String key, Class type, String description) {
            super(key, type, description, true);
        }

        public WSFactoryParam(String key, Class type, String description, T defaultValue) {
            super(key, type, description, false);
            this.defaultValue = defaultValue;
        }

        public T lookUp(Map params) throws IOException {
            Object parameter = super.lookUp(params);
            return (T)(parameter == null ? this.defaultValue : parameter);
        }
    }
}

