/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.complex.xml.XmlResponse;
import org.geotools.data.complex.xml.XmlXpathFilterData;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.ws.WSFeatureSource;
import org.geotools.data.ws.XmlDataStore;
import org.geotools.data.ws.protocol.ws.WSProtocol;
import org.geotools.data.ws.protocol.ws.WSResponse;
import org.geotools.util.XmlXpathUtilites;
import org.geotools.util.logging.Logging;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.xml.sax.helpers.NamespaceSupport;

public class WS_DataStore
implements XmlDataStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.ws");
    private static final XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
    private static final SAXBuilder sax = new SAXBuilder();
    private final WSProtocol wsProtocol;
    private Name name;
    private NamespaceSupport namespaces;
    private String itemXpath;

    public WS_DataStore(WSProtocol wsProtocol) {
        if (wsProtocol == null) {
            throw new NullPointerException("ws protocol");
        }
        this.wsProtocol = wsProtocol;
    }

    public WSProtocol getProtocol() {
        return this.wsProtocol;
    }

    public ServiceInfo getInfo() {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public SimpleFeatureType getSchema(String prefixedTypeName) throws IOException {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public List<Name> getNames() throws IOException {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public String[] getTypeNames() throws IOException {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public void dispose() {
        try {
            this.wsProtocol.clean();
        }
        catch (IOException e) {
            LOGGER.info("Failed closing capabilities stream for web service backend store: " + e.getMessage());
        }
    }

    @Override
    public XmlResponse getXmlReader(Query query) throws IOException {
        if (Filter.EXCLUDE.equals(query.getFilter())) {
            return null;
        }
        Query callQuery = new Query(query);
        Filter[] filters = this.wsProtocol.splitFilters(query.getFilter());
        Filter supportedFilter = filters[0];
        Filter postFilter = filters[1];
        LOGGER.fine("Supported filter sent to web service backend:  " + supportedFilter);
        LOGGER.fine("Unsupported filter to be processed in GeoServer: " + postFilter);
        callQuery.setFilter(supportedFilter);
        WSResponse response = this.wsProtocol.issueGetFeature(callQuery);
        Document doc = this.getXmlResponse(response);
        List<Integer> validFeatureIndex = this.determineValidFeatures(postFilter, doc, query.getMaxFeatures());
        return new XmlResponse(doc, validFeatureIndex);
    }

    @Override
    public XmlResponse getXmlReader(Query query, String xpath, String value) throws IOException {
        WSResponse response = this.wsProtocol.issueGetFeature(query);
        Document doc = this.getXmlResponse(response);
        List<Integer> validFeatureIndex = this.determineValidFeatures(xpath, value, doc, query.getMaxFeatures());
        return new XmlResponse(doc, validFeatureIndex);
    }

    protected List<Integer> determineValidFeatures(Filter postFilter, Document doc, int maxFeatures) {
        int nodeCount = XmlXpathUtilites.countXPathNodes((NamespaceSupport)this.namespaces, (String)this.itemXpath, (Document)doc);
        ArrayList<Integer> validFeatureIndex = null;
        if (Filter.INCLUDE.equals(postFilter)) {
            validFeatureIndex = new ArrayList(nodeCount);
            int maxNode = nodeCount < maxFeatures ? nodeCount : maxFeatures;
            for (int i = 1; i <= maxNode; ++i) {
                validFeatureIndex.add(i);
            }
        } else {
            validFeatureIndex = new ArrayList<Integer>();
            for (int nodeIndex = 1; nodeIndex <= nodeCount && validFeatureIndex.size() <= maxFeatures; ++nodeIndex) {
                XmlXpathFilterData peek = new XmlXpathFilterData(this.namespaces, doc, nodeIndex, this.itemXpath);
                if (!postFilter.evaluate((Object)peek)) continue;
                validFeatureIndex.add(nodeIndex);
            }
        }
        return validFeatureIndex;
    }

    protected List<Integer> determineValidFeatures(String xpath, String value, Document doc, int maxFeatures) {
        int nodeCount = XmlXpathUtilites.countXPathNodes((NamespaceSupport)this.namespaces, (String)this.itemXpath, (Document)doc);
        ArrayList<Integer> validFeatureIndex = null;
        validFeatureIndex = new ArrayList<Integer>();
        List values = XmlXpathUtilites.getXPathValues((NamespaceSupport)this.namespaces, (String)xpath, (Document)doc);
        if (!values.isEmpty()) {
            for (int nodeIndex = 1; nodeIndex <= nodeCount && validFeatureIndex.size() <= maxFeatures; ++nodeIndex) {
                if (!((String)values.get(nodeIndex - 1)).equals(value)) continue;
                validFeatureIndex.add(nodeIndex);
            }
        }
        return validFeatureIndex;
    }

    private Document getXmlResponse(WSResponse response) throws IOException {
        Document doc = null;
        try {
            doc = sax.build(response.getInputStream());
        }
        catch (JDOMException e1) {
            throw new RuntimeException("error reading xml from http", e1);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(out.outputString(doc));
        }
        return doc;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public WSFeatureSource getFeatureSource(String typeName) throws IOException {
        return new WSFeatureSource(this, typeName, this.name);
    }

    public LockingManager getLockingManager() {
        throw new UnsupportedOperationException("DS not supported!");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This is a read only DataStore");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This is a read only DataStore");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This is a read only DataStore");
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        this.name = typeName;
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WS does not support update schema");
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WS does not support update schema");
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WS DataStore does not support createSchema");
    }

    @Override
    public int getCount(Query query) {
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WSDataStore[");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public void setNamespaces(NamespaceSupport namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public void setItemXpath(String itemXpath) {
        this.itemXpath = itemXpath;
    }
}

