/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ws.protocol.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.data.ws.protocol.http.HTTPProtocol;
import org.geotools.data.ws.protocol.http.HTTPResponse;
import org.geotools.util.logging.Logging;

public class SimpleHttpProtocol
implements HTTPProtocol {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.ws.protocol.http");
    private boolean tryGzip;
    protected int timeoutMillis = -1;

    @Override
    public boolean isTryGzip() {
        return this.tryGzip;
    }

    @Override
    public void setTryGzip(boolean tryGzip) {
        this.tryGzip = tryGzip;
    }

    @Override
    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void setTimeoutMillis(int milliseconds) {
        this.timeoutMillis = milliseconds;
    }

    @Override
    public HTTPResponse issuePost(URL targetUrl, HTTPProtocol.POSTCallBack callback) throws IOException {
        HttpURLConnection conn = this.openConnection(targetUrl);
        long contentLength = callback.getContentLength();
        conn.setRequestProperty("Content-Length", String.valueOf(contentLength));
        String bodyContentType = callback.getContentType();
        conn.setRequestProperty("Content-Type", bodyContentType);
        conn.setRequestProperty("SOAPAction", targetUrl.toString());
        OutputStream bodyOut = conn.getOutputStream();
        callback.writeBody(bodyOut);
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Request to webservice backend is:\n" + bodyOut);
        }
        SimpleHttpResponse response = new SimpleHttpResponse(conn);
        return response;
    }

    private HttpURLConnection openConnection(URL targetUrl) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)targetUrl.openConnection();
        if (0 < this.getTimeoutMillis()) {
            conn.setConnectTimeout(this.getTimeoutMillis());
            conn.setReadTimeout(this.getTimeoutMillis());
        }
        if (this.isTryGzip()) {
            conn.setRequestProperty("Accept-Encoding", "gzip");
        }
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        return conn;
    }

    private static class SimpleHttpResponse
    implements HTTPResponse {
        private HttpURLConnection conn;
        private InputStream inputStream;

        public SimpleHttpResponse(HttpURLConnection conn) {
            this.conn = conn;
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            if (this.inputStream == null) {
                InputStream responseStream = this.conn.getInputStream();
                responseStream = new BufferedInputStream(responseStream);
                String contentEncoding = this.conn.getContentEncoding();
                if (contentEncoding != null && contentEncoding.toLowerCase().indexOf("gzip") != -1) {
                    responseStream = new GZIPInputStream(responseStream);
                }
                this.inputStream = responseStream;
            }
            return this.inputStream;
        }
    }
}

