/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.DataSourceException;
import org.geotools.data.wfs.protocol.wfs.GetFeatureParser;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.StreamingParser;
import org.opengis.feature.simple.SimpleFeature;
import org.xml.sax.SAXException;

class StreamingParserFeatureReader
implements GetFeatureParser {
    private StreamingParser parser;
    private InputStream inputStream;

    public StreamingParserFeatureReader(Configuration wfsConfiguration, InputStream getFeatureResponseStream, QName featureName, URL describeFeatureTypeRequest) throws DataSourceException {
        this.inputStream = getFeatureResponseStream;
        try {
            String namespaceURI = featureName.getNamespaceURI();
            String schemaLocation = describeFeatureTypeRequest.toExternalForm();
            WFSAppSchemaConfiguration appSchemaConfiguration = new WFSAppSchemaConfiguration(wfsConfiguration, namespaceURI, schemaLocation);
            this.parser = new StreamingParser((Configuration)appSchemaConfiguration, getFeatureResponseStream, featureName);
        }
        catch (ParserConfigurationException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (SAXException e) {
            if (e.getCause() == null && e.getException() != null) {
                e.initCause(e.getException());
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
                this.parser = null;
            }
        }
    }

    public SimpleFeature parse() throws IOException {
        Object parsed = this.parser.parse();
        SimpleFeature feature = (SimpleFeature)parsed;
        return feature;
    }

    public int getNumberOfFeatures() {
        return -1;
    }

    private static class WFSAppSchemaConfiguration
    extends ApplicationSchemaConfiguration {
        public WFSAppSchemaConfiguration(Configuration wfsConfiguration, String namespace, String schemaLocation) {
            super(namespace, schemaLocation);
            this.addDependency(wfsConfiguration);
        }
    }
}

