/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.v1_0_0.FeatureSetDescription;
import org.geotools.data.wfs.v1_0_0.NonStrictWFSStrategy;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.Filters;
import org.geotools.filter.visitor.FixBBOXFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.filter.FilterEncodingPreProcessor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class StrictWFSStrategy
extends NonStrictWFSStrategy {
    protected static final Integer COMPLIANCE_LEVEL = XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MEDIUM;
    private Integer compliance;

    public StrictWFSStrategy(WFS_1_0_0_DataStore store) {
        this(store, null);
    }

    public StrictWFSStrategy(WFS_1_0_0_DataStore store, Integer filterCompliance) {
        super(store);
        this.compliance = filterCompliance;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> wrapWithFilteringFeatureReader(Filter postFilter, FeatureReader<SimpleFeatureType, SimpleFeature> reader, Filter processedFilter) {
        FilterEncodingPreProcessor visitor = new FilterEncodingPreProcessor(COMPLIANCE_LEVEL);
        Filters.accept((Filter)processedFilter, (FilterVisitor)visitor);
        if (visitor.requiresPostProcessing()) {
            return new FilteringFeatureReader(reader, processedFilter);
        }
        return new FilteringFeatureReader(reader, postFilter);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(Transaction transaction, Query query) throws IOException {
        return new StrictFeatureReader(transaction, query, this.compliance == null ? COMPLIANCE_LEVEL : this.compliance);
    }

    @Override
    protected CoordinateReferenceSystem correctFilterForServer(String typeName, Filter serverFilter) {
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.store.capabilities, typeName);
        Envelope maxbbox = null;
        CoordinateReferenceSystem dataCRS = null;
        if (fsd.getSRS() != null) {
            try {
                dataCRS = CRS.decode((String)fsd.getSRS());
                MathTransform toDataCRS = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)dataCRS);
                maxbbox = JTS.transform((Envelope)fsd.getLatLongBoundingBox(), null, (MathTransform)toDataCRS, (int)10);
            }
            catch (FactoryException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
                maxbbox = null;
            }
            catch (MismatchedDimensionException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
                maxbbox = null;
            }
            catch (TransformException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
                maxbbox = null;
            }
        } else {
            maxbbox = fsd.getLatLongBoundingBox();
        }
        if (maxbbox != null) {
            FixBBOXFilterVisitor clipVisitor = new FixBBOXFilterVisitor(ReferencedEnvelope.reference((Envelope)maxbbox));
            serverFilter = (Filter)serverFilter.accept((org.opengis.filter.FilterVisitor)clipVisitor, null);
        } else {
            WFS_1_0_0_DataStore.LOGGER.log(Level.FINE, "Unable to clip your query against the latlongboundingbox element");
        }
        return dataCRS;
    }

    protected class StrictFeatureReader
    implements FeatureReader<SimpleFeatureType, SimpleFeature> {
        private FeatureReader<SimpleFeatureType, SimpleFeature> delegate;
        protected Filter filter;
        private Query query;
        private Transaction transaction;
        private Set<String> foundFids = new HashSet<String>();
        private SimpleFeature next;

        public StrictFeatureReader(Transaction transaction, Query query, Integer level) throws IOException {
            this.init(transaction, query, level);
        }

        protected void init(Transaction transaction, Query query, Integer level) throws IOException {
            FilterEncodingPreProcessor visitor = new FilterEncodingPreProcessor(level);
            Filters.accept((Filter)query.getFilter(), (FilterVisitor)visitor);
            this.transaction = transaction;
            if (visitor.requiresPostProcessing() && query.getPropertyNames() != Query.ALL_NAMES) {
                FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
                query.getFilter().accept((org.opengis.filter.FilterVisitor)attributeExtractor, null);
                HashSet<String> properties = new HashSet<String>(attributeExtractor.getAttributeNameSet());
                properties.addAll(Arrays.asList(query.getPropertyNames()));
                this.query = new Query(query);
                this.query.setPropertyNames(properties.toArray(new String[0]));
            } else {
                this.query = query;
            }
            this.filter = visitor.getFilter();
            Query nonFidQuery = new Query(query);
            FidFilter fidFilter = visitor.getFidFilter();
            nonFidQuery.setFilter((Filter)fidFilter);
            this.delegate = fidFilter.getIDs().size() > 0 ? StrictWFSStrategy.super.createFeatureReader(transaction, nonFidQuery) : this.nextReader();
        }

        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        public SimpleFeatureType getFeatureType() {
            return (SimpleFeatureType)this.delegate.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (this.delegate == null) {
                return false;
            }
            if (!this.delegate.hasNext()) {
                this.delegate.close();
                this.delegate = null;
                this.delegate = this.nextReader();
                if (this.delegate == null) {
                    return false;
                }
            }
            try {
                while (this.next == null) {
                    if (!this.delegate.hasNext()) {
                        return false;
                    }
                    this.next = (SimpleFeature)this.delegate.next();
                    if (!this.foundFids.contains(this.next.getID())) continue;
                    this.next = null;
                }
            }
            catch (IllegalAttributeException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return this.next != null;
        }

        private FeatureReader<SimpleFeatureType, SimpleFeature> nextReader() throws IOException {
            if (this.filter == null || this.filter == Filter.EXCLUDE) {
                return null;
            }
            Query query2 = new Query(this.query);
            query2.setFilter(this.filter);
            FeatureReader nextReader = StrictWFSStrategy.super.createFeatureReader(this.transaction, query2);
            this.filter = null;
            return nextReader;
        }

        public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SimpleFeature tmp = this.next;
            this.foundFids.add(tmp.getID());
            this.next = null;
            return tmp;
        }
    }
}

