/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.ows.OperationType;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.protocol.wfs.Version;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.protocol.ConnectionFactory;
import org.geotools.wfs.protocol.WFSProtocolHandler;
import org.geotools.xml.DocumentFactory;
import org.xml.sax.SAXException;

public class WFS100ProtocolHandler
extends WFSProtocolHandler {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private WFSCapabilities capabilities;

    public WFS100ProtocolHandler(InputStream capabilitiesReader, ConnectionFactory connectionFac) throws IOException {
        super(Version.v1_0_0, connectionFac);
        this.capabilities = this.parseCapabilities(capabilitiesReader);
    }

    public WFSCapabilities getCapabilities() {
        return this.capabilities;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFac;
    }

    protected WFSCapabilities parseCapabilities(InputStream capabilitiesReader) throws IOException {
        Object parsed;
        HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
        hints.put("DocumentFactory_VALIDATION_HINT", Boolean.FALSE);
        try {
            parsed = DocumentFactory.getInstance((InputStream)capabilitiesReader, hints, (Level)LOGGER.getLevel());
        }
        catch (SAXException e) {
            throw new DataSourceException("Error parsing WFS 1.0.0 capabilities", (Throwable)e);
        }
        if (parsed instanceof WFSCapabilities) {
            return (WFSCapabilities)((Object)parsed);
        }
        throw new DataSourceException("The specified URL Should have returned a 'WFSCapabilities' object. Returned a " + (parsed == null ? "null value." : parsed.getClass().getName() + " instance."));
    }

    @Override
    public URL getOperationURL(WFSOperationType operation, HttpMethod method) throws UnsupportedOperationException {
        OperationType operationType;
        switch (operation) {
            case DESCRIBE_FEATURETYPE: {
                operationType = this.capabilities.getDescribeFeatureType();
                break;
            }
            case GET_CAPABILITIES: {
                operationType = this.capabilities.getGetCapabilities();
                break;
            }
            case GET_FEATURE: {
                operationType = this.capabilities.getGetFeature();
                break;
            }
            case GET_FEATURE_WITH_LOCK: {
                operationType = this.capabilities.getGetFeatureWithLock();
                break;
            }
            case LOCK_FEATURE: {
                operationType = this.capabilities.getLockFeature();
                break;
            }
            case TRANSACTION: {
                operationType = this.capabilities.getTransaction();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type " + (Object)((Object)operation));
            }
        }
        if (operationType == null) {
            throw new UnsupportedOperationException((Object)((Object)operation) + " not supported by the server");
        }
        URL url = HttpMethod.GET == method ? operationType.getGet() : operationType.getPost();
        if (url == null) {
            throw new UnsupportedOperationException("Method " + (Object)((Object)method) + " for " + (Object)((Object)operation) + " is not supported by the server");
        }
        return url;
    }

    @Override
    public boolean supports(WFSOperationType operation, HttpMethod method) {
        try {
            this.getOperationURL(operation, method);
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }
}

