/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0.xml;

import com.vividsolutions.jts.geom.Envelope;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.ows.OperationType;
import org.geotools.data.ows.Service;
import org.geotools.data.wfs.v1_0_0.FeatureSetDescription;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.xml.WFSSchema;
import org.geotools.filter.FilterCapabilities;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.filter.FilterComplexTypes;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.schema.impl.SimpleTypeGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class WFSCapabilitiesComplexTypes {

    static class GetFeatureTypeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new GetFeatureTypeType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("ResultFormat", (Type)ResultFormatType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("DCPType", (Type)DCPTypeType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        GetFeatureTypeType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Invalid inputs for parsing a GetCapabilitiesType");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid number of inputs for parsing a GetCapabilitiesType");
            }
            LinkedList<OperationType> l = new LinkedList<OperationType>();
            List sdl = null;
            for (int i = 0; i < value.length; ++i) {
                if (sdl == null && value[i].getElement() != null && elements[0].getName().equals(value[i].getElement().getName())) {
                    sdl = (List)value[i].getValue();
                    continue;
                }
                OperationType t = (OperationType)value[i].getValue();
                l.add(t);
            }
            OperationType[] ot = new OperationType[l.size()];
            for (int i = 0; i < ot.length; ++i) {
                ot[i] = (OperationType)l.get(i);
                ot[i].setFormats(sdl);
            }
            return ot;
        }

        public String getName() {
            return "GetFeatureTypeType";
        }

        public Class getInstanceType() {
            return OperationType[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class TransactionType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new TransactionType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("DCPType", (Type)DCPTypeType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        TransactionType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Invalid inputs for parsing a GetCapabilitiesType");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid number of inputs for parsing a GetCapabilitiesType");
            }
            LinkedList<OperationType> l = new LinkedList<OperationType>();
            for (int i = 0; i < value.length; ++i) {
                OperationType t = (OperationType)value[i].getValue();
                l.add(t);
            }
            return l.toArray(new OperationType[l.size()]);
        }

        public String getName() {
            return "TransactionType";
        }

        public Class getInstanceType() {
            return OperationType[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class DescribeFeatureTypeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new DescribeFeatureTypeType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("SchemaDescriptionLanguage", (Type)SchemaDescriptionLanguageType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("DCPType", (Type)DCPTypeType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        DescribeFeatureTypeType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Invalid inputs for parsing a GetCapabilitiesType");
            }
            if (value.length < 2) {
                throw new SAXException("Invalid number of inputs for parsing a GetCapabilitiesType");
            }
            LinkedList<OperationType> l = new LinkedList<OperationType>();
            List sdl = null;
            for (int i = 0; i < value.length; ++i) {
                if (sdl == null && value[i].getElement() != null && "SchemaDescriptionLanguage".equals(value[i].getElement().getName())) {
                    sdl = (List)value[i].getValue();
                    continue;
                }
                OperationType t = (OperationType)value[i].getValue();
                l.add(t);
            }
            OperationType[] ot = new OperationType[l.size()];
            for (int i = 0; i < ot.length; ++i) {
                ot[i] = (OperationType)l.get(i);
                ot[i].setFormats(sdl);
            }
            return ot;
        }

        public String getName() {
            return "DescribeFeatureTypeType";
        }

        public Class getInstanceType() {
            return OperationType[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class GetCapabilitiesType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new GetCapabilitiesType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("DCPType", (Type)DCPTypeType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        GetCapabilitiesType() {
        }

        static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Invalid inputs for parsing a GetCapabilitiesType");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid number of inputs for parsing a GetCapabilitiesType");
            }
            LinkedList<OperationType> l = new LinkedList<OperationType>();
            for (int i = 0; i < value.length; ++i) {
                OperationType t = (OperationType)value[i].getValue();
                l.add(t);
            }
            return l.toArray(new OperationType[l.size()]);
        }

        public String getName() {
            return "GetCapabilitiesType";
        }

        public Class getInstanceType() {
            return OperationType[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class WFS_CapabilitiesType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new WFS_CapabilitiesType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Service", (Type)ServiceType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Capability", (Type)CapabilityType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("FeatureTypeList", (Type)FeatureTypeListType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Filter_Capabilities", (Type)FilterComplexTypes.Filter_CapabilitiesType.getInstance(), 1, 1, false, null){

            @Override
            public URI getNamespace() {
                return FilterSchema.NAMESPACE;
            }
        }};
        private static final Attribute[] attributes = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2, "1.0.0"), new WFSSchema.WFSAttribute("updateSequence", XSISimpleTypes.NonNegativeInteger.getInstance(), 2, "0")};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        WFS_CapabilitiesType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public String getName() {
            return "WFS_CapabilitiesType";
        }

        public Class getInstanceType() {
            return WFSCapabilities.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            Boolean t;
            if (element != null && element.getType() != this) {
                if (!(element.getType() instanceof ComplexType)) {
                    ComplexType t2 = (ComplexType)element.getType();
                    while (t2 != null && t2 != this) {
                        t2 = t2.getParent() instanceof ComplexType ? (ComplexType)t2.getParent() : null;
                    }
                    if (t2 == null) {
                        throw new SAXNotSupportedException("The specified element was not a declared as a WFS_Capabilities element, or derived element");
                    }
                } else {
                    throw new SAXNotSupportedException("The specified element was not a declared as a WFS_Capabilities element, or derived element");
                }
            }
            boolean validation = true;
            if (hints != null && hints.containsKey("DocumentFactory_VALIDATION_HINT") && (t = (Boolean)hints.get("DocumentFactory_VALIDATION_HINT")) != null) {
                validation = t;
            }
            if (validation && (value == null || value.length != 4)) {
                throw new SAXException("The WFS Capabilites document has the wrong number of children");
            }
            WFSCapabilities result = new WFSCapabilities();
            for (int i = 0; i < 4 && i < value.length; ++i) {
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    result.setService((Service)value[i].getValue());
                    continue;
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    Object[] temp = (Object[])value[i].getValue();
                    if (temp.length != 2) {
                        throw new SAXException("The WFS Capabilites document has an invalid capability child");
                    }
                    result.setVendorSpecificCapabilities((String)temp[0]);
                    OperationType[] tmp = (OperationType[])temp[1];
                    if (tmp == null) continue;
                    result.setGetCapabilities(tmp[0]);
                    result.setDescribeFeatureType(tmp[1]);
                    result.setTransaction(tmp[2]);
                    result.setGetFeature(tmp[3]);
                    result.setGetFeatureWithLock(tmp[4]);
                    result.setLockFeature(tmp[5]);
                    continue;
                }
                if (elements[2].getName().equals(value[i].getElement().getName())) {
                    result.setFeatureTypes((List)value[i].getValue());
                    continue;
                }
                if (elements[3].getName().equals(value[i].getElement().getName())) {
                    result.setFilterCapabilities((FilterCapabilities)value[i].getValue());
                    continue;
                }
                if (!validation) continue;
                throw new SAXException("The element " + (value[i].getElement() == null ? "null" : value[i].getElement().getName()) + " was not found as a valid element ...");
            }
            return result;
        }
    }

    static class CapabilityType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new CapabilityType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Request", (Type)RequestType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("VendorSpecificCapabilities", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        CapabilityType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Element findChildElement(String name) {
            if (name == null) {
                return null;
            }
            return seq.findChildElement(name);
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Class getInstanceType() {
            return Object[].class;
        }

        public String getName() {
            return "CapabilityType";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            Element e = value[0].getElement();
            if (e == null) {
                throw new SAXException("Internal error, ElementValues require an associated Element.");
            }
            Object[] capab = new Object[2];
            for (int i = 0; i < value.length; ++i) {
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    capab[1] = (OperationType[])value[i].getValue();
                }
                if (!elements[1].getName().equals(value[i].getElement().getName())) continue;
                capab[0] = (String)value[i].getValue();
            }
            if (capab[1] == null) {
                throw new SAXException("Required Capability Element is missing, check for the existence of the Request Element.");
            }
            return capab;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class FeatureTypeListType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new FeatureTypeListType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Operations", (Type)OperationsType.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("FeatureType", (Type)FeatureTypeType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        FeatureTypeListType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("A parameter for FeatureTypeList is missing");
            }
            if (value.length < 1) {
                throw new SAXException("Missing a child element");
            }
            int operations = 0;
            LinkedList<Object> fts = new LinkedList<Object>();
            for (int i = 0; i < value.length; ++i) {
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    operations |= ((Integer)value[i].getValue()).intValue();
                    continue;
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    fts.add(value[i].getValue());
                    continue;
                }
                throw new SAXException("An error occured here");
            }
            return fts;
        }

        public String getName() {
            return "FeatureTypeListType";
        }

        public Class getInstanceType() {
            return FeatureSetDescription[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class ServiceType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new ServiceType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Name", (Type)XSISimpleTypes.String.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Title", (Type)XSISimpleTypes.String.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Abstract", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("Keywords", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("OnlineResource", (Type)XSISimpleTypes.AnyURI.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Fees", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("AccessConstraints", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        ServiceType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Class getInstanceType() {
            return Service.class;
        }

        public String getName() {
            return "ServiceType";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            Element e = value[0].getElement();
            if (e == null) {
                throw new SAXException("Internal error, ElementValues require an associated Element.");
            }
            Service service = new Service();
            for (int i = 0; i < value.length; ++i) {
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    service.setName((String)value[i].getValue());
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    service.setTitle((String)value[i].getValue());
                }
                if (elements[2].getName().equals(value[i].getElement().getName())) {
                    service.set_abstract((String)value[i].getValue());
                }
                if (elements[3].getName().equals(value[i].getElement().getName())) {
                    service.setKeywordList(((String)value[i].getValue()).split(" "));
                }
                if (!elements[4].getName().equals(value[i].getElement().getName())) continue;
                try {
                    service.setOnlineResource(((URI)value[i].getValue()).toURL());
                    continue;
                }
                catch (MalformedURLException e1) {
                    throw new SAXException(e1);
                }
            }
            if (service.getName() == null || service.getTitle() == null || service.getOnlineResource() == null) {
                throw new SAXException("Required Service Elements are missing, check for the existence of Name, Title , or OnlineResource elements.");
            }
            return service;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class RequestType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new RequestType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("GetCapabilities", (Type)GetCapabilitiesType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("DescribeFeatureType", (Type)DescribeFeatureTypeType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Transaction", (Type)TransactionType.getInstance(), 1, Integer.MAX_VALUE, false, null), new WFSSchema.WFSElement("GetFeature", (Type)GetFeatureTypeType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("GetFeatureWithLock", (Type)GetFeatureTypeType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("LockFeature", (Type)LockFeatureTypeType.getInstance(), 1, 1, false, null)};
        private static final ChoiceGT seq = new ChoiceGT((ElementGrouping[])elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        RequestType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null) {
                throw new SAXException("Element cannot be null -- we should know what we are parsing");
            }
            if (value == null || value.length == 0) {
                throw new SAXException("We need atleast one value to parse a wfs:RequestType");
            }
            OperationType[] result = new OperationType[6];
            for (int i = 0; i < value.length; ++i) {
                List st;
                int j;
                OperationType[] t = (OperationType[])value[i].getValue();
                if (t == null) continue;
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    if (result[0] == null) {
                        result[0] = new OperationType();
                    }
                    for (j = 0; j < t.length; ++j) {
                        if (result[0].getGet() == null && t[j].getGet() != null) {
                            result[0].setGet(t[j].getGet());
                        }
                        if (result[0].getPost() != null || t[j].getPost() == null) continue;
                        result[0].setPost(t[j].getPost());
                    }
                    continue;
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    if (result[1] == null) {
                        result[1] = new OperationType();
                    }
                    for (j = 0; j < t.length; ++j) {
                        if (result[1].getGet() == null && t[j].getGet() != null) {
                            result[1].setGet(t[j].getGet());
                        }
                        if (result[1].getPost() == null && t[j].getPost() != null) {
                            result[1].setPost(t[j].getPost());
                        }
                        if (t[j].getFormats() == null) continue;
                        if (result[1].getFormats() == null) {
                            result[1].setFormats(t[j].getFormats());
                            continue;
                        }
                        st = result[0].getFormats();
                        if (t[j].getFormats() == null) {
                            t[j].setFormats(st);
                            continue;
                        }
                        if (st == null) continue;
                        t[j].getFormats().addAll(st);
                    }
                    continue;
                }
                if (elements[2].getName().equals(value[i].getElement().getName())) {
                    if (result[2] == null) {
                        result[2] = new OperationType();
                    }
                    for (j = 0; j < t.length; ++j) {
                        if (result[2].getGet() == null && t[j].getGet() != null) {
                            result[2].setGet(t[j].getGet());
                        }
                        if (result[2].getPost() != null || t[j].getPost() == null) continue;
                        result[2].setPost(t[j].getPost());
                    }
                    continue;
                }
                if (elements[3].getName().equals(value[i].getElement().getName())) {
                    if (result[3] == null) {
                        result[3] = new OperationType();
                    }
                    for (j = 0; j < t.length; ++j) {
                        if (result[3].getGet() == null && t[j].getGet() != null) {
                            result[3].setGet(t[j].getGet());
                        }
                        if (result[3].getPost() == null && t[j].getPost() != null) {
                            result[3].setPost(t[j].getPost());
                        }
                        if (t[j].getFormats() == null) continue;
                        if (result[3].getFormats() == null) {
                            result[3].setFormats(t[j].getFormats());
                            continue;
                        }
                        st = result[0].getFormats();
                        if (t[j].getFormats() == null) {
                            t[j].setFormats(st);
                            continue;
                        }
                        if (st == null) continue;
                        t[j].getFormats().addAll(st);
                    }
                    continue;
                }
                if (elements[4].getName().equals(value[i].getElement().getName())) {
                    if (result[4] == null) {
                        result[4] = new OperationType();
                    }
                    for (j = 0; j < t.length; ++j) {
                        if (result[4].getGet() == null && t[j].getGet() != null) {
                            result[4].setGet(t[j].getGet());
                        }
                        if (result[4].getPost() == null && t[j].getPost() != null) {
                            result[4].setPost(t[j].getPost());
                        }
                        if (t[j].getFormats() == null) continue;
                        if (result[4].getFormats() == null) {
                            result[4].setFormats(t[j].getFormats());
                            continue;
                        }
                        st = result[0].getFormats();
                        if (t[j].getFormats() == null) {
                            t[j].setFormats(st);
                            continue;
                        }
                        if (st == null) continue;
                        t[j].getFormats().addAll(st);
                    }
                    continue;
                }
                if (elements[5].getName().equals(value[i].getElement().getName())) {
                    if (result[5] == null) {
                        result[5] = new OperationType();
                    }
                    for (j = 0; j < t.length; ++j) {
                        if (result[5].getGet() == null && t[j].getGet() != null) {
                            result[5].setGet(t[j].getGet());
                        }
                        if (result[5].getPost() != null || t[j].getPost() == null) continue;
                        result[5].setPost(t[j].getPost());
                    }
                    continue;
                }
                throw new SAXException("Unknown child element " + value[i].getElement().getName() + " found in RequestType");
            }
            return result;
        }

        public String getName() {
            return "RequestType";
        }

        public Class getInstanceType() {
            return OperationType[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class LockFeatureTypeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new LockFeatureTypeType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("DCPType", (Type)DCPTypeType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        LockFeatureTypeType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Invalid inputs for parsing a GetCapabilitiesType");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid number of inputs for parsing a GetCapabilitiesType");
            }
            OperationType[] c = new OperationType[value.length];
            for (int i = 0; i < value.length; ++i) {
                c[i] = (OperationType)value[i].getValue();
            }
            return c;
        }

        public String getName() {
            return "LockFeatureTypeType";
        }

        public Class getInstanceType() {
            return OperationType[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class DCPTypeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new DCPTypeType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("HTTP", (Type)HTTPType.getInstance(), 1, 1, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        DCPTypeType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public String getName() {
            return "DCPTypeType";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            Element e = value[0].getElement();
            if (e == null || value == null) {
                throw new SAXException("Internal error, ElementValues require an associated Element.");
            }
            if (value.length != 1) {
                throw new SAXException("Wrong number of elements for DCPType");
            }
            return (OperationType)value[0].getValue();
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Class getInstanceType() {
            return OperationType.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class FeatureTypeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new FeatureTypeType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Name", (Type)XSISimpleTypes.QName.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Title", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("Abstract", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("Keywords", (Type)XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("SRS", (Type)XSISimpleTypes.String.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Operations", (Type)OperationsType.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("LatLongBoundingBox", (Type)LatLongBoundingBoxType.getInstance(), 0, Integer.MAX_VALUE, false, null), new WFSSchema.WFSElement("MetadataURL", (Type)MetadataURLType.getInstance(), 0, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements);

        FeatureTypeType() {
        }

        public String getName() {
            return "FeatureTypeType";
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            Boolean t;
            if (element == null || value == null) {
                throw new SAXException("Missing params for FeatureTypeType");
            }
            boolean validation = true;
            if (hints != null && hints.containsKey("DocumentFactory_VALIDATION_HINT") && (t = (Boolean)hints.get("DocumentFactory_VALIDATION_HINT")) != null) {
                validation = t;
            }
            if (validation && value.length < 2) {
                throw new SAXException("Missing child element for FeatureTypeType");
            }
            FeatureSetDescription fsd = new FeatureSetDescription();
            LinkedList<Object> llbb = new LinkedList<Object>();
            for (int i = 0; i < value.length; ++i) {
                if (value[i].getElement() == null) {
                    throw new SAXException("Internal error -- a value object representing a child element was missing an element declaration");
                }
                if (elements[0].getName().equals(value[i].getElement().getName())) {
                    int j;
                    fsd.setName((String)value[i].getValue());
                    if (fsd.getName() == null || (j = fsd.getName().indexOf(":")) <= 0) continue;
                    String prefix = fsd.getName().substring(0, j);
                    continue;
                }
                if (elements[1].getName().equals(value[i].getElement().getName())) {
                    fsd.setTitle((String)value[i].getValue());
                    continue;
                }
                if (elements[2].getName().equals(value[i].getElement().getName())) {
                    String t2 = (String)value[i].getValue();
                    t2 = "NONE".equals(t2) ? "" : t2;
                    fsd.setAbstract(t2);
                    continue;
                }
                if (elements[3].getName().equals(value[i].getElement().getName())) {
                    String t3 = (String)value[i].getValue();
                    t3 = t3 == null ? "" : t3;
                    fsd.setKeywords(Arrays.asList(t3.split(" ")));
                    continue;
                }
                if (elements[4].getName().equals(value[i].getElement().getName())) {
                    fsd.setSRS((String)value[i].getValue());
                    continue;
                }
                if (elements[5].getName().equals(value[i].getElement().getName())) {
                    fsd.setOperations((Integer)value[i].getValue());
                    continue;
                }
                if (elements[6].getName().equals(value[i].getElement().getName())) {
                    llbb.add(value[i].getValue());
                    continue;
                }
                if (elements[7].getName().equals(value[i].getElement().getName())) continue;
                throw new SAXException("Unknown child element within a FeatureTypeType: " + (value[i].getElement().getName() == null ? "null" : value[i].getElement().getName()));
            }
            if (llbb.size() > 0) {
                Envelope e = (Envelope)llbb.get(0);
                for (int i = 1; i < llbb.size(); ++i) {
                    e.expandToInclude((Envelope)llbb.get(i));
                }
                fsd.setLatLongBoundingBox(e);
            }
            if (fsd.getName() == null || fsd.getSRS() == null) {
                throw new SAXException("Missing child element for FeatureTypeType");
            }
            return fsd;
        }

        public Class getInstanceType() {
            return FeatureSetDescription.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class GetType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new GetType();
        private static Attribute[] attributes = new Attribute[]{new WFSSchema.WFSAttribute("onlineResource", XSISimpleTypes.String.getInstance(), 2)};

        GetType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            String s = attrs.getValue("", "onlineResource");
            if (s == null || "".equals(s)) {
                s = attrs.getValue(WFSSchema.NAMESPACE.toString(), "onlineResource");
            }
            try {
                return new URL(s);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public String getName() {
            return "GetType";
        }

        public Class getInstanceType() {
            return URL.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class HTTPType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new HTTPType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Get", (Type)GetType.getInstance(), 0, Integer.MAX_VALUE, false, null), new WFSSchema.WFSElement("Post", (Type)PostType.getInstance(), 0, Integer.MAX_VALUE, false, null)};
        private static final ChoiceGT seq = new ChoiceGT((ElementGrouping[])elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        HTTPType() {
        }

        public String getName() {
            return "HTTPType";
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Error occured in HTTPType: both an element and value param is required");
            }
            if (value.length < 1) {
                throw new SAXException("Must have atleast one http type defined.");
            }
            OperationType c = new OperationType();
            for (int i = 0; i < value.length; ++i) {
                if (value[i].getElement() != null && value[i].getElement().getName().equals(elements[0].getName())) {
                    c.setGet((URL)value[i].getValue());
                }
                if (value[i].getElement() == null || !value[i].getElement().getName().equals(elements[1].getName())) continue;
                c.setPost((URL)value[i].getValue());
            }
            return c;
        }

        public Class getInstanceType() {
            return OperationType.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class PostType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new PostType();
        private static Attribute[] attributes = new Attribute[]{new WFSSchema.WFSAttribute("onlineResource", XSISimpleTypes.String.getInstance(), 2)};

        PostType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            String s = attrs.getValue("", "onlineResource");
            if (s == null || "".equals(s)) {
                s = attrs.getValue(WFSSchema.NAMESPACE.toString(), "onlineResource");
            }
            try {
                return new URL(s);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        public String getName() {
            return "PostType";
        }

        public Class getInstanceType() {
            return URL.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class LatLongBoundingBoxType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new LatLongBoundingBoxType();
        private static Attribute[] attributes = new Attribute[]{new WFSSchema.WFSAttribute("minx", XSISimpleTypes.String.getInstance(), 2), new WFSSchema.WFSAttribute("miny", XSISimpleTypes.String.getInstance(), 2), new WFSSchema.WFSAttribute("maxx", XSISimpleTypes.String.getInstance(), 2), new WFSSchema.WFSAttribute("maxy", XSISimpleTypes.String.getInstance(), 2)};

        LatLongBoundingBoxType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            double maxy = 0.0;
            double maxx = 0.0;
            double miny = 0.0;
            double minx = 0.0;
            if (element == null || attrs == null) {
                throw new SAXException("Invalid parameters for LatLongBoundingBoxType");
            }
            String t = "";
            t = attrs.getValue("", "minx");
            if (t == null || "".equals(t)) {
                t = attrs.getValue(WFSSchema.NAMESPACE.toString(), "minx");
            }
            minx = Double.parseDouble(t);
            t = attrs.getValue("", "maxx");
            if (t == null || "".equals(t)) {
                t = attrs.getValue(WFSSchema.NAMESPACE.toString(), "maxx");
            }
            maxx = Double.parseDouble(t);
            t = attrs.getValue("", "miny");
            if (t == null || "".equals(t)) {
                t = attrs.getValue(WFSSchema.NAMESPACE.toString(), "miny");
            }
            miny = Double.parseDouble(t);
            t = attrs.getValue("", "maxy");
            if (t == null || "".equals(t)) {
                t = attrs.getValue(WFSSchema.NAMESPACE.toString(), "maxy");
            }
            maxy = Double.parseDouble(t);
            return new Envelope(minx, maxx, miny, maxy);
        }

        public String getName() {
            return "LatLonBoundingBoxType";
        }

        public Class getInstanceType() {
            return Envelope.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class MetadataURLType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new MetadataURLType();
        private static Attribute[] attributes = new Attribute[]{new WFSSchema.WFSAttribute("type", (SimpleType)new SimpleTypeGT(null, null, WFSSchema.NAMESPACE, 4, new SimpleType[]{XSISimpleTypes.NMTOKEN.getInstance()}, new Facet[]{new FacetGT(1, "TC211"), new FacetGT(1, "FGDC")}, 0), 2), new WFSSchema.WFSAttribute("format", (SimpleType)new SimpleTypeGT(null, null, WFSSchema.NAMESPACE, 4, new SimpleType[]{XSISimpleTypes.NMTOKEN.getInstance()}, new Facet[]{new FacetGT(1, "XML"), new FacetGT(1, "SGML"), new FacetGT(1, "TXT")}, 0), 2)};

        MetadataURLType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("Invalid parameters passed into MetadataURL");
            }
            if (value.length != 1) {
                throw new SAXException("Should only have one child value -- the String value of inline text");
            }
            return null;
        }

        public String getName() {
            return "MetadataURLType";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    static class OperationsType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new OperationsType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("Insert", (Type)EmptyType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Update", (Type)EmptyType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Delete", (Type)EmptyType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Query", (Type)EmptyType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("Lock", (Type)EmptyType.getInstance(), 1, 1, false, null)};
        private static final ChoiceGT seq = new ChoiceGT((ElementGrouping[])elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        OperationsType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("missing inputs");
            }
            if (value.length < 1) {
                throw new SAXException("Too few children");
            }
            int t = 0;
            for (int i = 0; i < value.length; ++i) {
                t |= FeatureSetDescription.findOperation(value[i].getElement().getName());
            }
            return new Integer(t);
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public Class getInstanceType() {
            return null;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException("Method not completed yet.");
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public String getName() {
            return "OperationsType";
        }

        public Element[] getChildElements() {
            return elements;
        }
    }

    static class ResultFormatType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new ResultFormatType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("GML2", (Type)EmptyType.getInstance(), 1, 1, false, null), new WFSSchema.WFSElement("GML2-GZIP", (Type)EmptyType.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("GML2-ZIP", (Type)EmptyType.getInstance(), 0, 1, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        ResultFormatType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            Boolean t;
            if (element == null || value == null) {
                throw new SAXException("Invalid inputs for parsing a GetCapabilitiesType");
            }
            boolean validation = true;
            if (hints != null && hints.containsKey("DocumentFactory_VALIDATION_HINT") && (t = (Boolean)hints.get("DocumentFactory_VALIDATION_HINT")) != null) {
                validation = t;
            }
            if (validation && value.length < 1) {
                throw new SAXException("Invalid number of inputs for parsing a GetCapabilitiesType");
            }
            LinkedList<String> l = new LinkedList<String>();
            for (int i = 0; i < value.length; ++i) {
                if (value[i].getElement().getName() == null) continue;
                l.add(value[i].getElement().getName());
            }
            return l;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public Class getInstanceType() {
            return List.class;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException("Method not completed yet.");
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public String getName() {
            return "ResultFormatType";
        }

        public Element[] getChildElements() {
            return elements;
        }
    }

    static class EmptyType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new EmptyType();

        EmptyType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public Class getInstanceType() {
            return null;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException("Method not completed yet.");
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public String getName() {
            return "EmptyType";
        }
    }

    static class SchemaDescriptionLanguageType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new SchemaDescriptionLanguageType();
        private static final Element[] elements = new Element[]{new WFSSchema.WFSElement("XMLSCHEMA", (Type)EmptyType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static final SequenceGT seq = new SequenceGT((ElementGrouping[])elements){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        };

        SchemaDescriptionLanguageType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Class getInstanceType() {
            return null;
        }

        public String getName() {
            return "SchemaDescriptionLanguageType";
        }

        public Element[] getChildElements() {
            return elements;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null) {
                throw new SAXException("SchemaDescriptionLanguage had an erro while parsing -- missing input");
            }
            if (value.length < 1) {
                throw new SAXException("too few child elements for SchemaDescriptionLanguage");
            }
            boolean found = false;
            LinkedList<String> results = new LinkedList<String>();
            for (int i = 0; i < value.length; ++i) {
                if (value[i].getElement() == null) continue;
                if ("XMLSCHEMA".equals(value[i].getElement().getName())) {
                    found = true;
                }
                if (value[i].getElement().getName() == null) continue;
                results.add(value[i].getElement().getName());
            }
            if (!found) {
                throw new SAXException("XMLSCHEMA is a required child element, which was not found");
            }
            return results.size() == 0 ? null : results;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException("Method not completed yet.");
        }
    }
}

