/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.AbstractPathElement;
import org.jgrapht.alg.AbstractPathElementList;
import org.jgrapht.alg.RankingPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RankingPathElementList<V, E>
extends AbstractPathElementList<V, E, RankingPathElement<V, E>> {
    RankingPathElementList(Graph<V, E> graph, int n, RankingPathElement<V, E> rankingPathElement) {
        super(graph, n, rankingPathElement);
    }

    RankingPathElementList(Graph<V, E> graph, int n, RankingPathElementList<V, E> rankingPathElementList, E e) {
        super(graph, n, rankingPathElementList, e);
        for (int i = 0; i < rankingPathElementList.size(); ++i) {
            RankingPathElement rankingPathElement = (RankingPathElement)rankingPathElementList.get(i);
            if (this.pathElements.size() > this.maxSize - 1) continue;
            double d = this.calculatePathWeight(rankingPathElement, e);
            RankingPathElement rankingPathElement2 = new RankingPathElement(this.graph, rankingPathElement, e, d);
            this.pathElements.add(rankingPathElement2);
        }
        assert (!this.pathElements.isEmpty());
    }

    protected RankingPathElementList(RankingPathElementList<V, E> rankingPathElementList) {
        super(rankingPathElementList);
    }

    public boolean addPathElements(RankingPathElementList<V, E> rankingPathElementList, E e) {
        assert (this.vertex.equals(Graphs.getOppositeVertex(this.graph, e, rankingPathElementList.getVertex())));
        boolean bl = false;
        int n = 0;
        block0: for (int i = 0; i < rankingPathElementList.size(); ++i) {
            RankingPathElement rankingPathElement = (RankingPathElement)rankingPathElementList.get(i);
            if (this.isAlreadyImprovedByThisEdge(e, rankingPathElement) || this.containsTargetPreviously(rankingPathElement)) continue;
            double d = this.calculatePathWeight(rankingPathElement, e);
            while (n < this.size()) {
                RankingPathElement rankingPathElement2 = (RankingPathElement)this.get(n);
                RankingPathElement rankingPathElement3 = new RankingPathElement(this.graph, rankingPathElement, e, d);
                if (d < rankingPathElement2.getWeight()) {
                    this.pathElements.add(n, rankingPathElement3);
                    if (this.size() > this.maxSize) {
                        this.pathElements.remove(this.maxSize);
                    }
                    bl = true;
                    continue block0;
                }
                if (d == rankingPathElement2.getWeight()) {
                    if (this.isAlreadyAdded(rankingPathElement3)) continue block0;
                    if (this.size() <= this.maxSize - 1) {
                        this.pathElements.add(n + 1, rankingPathElement3);
                        if (this.size() > this.maxSize) {
                            this.pathElements.remove(this.maxSize);
                        }
                        bl = true;
                        continue block0;
                    }
                }
                if (d > rankingPathElement2.getWeight() && n == this.size() - 1 && this.size() <= this.maxSize - 1) {
                    this.pathElements.add(rankingPathElement3);
                    bl = true;
                    continue block0;
                }
                ++n;
            }
        }
        return bl;
    }

    List<RankingPathElement<V, E>> getPathElements() {
        return this.pathElements;
    }

    private double calculatePathWeight(RankingPathElement<V, E> rankingPathElement, E e) {
        double d = this.graph.getEdgeWeight(e);
        if (rankingPathElement.getPrevEdge() != null) {
            d += rankingPathElement.getWeight();
        }
        return d;
    }

    private boolean containsTargetPreviously(RankingPathElement<V, E> rankingPathElement) {
        AbstractPathElement abstractPathElement = rankingPathElement;
        while (abstractPathElement.getPrevEdge() != null) {
            if (abstractPathElement.getVertex() == this.vertex) {
                return true;
            }
            abstractPathElement = abstractPathElement.getPrevPathElement();
        }
        return false;
    }

    private boolean isAlreadyAdded(RankingPathElement<V, E> rankingPathElement) {
        for (int i = 0; i <= this.size() - 1; ++i) {
            RankingPathElement<V, E> rankingPathElement2;
            RankingPathElement rankingPathElement3 = (RankingPathElement)this.get(i);
            if (this.isDifferent(rankingPathElement3, rankingPathElement2 = rankingPathElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadyImprovedByThisEdge(E e, RankingPathElement<V, E> rankingPathElement) {
        AbstractPathElement abstractPathElement = rankingPathElement;
        while (abstractPathElement.getPrevEdge() != null) {
            if (abstractPathElement.getPrevEdge() == e) {
                return true;
            }
            abstractPathElement = abstractPathElement.getPrevPathElement();
        }
        return false;
    }

    private boolean isDifferent(RankingPathElement<V, E> abstractPathElement, RankingPathElement<V, E> abstractPathElement2) {
        while (abstractPathElement.getPrevEdge() != null || abstractPathElement2.getPrevEdge() != null) {
            if (abstractPathElement.getPrevEdge() != abstractPathElement2.getPrevEdge()) {
                return true;
            }
            abstractPathElement = abstractPathElement.getPrevPathElement();
            abstractPathElement2 = abstractPathElement2.getPrevPathElement();
        }
        return false;
    }
}

