/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.expressivity;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ProfileBasedExpressivityChecker;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class DLExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private static Set<ATermAppl> TOP_SET = SetUtils.singleton(ATermUtils.TOP);
    private Visitor m_Visitor = new Visitor();
    private Expressivity m_Expressivity;

    public DLExpressivityChecker(KnowledgeBase kb) {
        super(kb);
    }

    public boolean compute(Expressivity expressivity) {
        this.m_Expressivity = expressivity;
        this.processIndividuals();
        this.processClasses();
        this.processRoles();
        return true;
    }

    public boolean updateWith(Expressivity expressivity, ATermAppl term) {
        this.m_Expressivity = expressivity;
        this.m_Visitor.visit(term);
        return true;
    }

    private void processIndividuals() {
        if (!this.m_KB.getABox().isEmpty()) {
            this.m_Expressivity.setHasIndividual(true);
        }
        IndividualIterator i = this.m_KB.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            ATermAppl nominal = ATermUtils.makeValue((ATerm)ind.getName());
            for (ATermAppl term : ind.getTypes()) {
                if (term.equals(nominal)) continue;
                this.m_Visitor.visit(term);
            }
        }
    }

    private void processClasses() {
        TBox tbox = this.m_KB.getTBox();
        for (ATermAppl c : this.m_KB.getAllClasses()) {
            Iterator<Unfolding> unfoldC = tbox.unfold(c);
            while (unfoldC.hasNext()) {
                Unfolding unf = unfoldC.next();
                this.m_Visitor.visit(unf.getResult());
            }
        }
    }

    private void processRoles() {
        for (Role r : this.m_KB.getRBox().getRoles()) {
            Set<ATermAppl> ranges;
            Set<ATermAppl> domains;
            if (r.isBuiltin()) continue;
            if (r.isDatatypeRole()) {
                this.m_Expressivity.setHasDatatype(true);
                if (r.isInverseFunctional()) {
                    this.m_Expressivity.setHasKeys(true);
                }
            }
            if (r.isAnon()) {
                for (Role subRole : r.getSubRoles()) {
                    if (subRole.isAnon() || subRole.isBottom()) continue;
                    this.m_Expressivity.setHasInverse(true);
                }
            }
            if (r.isAnon() && r.isFunctional()) {
                this.m_Expressivity.setHasInverse(true);
            }
            if (r.isFunctional()) {
                if (r.isDatatypeRole()) {
                    this.m_Expressivity.setHasFunctionalityD(true);
                } else if (r.isObjectRole()) {
                    this.m_Expressivity.setHasFunctionality(true);
                }
            }
            if (r.isTransitive()) {
                this.m_Expressivity.setHasTransitivity(true);
            }
            if (r.isReflexive()) {
                this.m_Expressivity.setHasReflexivity(true);
            }
            if (r.isIrreflexive()) {
                this.m_Expressivity.setHasIrreflexivity(true);
            }
            if (r.isAsymmetric()) {
                this.m_Expressivity.setHasAsymmetry(true);
            }
            if (!r.getDisjointRoles().isEmpty()) {
                this.m_Expressivity.setHasDisjointRoles(true);
            }
            if (r.hasComplexSubRole()) {
                this.m_Expressivity.setHasComplexSubRoles(true);
            }
            if (r.getSubRoles().size() > 1) {
                this.m_Expressivity.setHasRoleHierarchy(true);
            }
            if (!(domains = r.getDomains()).isEmpty() && !((Object)domains).equals(TOP_SET)) {
                this.m_Expressivity.setHasDomain(true);
                for (ATermAppl domain : domains) {
                    this.m_Visitor.visit(domain);
                }
            }
            if ((ranges = r.getRanges()).isEmpty() || ((Object)ranges).equals(TOP_SET)) continue;
            this.m_Expressivity.setHasRange(true);
            for (ATermAppl range : ranges) {
                this.m_Visitor.visit(range);
            }
        }
    }

    class Visitor
    extends ATermBaseVisitor {
        Visitor() {
        }

        public void visitTerm(ATermAppl term) {
        }

        void visitRole(ATermAppl p) {
            if (!ATermUtils.isPrimitive(p)) {
                DLExpressivityChecker.this.m_Expressivity.setHasInverse(true);
                DLExpressivityChecker.this.m_Expressivity.addAnonInverse((ATermAppl)p.getArgument(0));
            }
        }

        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitOr(ATermAppl term) {
            DLExpressivityChecker.this.m_Expressivity.setHasNegation(true);
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitNot(ATermAppl term) {
            DLExpressivityChecker.this.m_Expressivity.setHasNegation(true);
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitSome(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitAll(ATermAppl term) {
            DLExpressivityChecker.this.m_Expressivity.setHasAllValues(true);
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitCard(ATermAppl term) {
            this.visitMin(term);
            this.visitMax(term);
        }

        public void visitMin(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            Role role = DLExpressivityChecker.this.m_KB.getRole(term.getArgument(0));
            ATermAppl c = (ATermAppl)term.getArgument(2);
            if (!ATermUtils.isTop(c)) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityQ(true);
                }
            } else if (role.isDatatypeRole()) {
                DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
            } else {
                DLExpressivityChecker.this.m_Expressivity.setHasCardinality(true);
            }
        }

        public void visitMax(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            Role role = DLExpressivityChecker.this.m_KB.getRole(term.getArgument(0));
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            ATermAppl c = (ATermAppl)term.getArgument(2);
            if (!ATermUtils.isTop(c)) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityQ(true);
                }
            } else if (cardinality > 1) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinality(true);
                }
            }
        }

        public void visitHasValue(ATermAppl term) {
            this.visitRole((ATermAppl)term.getArgument(0));
            this.visitValue((ATermAppl)term.getArgument(1));
        }

        public void visitValue(ATermAppl term) {
            ATermAppl nom = (ATermAppl)term.getArgument(0);
            if (!ATermUtils.isLiteral(nom)) {
                DLExpressivityChecker.this.m_Expressivity.addNominal(nom);
            } else {
                DLExpressivityChecker.this.m_Expressivity.setHasUserDefinedDatatype(true);
            }
        }

        public void visitOneOf(ATermAppl term) {
            DLExpressivityChecker.this.m_Expressivity.setHasNegation(true);
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitSelf(ATermAppl term) {
            DLExpressivityChecker.this.m_Expressivity.setHasReflexivity(true);
            DLExpressivityChecker.this.m_Expressivity.setHasIrreflexivity(true);
        }

        public void visitSubClass(ATermAppl term) {
            throw new InternalReasonerException("This function should never be called: " + term);
        }

        public void visitInverse(ATermAppl p) {
            DLExpressivityChecker.this.m_Expressivity.setHasInverse(true);
        }

        public void visitRestrictedDatatype(ATermAppl dt) {
            DLExpressivityChecker.this.m_Expressivity.setHasDatatype(true);
            DLExpressivityChecker.this.m_Expressivity.setHasUserDefinedDatatype(true);
        }
    }
}

