/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.BranchEffectTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBranchEffectTracker
implements BranchEffectTracker {
    private ArrayList<Set<ATermAppl>> effects;

    public SimpleBranchEffectTracker() {
        this.effects = new ArrayList();
    }

    private SimpleBranchEffectTracker(SimpleBranchEffectTracker other) {
        int n = other.effects.size();
        this.effects = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Set<ATermAppl> s = other.effects.get(i);
            this.effects.add((Set<ATermAppl>)(s == null ? null : new HashSet<ATermAppl>(s)));
        }
    }

    @Override
    public boolean add(int branch, ATermAppl a) {
        Set<ATermAppl> existing;
        if (branch <= 0) {
            return false;
        }
        int diff = branch - this.effects.size();
        if (diff > 0) {
            Set[] nulls = new Set[diff];
            this.effects.addAll(Arrays.asList(nulls));
        }
        if ((existing = this.effects.get(branch - 1)) == null) {
            existing = new HashSet<ATermAppl>();
            this.effects.set(branch - 1, existing);
        }
        return existing.add(a);
    }

    @Override
    public SimpleBranchEffectTracker copy() {
        return new SimpleBranchEffectTracker(this);
    }

    @Override
    public Set<ATermAppl> getAll(int branch) {
        if (branch < 1) {
            throw new IllegalArgumentException();
        }
        if (branch > this.effects.size()) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (int i = branch - 1; i < this.effects.size(); ++i) {
            Set<ATermAppl> s = this.effects.get(i);
            if (s == null) continue;
            ret.addAll(s);
        }
        return ret;
    }

    @Override
    public Set<ATermAppl> remove(int branch) {
        if (branch < 1) {
            throw new IllegalArgumentException();
        }
        if (branch > this.effects.size()) {
            return Collections.emptySet();
        }
        Set<ATermAppl> ret = this.effects.remove(branch - 1);
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    @Override
    public Set<ATermAppl> removeAll(int branch) {
        if (branch < 1) {
            throw new IllegalArgumentException();
        }
        if (branch > this.effects.size()) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (int i = this.effects.size() - 1; i >= branch - 1; --i) {
            Set<ATermAppl> s = this.effects.remove(i);
            if (s == null) continue;
            ret.addAll(s);
        }
        return ret;
    }
}

