/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;

public class DefaultEdge
implements Edge {
    private Individual from;
    private Node to;
    private Role role;
    private DependencySet depends;

    public DefaultEdge(Role name, Individual from, Node to) {
        this.role = name;
        this.from = from;
        this.to = to;
    }

    public DefaultEdge(Role name, Individual from, Node to, DependencySet d) {
        this.role = name;
        this.from = from;
        this.to = to;
        this.depends = d;
    }

    public Node getNeighbor(Node node) {
        if (this.from.equals(node)) {
            return this.to;
        }
        if (this.to.equals(node)) {
            return this.from;
        }
        return null;
    }

    public String toString() {
        return "[" + this.from + ", " + this.role + ", " + this.to + "] - " + this.depends;
    }

    public DependencySet getDepends() {
        return this.depends;
    }

    public Individual getFrom() {
        return this.from;
    }

    public Role getRole() {
        return this.role;
    }

    public Node getTo() {
        return this.to;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultEdge)) {
            return false;
        }
        DefaultEdge that = (DefaultEdge)other;
        return this.from.equals(that.from) && this.role.equals(that.role) && this.to.equals(that.to);
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 31 * hashCode + this.role.hashCode();
        hashCode = 31 * hashCode + this.from.hashCode();
        hashCode = 31 * hashCode + this.to.hashCode();
        return hashCode;
    }

    public ATermAppl getFromName() {
        return this.getFrom().getName();
    }

    public ATermAppl getToName() {
        return this.getTo().getName();
    }

    public void setDepends(DependencySet ds) {
        this.depends = ds;
    }
}

