/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.ChooseBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class ChooseRule
extends AbstractTableauRule {
    public ChooseRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.CHOOSE, AbstractTableauRule.BlockingType.INDIRECT);
    }

    public void apply(Individual x) {
        if (!x.canApply(5)) {
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (ATermAppl maxCard : maxCardinality) {
            this.apply(x, maxCard);
        }
    }

    protected void apply(Individual x, ATermAppl maxCard) {
        ATermAppl max = (ATermAppl)maxCard.getArgument(0);
        Role r = this.strategy.getABox().getRole(max.getArgument(0));
        ATermAppl c = (ATermAppl)max.getArgument(2);
        if (ATermUtils.isTop(c)) {
            return;
        }
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends((ATerm)maxCard) == null) {
            return;
        }
        EdgeList edges = x.getRNeighborEdges(r);
        for (Edge edge : edges) {
            Node neighbor = edge.getNeighbor(x);
            if (neighbor.hasType((ATerm)c) || neighbor.hasType((ATerm)ATermUtils.negate(c))) continue;
            ChooseBranch newBranch = new ChooseBranch(this.strategy.getABox(), this.strategy, neighbor, c, x.getDepends((ATerm)maxCard));
            this.strategy.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }
}

