/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.MaxBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxRule
extends AbstractTableauRule {
    public MaxRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.MAX_NUMBER, AbstractTableauRule.BlockingType.INDIRECT);
    }

    @Override
    public void apply(Individual x) {
        if (!x.canApply(5)) {
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (int i = 0; i < maxCardinality.size(); ++i) {
            ATermAppl mc = maxCardinality.get(i);
            this.applyMaxRule(x, mc);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            if (!x.isMerged()) continue;
            return;
        }
        x.applyNext[5] = maxCardinality.size();
    }

    protected void applyMaxRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this.strategy.getABox().getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        ATermAppl c = (ATermAppl)max.getArgument(2);
        DependencySet ds = x.getDepends((ATerm)mc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (n == 1) {
            this.applyFunctionalMaxRule(x, r, c, ds);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
        } else {
            boolean hasMore = true;
            while (hasMore) {
                hasMore = this.applyMaxRule(x, r, c, n, ds);
                if (this.strategy.getABox().isClosed()) {
                    return;
                }
                if (x.isMerged()) {
                    return;
                }
                if (!hasMore) continue;
                ds = ds.union(new DependencySet(this.strategy.getABox().getBranches().size()), this.strategy.getABox().doExplanation());
            }
        }
    }

    protected boolean applyMaxRule(Individual x, Role r, ATermAppl c, int k, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set<Node> neighbors = edges.getFilteredNeighbors(x, c);
        int n = neighbors.size();
        if (k == 0 && n > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                Node neighbor = edge.getNeighbor(x);
                DependencySet typeDS = neighbor.getDepends((ATerm)c);
                if (typeDS == null) continue;
                Role edgeRole = edge.getRole();
                DependencySet subDS = r.getExplainSubOrInv(edgeRole);
                ds = ds.union(subDS, this.strategy.getABox().doExplanation());
                ds = ds.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                ds = ds.union(typeDS, this.strategy.getABox().doExplanation());
            }
            this.strategy.getABox().setClash(Clash.maxCardinality(x, ds, r.getName(), 0));
            return false;
        }
        if (n <= k) {
            return false;
        }
        ArrayList<NodeMerge> mergePairs = new ArrayList<NodeMerge>();
        DependencySet differenceDS = this.findMergeNodes(neighbors, x, mergePairs);
        ds = ds.union(differenceDS, this.strategy.getABox().doExplanation());
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1, c);
            if (dsEdges == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cannot determine the exact clash dependency for " + x);
                }
                this.strategy.getABox().setClash(Clash.maxCardinality(x, ds));
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges, this.strategy.getABox().doExplanation()) + " " + x.getRNeighborEdges(r).getNeighbors(x));
            }
            if (this.strategy.getABox().doExplanation()) {
                this.strategy.getABox().setClash(Clash.maxCardinality(x, ds.union(dsEdges, this.strategy.getABox().doExplanation()), r.getName(), k));
            } else {
                this.strategy.getABox().setClash(Clash.maxCardinality(x, ds.union(dsEdges, this.strategy.getABox().doExplanation())));
            }
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.strategy.getABox(), this.strategy, x, r, k, c, mergePairs, ds);
        this.strategy.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("hasMore: " + (n > k + 1));
        }
        return n > k + 1;
    }

    DependencySet findMergeNodes(Set<Node> neighbors, Individual node, List<NodeMerge> pairs) {
        DependencySet ds = DependencySet.INDEPENDENT;
        ArrayList<Node> nodes = new ArrayList<Node>(neighbors);
        for (int i = 0; i < nodes.size(); ++i) {
            Node y = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = (Node)nodes.get(j);
                if (y.isDifferent(x)) {
                    ds = ds.union(y.getDifferenceDependency(x), this.strategy.getABox().doExplanation());
                    continue;
                }
                if (x.getNominalLevel() < y.getNominalLevel()) {
                    pairs.add(new NodeMerge(y, x));
                    continue;
                }
                if (y.isNominal()) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                if (y.hasSuccessor(node)) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                pairs.add(new NodeMerge(y, x));
            }
        }
        return ds;
    }

    public void applyFunctionalMaxRule(Individual x, Role s, ATermAppl c, DependencySet ds) {
        Set<Role> functionalSupers = s.getFunctionalSupers();
        if (functionalSupers.isEmpty()) {
            functionalSupers = SetUtils.singleton(s);
        }
        block0: for (Role r : functionalSupers) {
            Edge edge;
            int edgeIndex;
            Set<Node> neighbors;
            EdgeList edges;
            if (PelletOptions.USE_TRACING) {
                ds = ds.union(s.getExplainSuper((ATerm)r.getName()), this.strategy.getABox().doExplanation()).union(r.getExplainFunctional(), this.strategy.getABox().doExplanation());
            }
            if ((edges = x.getRNeighborEdges(r)).size() <= 1 || (neighbors = edges.getFilteredNeighbors(x, c)).size() <= 1) continue;
            Node head = null;
            int edgeCount = edges.size();
            for (edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                edge = edges.edgeAt(edgeIndex);
                head = edge.getNeighbor(x);
                if (head.isPruned() || !neighbors.contains(head)) continue;
                ds = ds.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                ds = ds.union(head.getDepends((ATerm)c), this.strategy.getABox().doExplanation());
                ds = ds.union(r.getExplainSubOrInv(edge.getRole()), this.strategy.getABox().doExplanation());
                break;
            }
            ++edgeIndex;
            while (edgeIndex < edgeCount) {
                edge = edges.edgeAt(edgeIndex);
                Node next = edge.getNeighbor(x);
                if (!next.isPruned() && neighbors.contains(next) && !head.isSame(next)) {
                    ds = ds.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                    ds = ds.union(next.getDepends((ATerm)c), this.strategy.getABox().doExplanation());
                    ds = ds.union(s.getExplainSubOrInv(edge.getRole()), this.strategy.getABox().doExplanation());
                    if (next.isDifferent(head)) {
                        ds = ds.union(head.getDepends((ATerm)c), this.strategy.getABox().doExplanation());
                        ds = ds.union(next.getDepends((ATerm)c), this.strategy.getABox().doExplanation());
                        ds = ds.union(next.getDifferenceDependency(head), this.strategy.getABox().doExplanation());
                        if (r.isFunctional()) {
                            this.strategy.getABox().setClash(Clash.functionalCardinality(x, ds, r.getName()));
                            continue block0;
                        }
                        this.strategy.getABox().setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                        continue block0;
                    }
                    if (x.isNominal() && head.isBlockable() && next.isBlockable() && head.hasSuccessor(x) && next.hasSuccessor(x)) {
                        Individual newNominal = this.strategy.createFreshIndividual(null, ds);
                        this.strategy.addEdge(x, r, newNominal, ds);
                        continue block0;
                    }
                    if (next.getNominalLevel() < head.getNominalLevel() || !head.isNominal() && next.hasSuccessor(x)) {
                        Node temp = head;
                        head = next;
                        next = temp;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
                    }
                    this.strategy.mergeTo(next, head, ds);
                    if (this.strategy.getABox().isClosed()) {
                        return;
                    }
                    if (head.isPruned()) {
                        ds = ds.union(head.getMergeDependency(true), this.strategy.getABox().doExplanation());
                        head = head.getSame();
                    }
                }
                ++edgeIndex;
            }
        }
    }
}

