/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    private Taxonomy<T> taxonomy;
    private PrintWriter out;
    private Set<T> bottomEquivalents;
    private Set<T> printed;

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<T> taxonomy, PrintWriter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        this.bottomEquivalents = new TreeSet<Object>(Comparators.stringComparator);
        this.bottomEquivalents.addAll(taxonomy.getBottom().getEquivalents());
        this.printed = new HashSet<T>();
        out.println();
        TreeSet<Object> sortedTop = new TreeSet<Object>(Comparators.stringComparator);
        sortedTop.addAll(taxonomy.getTop().getEquivalents());
        Set<TreeSet<Object>> topGroup = Collections.singleton(sortedTop);
        this.printGroup(topGroup);
        this.taxonomy = null;
        this.out = null;
        this.bottomEquivalents = null;
        this.printed = null;
        out.println();
        out.flush();
    }

    private void printGroup(Collection<? extends Collection<T>> concepts) {
        LinkedHashSet<Object> nextGroup = new LinkedHashSet<Object>();
        for (Collection<T> eqC : concepts) {
            T firstC = eqC.iterator().next();
            Set<Set<T>> supEqs = this.taxonomy.getSupers(firstC, true);
            if (supEqs.size() > 1 && this.printed.contains(firstC)) continue;
            this.printed.add(firstC);
            this.out.print("(");
            this.printEqClass(eqC);
            this.out.print(" ");
            TreeSet<Object> sortedSupEqs = new TreeSet<Object>(Comparators.stringComparator);
            Iterator<Set<T>> j = supEqs.iterator();
            while (j.hasNext()) {
                TreeSet<Object> group = new TreeSet<Object>(Comparators.stringComparator);
                group.addAll((Collection<Object>)j.next());
                sortedSupEqs.add(group);
            }
            this.printEqClassGroups(sortedSupEqs);
            this.out.print(" ");
            TreeSet<Object> sortedSubEqs = new TreeSet<Object>(Comparators.stringComparator);
            Set<Set<T>> subEqs = this.taxonomy.getSubs(firstC, true);
            Iterator<Set<T>> j2 = subEqs.iterator();
            while (j2.hasNext()) {
                TreeSet<Object> group = new TreeSet<Object>(Comparators.stringComparator);
                group.addAll((Collection<Object>)j2.next());
                sortedSubEqs.add(group);
            }
            this.printEqClassGroups(sortedSubEqs);
            nextGroup.addAll(sortedSubEqs);
            this.out.println(")");
        }
        switch (nextGroup.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.printGroup(nextGroup);
                break;
            }
            default: {
                nextGroup.remove(this.bottomEquivalents);
                this.printGroup(nextGroup);
            }
        }
    }

    private void printEqClass(Collection<T> concept) {
        int size = concept.size();
        T c2 = null;
        switch (size) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                c2 = concept.iterator().next();
                this.printURI(c2);
                break;
            }
            default: {
                this.out.print("(");
                boolean first = true;
                for (T c2 : concept) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printURI(c2);
                }
                this.out.print(")");
            }
        }
    }

    private void printEqClassGroups(Collection<? extends Collection<T>> concepts) {
        int size = concepts.size();
        Collection<T> eqC2 = null;
        switch (size) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                eqC2 = concepts.iterator().next();
                this.out.print("(");
                this.printEqClass(eqC2);
                this.out.print(")");
                break;
            }
            default: {
                this.out.print("(");
                boolean first = true;
                for (Collection<T> eqC2 : concepts) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printEqClass(eqC2);
                }
                this.out.print(")");
            }
        }
    }

    private void printURI(T c) {
        String uri = c.toString();
        if (c.equals(ATermUtils.TOP)) {
            uri = "http://www.w3.org/2002/07/owl#Thing";
        } else if (c.equals(ATermUtils.BOTTOM)) {
            uri = "http://www.w3.org/2002/07/owl#Nothing";
        }
        this.out.print(uri);
    }
}

