/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermDefinition {
    private List<ATermAppl> subClassAxioms = new ArrayList<ATermAppl>();
    private List<ATermAppl> eqClassAxioms = new ArrayList<ATermAppl>();
    private Set<ATermAppl> dependencies;

    public TermDefinition() {
        this.updateDependencies();
    }

    public Set<ATermAppl> getDependencies() {
        if (this.dependencies == null) {
            this.updateDependencies();
        }
        return this.dependencies;
    }

    public void clearDependencies() {
        this.dependencies = null;
    }

    public ATermAppl getName() {
        if (!this.subClassAxioms.isEmpty()) {
            return (ATermAppl)this.subClassAxioms.get(0).getArgument(0);
        }
        if (!this.eqClassAxioms.isEmpty()) {
            return (ATermAppl)this.eqClassAxioms.get(0).getArgument(0);
        }
        return null;
    }

    public boolean addDef(ATermAppl appl) {
        boolean added = false;
        AFun fun = appl.getAFun();
        if (fun.equals(ATermUtils.SUBFUN)) {
            added = this.subClassAxioms.contains(appl) ? false : this.subClassAxioms.add(appl);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            added = this.eqClassAxioms.contains(appl) ? false : this.eqClassAxioms.add(appl);
        } else {
            throw new RuntimeException("Cannot add non-definition!");
        }
        if (added) {
            this.updateDependencies();
        }
        return added;
    }

    public boolean removeDef(ATermAppl axiom) {
        boolean removed;
        AFun fun = axiom.getAFun();
        if (fun.equals(ATermUtils.SUBFUN)) {
            removed = this.subClassAxioms.remove(axiom);
        } else if (fun.equals(ATermUtils.EQCLASSFUN)) {
            removed = this.eqClassAxioms.remove(axiom);
        } else {
            throw new RuntimeException("Cannot remove non-definition!");
        }
        this.updateDependencies();
        return removed;
    }

    public boolean isPrimitive() {
        return this.eqClassAxioms.isEmpty();
    }

    public boolean isUnique() {
        return this.eqClassAxioms.isEmpty() || this.subClassAxioms.isEmpty() && this.eqClassAxioms.size() == 1;
    }

    public boolean isUnique(ATermAppl axiom) {
        return this.eqClassAxioms.isEmpty() && (this.subClassAxioms.isEmpty() || axiom.getAFun().equals(ATermUtils.SUBFUN));
    }

    public List<ATermAppl> getSubClassAxioms() {
        return this.subClassAxioms;
    }

    public List<ATermAppl> getEqClassAxioms() {
        return this.eqClassAxioms;
    }

    public String toString() {
        return this.subClassAxioms + "; " + this.eqClassAxioms;
    }

    protected void updateDependencies() {
        this.dependencies = CollectionUtils.makeIdentitySet();
        for (ATermAppl sub : this.getSubClassAxioms()) {
            ATermUtils.findPrimitives((ATermAppl)sub.getArgument(1), this.dependencies);
        }
        for (ATermAppl eq : this.getEqClassAxioms()) {
            ATermUtils.findPrimitives((ATermAppl)eq.getArgument(1), this.dependencies);
        }
    }
}

