/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIncrementalChangeTracker
implements IncrementalChangeTracker {
    private HashSet<Edge> deletedEdges;
    private HashMap<Node, Set<ATermAppl>> deletedTypes;
    private HashSet<Edge> newEdges;
    private HashSet<Individual> newIndividuals;
    private HashSet<Node> unprunedNodes;
    private HashSet<Individual> updatedIndividuals;

    public SimpleIncrementalChangeTracker() {
        this.deletedEdges = new HashSet();
        this.deletedTypes = new HashMap();
        this.newEdges = new HashSet();
        this.newIndividuals = new HashSet();
        this.unprunedNodes = new HashSet();
        this.updatedIndividuals = new HashSet();
    }

    private SimpleIncrementalChangeTracker(SimpleIncrementalChangeTracker src, ABox target) {
        Individual ti;
        Node o;
        Individual s;
        this.deletedEdges = new HashSet(src.deletedEdges.size());
        for (Edge edge : src.deletedEdges) {
            s = target.getIndividual((ATerm)edge.getFrom().getName());
            if (s == null) {
                throw new NullPointerException();
            }
            o = target.getNode((ATerm)edge.getTo().getName());
            if (o == null) {
                throw new NullPointerException();
            }
            this.newEdges.add(new DefaultEdge(edge.getRole(), s, o, edge.getDepends()));
        }
        this.deletedTypes = new HashMap(src.deletedTypes.size());
        for (Map.Entry entry : src.deletedTypes.entrySet()) {
            Node n = target.getNode((ATerm)((Node)entry.getKey()).getName());
            if (n == null) {
                throw new NullPointerException();
            }
            this.deletedTypes.put(n, new HashSet((Collection)entry.getValue()));
        }
        this.newEdges = new HashSet(src.newEdges.size());
        for (Edge edge : src.newEdges) {
            s = target.getIndividual((ATerm)edge.getFrom().getName());
            if (s == null) {
                throw new NullPointerException();
            }
            o = target.getNode((ATerm)edge.getTo().getName());
            if (o == null) {
                throw new NullPointerException();
            }
            this.newEdges.add(new DefaultEdge(edge.getRole(), s, o, edge.getDepends()));
        }
        this.newIndividuals = new HashSet(src.newIndividuals.size());
        for (Individual individual : src.newIndividuals) {
            ti = target.getIndividual((ATerm)individual.getName());
            if (ti == null) {
                throw new NullPointerException();
            }
            this.newIndividuals.add(ti);
        }
        this.unprunedNodes = new HashSet(src.unprunedNodes.size());
        for (Node node : src.unprunedNodes) {
            Node tn = target.getNode((ATerm)node.getName());
            if (tn == null) {
                throw new NullPointerException();
            }
            this.unprunedNodes.add(tn);
        }
        this.updatedIndividuals = new HashSet(src.updatedIndividuals.size());
        for (Individual individual : src.updatedIndividuals) {
            ti = target.getIndividual((ATerm)individual.getName());
            if (ti == null) {
                throw new NullPointerException();
            }
            this.updatedIndividuals.add(ti);
        }
    }

    @Override
    public boolean addDeletedEdge(Edge e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.deletedEdges.add(e);
    }

    @Override
    public boolean addDeletedType(Node n, ATermAppl type) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        Set<ATermAppl> existing = this.deletedTypes.get(n);
        if (existing == null) {
            existing = new HashSet<ATermAppl>();
            this.deletedTypes.put(n, existing);
        }
        return existing.add(type);
    }

    @Override
    public boolean addNewEdge(Edge e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.newEdges.add(e);
    }

    @Override
    public boolean addNewIndividual(Individual i) {
        if (i == null) {
            throw new NullPointerException();
        }
        return this.newIndividuals.add(i);
    }

    @Override
    public boolean addUnprunedNode(Node n) {
        if (n == null) {
            throw new NullPointerException();
        }
        return this.unprunedNodes.add(n);
    }

    @Override
    public boolean addUpdatedIndividual(Individual i) {
        if (i == null) {
            throw new NullPointerException();
        }
        return this.updatedIndividuals.add(i);
    }

    @Override
    public void clear() {
        this.deletedEdges.clear();
        this.deletedTypes.clear();
        this.newEdges.clear();
        this.newIndividuals.clear();
        this.unprunedNodes.clear();
        this.updatedIndividuals.clear();
    }

    @Override
    public SimpleIncrementalChangeTracker copy(ABox target) {
        return new SimpleIncrementalChangeTracker(this, target);
    }

    @Override
    public Iterator<Edge> deletedEdges() {
        return Collections.unmodifiableSet(this.deletedEdges).iterator();
    }

    @Override
    public Iterator<Map.Entry<Node, Set<ATermAppl>>> deletedTypes() {
        return Collections.unmodifiableMap(this.deletedTypes).entrySet().iterator();
    }

    @Override
    public Iterator<Edge> newEdges() {
        return Collections.unmodifiableSet(this.newEdges).iterator();
    }

    @Override
    public Iterator<Individual> newIndividuals() {
        return Collections.unmodifiableSet(this.newIndividuals).iterator();
    }

    @Override
    public Iterator<Node> unprunedNodes() {
        return Collections.unmodifiableSet(this.unprunedNodes).iterator();
    }

    @Override
    public Iterator<Individual> updatedIndividuals() {
        return Collections.unmodifiableSet(this.updatedIndividuals).iterator();
    }
}

