/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import com.clarkparsia.pellet.utils.IdentityHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <K, V> Map<K, V> makeIdentityMap() {
        return new IdentityHashMap();
    }

    public static <K, V> Map<K, V> makeIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> Map<K, V> makeIdentityMap(Map<? extends K, ? extends V> map) {
        return new IdentityHashMap<K, V>(map);
    }

    public static <T> Set<T> makeIdentitySet() {
        return new IdentityHashSet();
    }

    public static <T> Set<T> makeIdentitySet(int size) {
        return new IdentityHashSet(size);
    }

    public static <T> Set<T> makeIdentitySet(Collection<? extends T> a) {
        return new IdentityHashSet<T>(a);
    }

    public static <T> List<T> makeList() {
        return new ArrayList();
    }

    public static <T> List<T> makeList(int size) {
        return new ArrayList(size);
    }

    public static <T> List<T> makeList(Collection<? extends T> a) {
        return new ArrayList<T>(a);
    }

    public static <K, V> Map<K, V> makeMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> makeMap(int size) {
        return new HashMap(size);
    }

    public static <K, V> Map<K, V> makeMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <T> Set<T> makeSet() {
        return new HashSet();
    }

    public static <T> Set<T> makeSet(int size) {
        return new HashSet(size);
    }

    public static <T> Set<T> makeSet(Collection<? extends T> a) {
        return new HashSet<T>(a);
    }
}

