/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    public static final Logger log = Logger.getLogger(Node.class.getName());
    public static final int BLOCKABLE = Integer.MAX_VALUE;
    public static final int NOMINAL = 0;
    public static final int CHANGED = 127;
    public static final int UNCHANGED = 0;
    public static final int ATOM = 0;
    public static final int OR = 1;
    public static final int SOME = 2;
    public static final int ALL = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int NOM = 6;
    public static final int TYPES = 7;
    protected ABox abox;
    protected ATermAppl name;
    protected Map<ATermAppl, DependencySet> depends;
    private boolean isRoot;
    private boolean isConceptRoot;
    protected Node mergedTo = this;
    protected EdgeList inEdges;
    protected DependencySet mergeDepends = null;
    protected DependencySet pruned = null;
    protected Set<Node> merged;
    protected Map<Node, DependencySet> differents;

    protected Node(ATermAppl name, ABox abox) {
        this.name = name;
        this.abox = abox;
        this.isRoot = !ATermUtils.isAnon(name);
        this.isConceptRoot = false;
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.differents = CollectionUtils.makeMap();
        this.depends = CollectionUtils.makeMap();
        this.inEdges = new EdgeList();
    }

    protected Node(Node node, ABox abox) {
        this.name = node.getName();
        this.abox = abox;
        this.isRoot = node.isRoot;
        this.isConceptRoot = node.isConceptRoot;
        this.mergeDepends = node.mergeDepends;
        this.mergedTo = node.mergedTo;
        this.merged = node.merged;
        this.pruned = node.pruned;
        this.differents = node.differents;
        this.depends = CollectionUtils.makeMap(node.depends);
        this.inEdges = node.inEdges;
    }

    protected void updateNodeReferences() {
        this.mergedTo = this.abox.getNode((ATerm)this.mergedTo.getName());
        HashMap<Node, DependencySet> diffs = new HashMap<Node, DependencySet>(this.differents.size());
        for (Map.Entry<Node, DependencySet> entry : this.differents.entrySet()) {
            Node node = entry.getKey();
            diffs.put(this.abox.getNode((ATerm)node.getName()), entry.getValue());
        }
        this.differents = diffs;
        if (this.merged != null) {
            HashSet<Node> sames = new HashSet<Node>(this.merged.size());
            for (Node node : this.merged) {
                sames.add(this.abox.getNode((ATerm)node.getName()));
            }
            this.merged = sames;
        }
        EdgeList oldEdges = this.inEdges;
        this.inEdges = new EdgeList(oldEdges.size());
        for (int i = 0; i < oldEdges.size(); ++i) {
            Edge edge = oldEdges.edgeAt(i);
            Individual from = this.abox.getIndividual((ATerm)edge.getFrom().getName());
            DefaultEdge newEdge = new DefaultEdge(edge.getRole(), from, this, edge.getDepends());
            this.inEdges.addEdge(newEdge);
            if (this.isPruned()) continue;
            from.getOutEdges().addEdge(newEdge);
        }
    }

    public void setChanged(int type) {
        QueueElement newElement = new QueueElement(this);
        if ((type == 3 || type == 4) && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().add(newElement, NodeSelector.DATATYPE);
        }
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
    }

    public boolean isConceptRoot() {
        return this.isConceptRoot;
    }

    public void setConceptRoot(boolean isConceptRoot) {
        this.isConceptRoot = isConceptRoot;
    }

    public boolean isBnode() {
        return ATermUtils.isBnode(this.name);
    }

    public boolean isNamedIndividual() {
        return this.isRoot && !this.isConceptRoot && !this.isBnode();
    }

    public boolean isRoot() {
        return this.isRoot || this.isNominal();
    }

    public abstract boolean isLeaf();

    public boolean isRootNominal() {
        return this.isRoot && this.isNominal();
    }

    public abstract Node copyTo(ABox var1);

    protected void addInEdge(Edge edge) {
        this.inEdges.addEdge(edge);
    }

    public EdgeList getInEdges() {
        return this.inEdges;
    }

    public boolean removeInEdge(Edge edge) {
        boolean removed = this.inEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    public void removeInEdges() {
        this.inEdges = new EdgeList();
    }

    public void reset(boolean onlyApplyTypes) {
        assert (onlyApplyTypes || this.isRootNominal()) : "Only asserted individuals can be reset: " + this;
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().add(new QueueElement(this));
        }
        if (onlyApplyTypes) {
            return;
        }
        if (this.pruned != null) {
            this.unprune(DependencySet.NO_BRANCH);
        }
        this.mergedTo = this;
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.merged = null;
        Iterator<DependencySet> i = this.differents.values().iterator();
        while (i.hasNext()) {
            DependencySet d = i.next();
            if (d.getBranch() == DependencySet.NO_BRANCH) continue;
            i.remove();
        }
        this.resetTypes();
        this.inEdges.reset();
    }

    protected void resetTypes() {
        Iterator<DependencySet> i = this.depends.values().iterator();
        while (i.hasNext()) {
            DependencySet d = i.next();
            if (d.getBranch() == DependencySet.NO_BRANCH) continue;
            i.remove();
        }
    }

    public Boolean restorePruned(int branch) {
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.name);
        }
        if (this.pruned != null) {
            if (this.pruned.getBranch() > branch) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RESTORE: " + this + " merged node " + this.mergedTo + " " + this.mergeDepends);
                }
                if (this.mergeDepends.getBranch() > branch) {
                    this.undoSetSame();
                }
                this.unprune(branch);
                if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                    this.abox.getIncrementalChangeTracker().addUnprunedNode(this);
                }
                if (this instanceof Individual) {
                    Individual ind = (Individual)this;
                    if (PelletOptions.USE_COMPLETION_QUEUE) {
                        ind.applyNext[6] = 0;
                        this.abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.NOMINAL);
                    }
                }
                return Boolean.TRUE;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("DO NOT RESTORE: pruned node " + this + " = " + this.mergedTo + " " + this.mergeDepends);
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean restore(int branch) {
        DependencySet d;
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.name);
        }
        boolean restored = false;
        ArrayList<ATermAppl> conjunctions = new ArrayList<ATermAppl>();
        boolean removed = false;
        Iterator<Object> i = this.getTypes().iterator();
        while (i.hasNext()) {
            boolean removeType;
            ATermAppl c = i.next();
            d = this.getDepends((ATerm)c);
            boolean bl = PelletOptions.USE_SMART_RESTORE ? d.max() >= branch : (removeType = d.getBranch() > branch);
            if (removeType) {
                removed = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RESTORE: " + this + " remove type " + c + " " + d + " " + branch);
                }
                if (PelletOptions.USE_INCREMENTAL_CONSISTENCY && this instanceof Individual) {
                    this.abox.getIncrementalChangeTracker().addDeletedType(this, c);
                }
                i.remove();
                this.removeType(c);
                restored = true;
                continue;
            }
            if (!PelletOptions.USE_SMART_RESTORE || !ATermUtils.isAnd(c)) continue;
            conjunctions.add(c);
        }
        if (removed && PelletOptions.USE_COMPLETION_QUEUE && this instanceof Individual) {
            Individual ind = (Individual)this;
            ind.applyNext[0] = 0;
            ind.applyNext[1] = 0;
            QueueElement qe = new QueueElement(this);
            this.abox.getCompletionQueue().add(qe, NodeSelector.DISJUNCTION);
            this.abox.getCompletionQueue().add(qe, NodeSelector.ATOM);
        }
        if (PelletOptions.USE_SMART_RESTORE) {
            for (ATermAppl c : conjunctions) {
                d = this.getDepends((ATerm)c);
                ATermList cs = (ATermList)c.getArgument(0);
                while (!cs.isEmpty()) {
                    ATermAppl conj = (ATermAppl)cs.getFirst();
                    this.addType(conj, d);
                    cs = cs.getNext();
                }
            }
        }
        i = this.differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Node node = (Node)entry.getKey();
            DependencySet d2 = (DependencySet)entry.getValue();
            if (d2.getBranch() <= branch) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("RESTORE: " + this.name + " delete difference " + node);
            }
            i.remove();
            restored = true;
        }
        removed = false;
        i = this.inEdges.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            d = e.getDepends();
            if (d.getBranch() <= branch) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("RESTORE: " + this.name + " delete reverse edge " + e);
            }
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.abox.getIncrementalChangeTracker().addDeletedEdge(e);
            }
            i.remove();
            restored = true;
            removed = true;
        }
        if (removed && PelletOptions.USE_COMPLETION_QUEUE) {
            QueueElement qe = new QueueElement(this);
            this.abox.getCompletionQueue().add(qe, NodeSelector.EXISTENTIAL);
            this.abox.getCompletionQueue().add(qe, NodeSelector.MIN_NUMBER);
        }
        return restored;
    }

    public void addType(ATermAppl c, DependencySet ds) {
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c);
        }
        if (this.isMerged()) {
            return;
        }
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), this.getName());
        }
        int b = this.abox.getBranch();
        int max = ds.max();
        if (b == -1 && max != 0) {
            b = max + 1;
        }
        ds = ds.copy(b);
        this.depends.put(c, ds);
        this.abox.setChanged(true);
    }

    public boolean removeType(ATermAppl c) {
        return this.depends.remove(c) != null;
    }

    public boolean hasType(ATerm c) {
        return this.depends.containsKey(c);
    }

    public Bool hasObviousType(ATermAppl c) {
        DependencySet ds = this.getDepends((ATerm)c);
        if (ds != null) {
            if (ds.isIndependent()) {
                return Bool.TRUE;
            }
        } else {
            ds = this.getDepends((ATerm)ATermUtils.negate(c));
            if (ds != null) {
                if (ds.isIndependent()) {
                    return Bool.FALSE;
                }
            } else if (this.isIndividual() && ATermUtils.isNominal(c)) {
                if (!c.getArgument(0).equals(this.getName())) {
                    return Bool.FALSE;
                }
                return Bool.TRUE;
            }
        }
        if (this.isIndividual()) {
            ATermAppl r = null;
            ATermAppl d = null;
            if (ATermUtils.isNot(c)) {
                ATermAppl notC = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAllValues(notC)) {
                    r = (ATermAppl)notC.getArgument(0);
                    d = ATermUtils.negate((ATermAppl)notC.getArgument(1));
                }
            } else if (ATermUtils.isSomeValues(c)) {
                r = (ATermAppl)c.getArgument(0);
                d = (ATermAppl)c.getArgument(1);
            }
            if (r != null) {
                Individual ind = (Individual)this;
                Role role = this.abox.getRole((ATerm)r);
                if (!role.isObjectRole() || !role.isSimple()) {
                    return Bool.UNKNOWN;
                }
                EdgeList edges = ind.getRNeighborEdges(role);
                Bool ot = Bool.FALSE;
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edge = edges.edgeAt(e);
                    if (!edge.getDepends().isIndependent()) {
                        ot = Bool.UNKNOWN;
                        continue;
                    }
                    Individual y = (Individual)edge.getNeighbor(ind);
                    if (!(ot = ot.or(this.abox.isKnownType(y, d, SetUtils.<ATermAppl>emptySet()))).isTrue()) continue;
                    return ot;
                }
                return ot;
            }
        }
        return Bool.UNKNOWN;
    }

    public boolean hasObviousType(Collection<ATermAppl> coll) {
        for (ATermAppl c : coll) {
            DependencySet ds = this.getDepends((ATerm)c);
            if (ds == null || !ds.isIndependent()) continue;
            return true;
        }
        return false;
    }

    boolean hasPredecessor(Individual x) {
        return x.hasSuccessor(this);
    }

    public abstract boolean hasSuccessor(Node var1);

    public abstract DependencySet getNodeDepends();

    public DependencySet getDepends(ATerm c) {
        return this.depends.get(c);
    }

    public Map<ATermAppl, DependencySet> getDepends() {
        return this.depends;
    }

    public Set<ATermAppl> getTypes() {
        return this.depends.keySet();
    }

    public void removeTypes() {
        this.depends.clear();
    }

    public int prunedAt() {
        return this.pruned.getBranch();
    }

    public boolean isPruned() {
        return this.pruned != null;
    }

    public DependencySet getPruned() {
        return this.pruned;
    }

    public abstract void prune(DependencySet var1);

    public void unprune(int branch) {
        this.pruned = null;
        boolean added = false;
        for (int i = 0; i < this.inEdges.size(); ++i) {
            Edge edge = this.inEdges.edgeAt(i);
            DependencySet d = edge.getDepends();
            if (d.getBranch() > branch) continue;
            Individual pred = edge.getFrom();
            Role role = edge.getRole();
            if (pred.getOutEdges().hasExactEdge(pred, role, this)) continue;
            pred.addOutEdge(edge);
            if (PelletOptions.TRACK_BRANCH_EFFECTS) {
                this.abox.getBranchEffectTracker().add(d.getBranch(), pred.name);
                this.abox.getBranchEffectTracker().add(d.getBranch(), this.name);
            }
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                added = true;
                pred.applyNext[5] = 0;
                QueueElement qe = new QueueElement(pred);
                this.abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
                this.abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
                this.abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
                this.abox.getCompletionQueue().add(qe, NodeSelector.UNIVERSAL);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("RESTORE: " + this.name + " ADD reverse edge " + edge);
        }
        if (added && this instanceof Individual) {
            Individual ind = (Individual)this;
            ind.applyNext[5] = 0;
            QueueElement qe = new QueueElement(ind);
            this.abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
            this.abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
            this.abox.getCompletionQueue().add(qe, NodeSelector.UNIVERSAL);
        }
    }

    public abstract int getNominalLevel();

    public abstract boolean isNominal();

    public abstract boolean isBlockable();

    public abstract boolean isLiteral();

    public abstract boolean isIndividual();

    public int mergedAt() {
        return this.mergeDepends.getBranch();
    }

    public boolean isMerged() {
        return this.mergedTo != this;
    }

    public Node getMergedTo() {
        return this.mergedTo;
    }

    public DependencySet getMergeDependency(boolean all) {
        if (!this.isMerged() || !all) {
            return this.mergeDepends;
        }
        DependencySet ds = this.mergeDepends;
        Node node = this.mergedTo;
        while (node.isMerged()) {
            ds = ds.union(node.mergeDepends, this.abox.doExplanation());
            node = node.mergedTo;
        }
        return ds;
    }

    public Node getSame() {
        if (this.mergedTo == this) {
            return this;
        }
        return this.mergedTo.getSame();
    }

    public void undoSetSame() {
        this.mergedTo.removeMerged(this);
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.mergedTo = this;
    }

    private void addMerged(Node node) {
        if (this.merged == null) {
            this.merged = new HashSet<Node>(3);
        }
        this.merged.add(node);
    }

    public Set<Node> getMerged() {
        if (this.merged == null) {
            return SetUtils.emptySet();
        }
        return this.merged;
    }

    public Map<Node, DependencySet> getAllMerged() {
        HashMap<Node, DependencySet> result = new HashMap<Node, DependencySet>();
        this.getAllMerged(DependencySet.INDEPENDENT, result);
        return result;
    }

    private void getAllMerged(DependencySet ds, Map<Node, DependencySet> result) {
        if (this.merged == null) {
            return;
        }
        for (Node mergedNode : this.merged) {
            DependencySet mergeDS = ds.union(mergedNode.getMergeDependency(false), false);
            result.put(mergedNode, mergeDS);
            mergedNode.getAllMerged(mergeDS, result);
        }
    }

    private void removeMerged(Node node) {
        this.merged.remove(node);
        if (this.merged.isEmpty()) {
            this.merged = null;
        }
    }

    public void setSame(Node node, DependencySet ds) {
        if (this.isSame(node)) {
            return;
        }
        if (this.isDifferent(node)) {
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this.abox.setClash(Clash.nominal(this, ds.union(this.mergeDepends, this.abox.doExplanation()).union(node.mergeDepends, this.abox.doExplanation()), node.getName()));
            } else {
                this.abox.setClash(Clash.nominal(this, ds, node.getName()));
            }
            return;
        }
        this.mergedTo = node;
        this.mergeDepends = ds.copy(this.abox.getBranch());
        node.addMerged(this);
    }

    public boolean isSame(Node node) {
        return this.getSame().equals(node.getSame());
    }

    public boolean isDifferent(Node node) {
        return this.differents.containsKey(node);
    }

    public Set<Node> getDifferents() {
        return this.differents.keySet();
    }

    public DependencySet getDifferenceDependency(Node node) {
        return this.differents.get(node);
    }

    public void setDifferent(Node node, DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), node.getName());
        }
        if (this.isDifferent(node)) {
            return;
        }
        if (this.isSame(node)) {
            ds = ds.union(this.getMergeDependency(true), this.abox.doExplanation());
            ds = ds.union(node.getMergeDependency(true), this.abox.doExplanation());
            this.abox.setClash(Clash.nominal(this, ds, node.getName()));
            if (!ds.isIndependent()) {
                return;
            }
        }
        ds = ds.copy(this.abox.getBranch());
        this.differents.put(node, ds);
        node.setDifferent(this, ds);
        this.abox.setChanged(true);
    }

    public void inheritDifferents(Node y, DependencySet ds) {
        for (Map.Entry<Node, DependencySet> entry : y.differents.entrySet()) {
            Node yDiff = entry.getKey();
            DependencySet finalDS = ds.union(entry.getValue(), this.abox.doExplanation());
            this.setDifferent(yDiff, finalDS);
        }
    }

    public ATermAppl getName() {
        return this.name;
    }

    public abstract ATermAppl getTerm();

    public String getNameStr() {
        return this.name.getName();
    }

    public String toString() {
        return ATermUtils.toString(this.name);
    }

    public List<ATermAppl> getPath() {
        LinkedList<ATermAppl> path = new LinkedList<ATermAppl>();
        if (this.isNamedIndividual()) {
            path.add(this.name);
        } else {
            Edge inEdge;
            HashSet<Node> cycle = new HashSet<Node>();
            Node node = this;
            while (!node.getInEdges().isEmpty() && !cycle.contains(node = (inEdge = node.getInEdges().edgeAt(0)).getFrom())) {
                cycle.add(node);
                path.addFirst(inEdge.getRole().getName());
                if (!node.isNamedIndividual()) continue;
                path.addFirst(node.getName());
                break;
            }
        }
        return path;
    }

    public ABox getABox() {
        return this.abox;
    }
}

