/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.FSMBuilder;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RoleTaxonomyBuilder;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.FilterIterator;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.iterator.MapIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RBox {
    public static Logger log = Logger.getLogger(RBox.class.getName());
    private final Map<ATermAppl, Role> roles = new HashMap<ATermAppl, Role>();
    private final Set<Role> reflexiveRoles = new HashSet<Role>();
    private final Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> domainAssertions = new HashMap<Role, Map<ATermAppl, Set<Set<ATermAppl>>>>();
    private final Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> rangeAssertions = new HashMap<Role, Map<ATermAppl, Set<Set<ATermAppl>>>>();
    private Taxonomy<ATermAppl> objectTaxonomy;
    private Taxonomy<ATermAppl> dataTaxonomy;
    private Taxonomy<ATermAppl> annotationTaxonomy;
    private final FSMBuilder fsmBuilder = new FSMBuilder(this);

    public RBox() {
        this.addDatatypeRole(ATermUtils.TOP_DATA_PROPERTY);
        this.addDatatypeRole(ATermUtils.BOTTOM_DATA_PROPERTY);
        Role topObjProp = this.addObjectRole(ATermUtils.TOP_OBJECT_PROPERTY);
        Role bottomObjProp = this.addObjectRole(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        topObjProp.setTransitive(true, DependencySet.INDEPENDENT);
        topObjProp.setReflexive(true, DependencySet.INDEPENDENT);
        bottomObjProp.setIrreflexive(true, DependencySet.INDEPENDENT);
        bottomObjProp.setAsymmetric(true, DependencySet.INDEPENDENT);
        this.addEquivalentRole((ATerm)topObjProp.getName(), (ATerm)topObjProp.getInverse().getName(), DependencySet.INDEPENDENT);
        this.addEquivalentRole((ATerm)bottomObjProp.getName(), (ATerm)bottomObjProp.getInverse().getName(), DependencySet.INDEPENDENT);
    }

    public Role getRole(ATerm r) {
        return this.roles.get(r);
    }

    public Role getDefinedRole(ATerm r) {
        Role role = this.roles.get(r);
        if (role == null) {
            throw new RuntimeException(r + " is not defined as a property");
        }
        return role;
    }

    public Role addRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, PropertyType.UNTYPED);
            this.roles.put(r, role);
        }
        return role;
    }

    public boolean addRange(ATerm p, ATermAppl range, Set<ATermAppl> explanation) {
        Set<Set<ATermAppl>> allExplanations;
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.rangeAssertions.get(r);
        if (ranges == null) {
            ranges = new HashMap<ATermAppl, Set<Set<ATermAppl>>>();
            this.rangeAssertions.put(r, ranges);
        }
        if ((allExplanations = ranges.get(range)) == null) {
            allExplanations = new HashSet<Set<ATermAppl>>();
            ranges.put(range, allExplanations);
        }
        return allExplanations.add(explanation);
    }

    public boolean addRange(ATerm p, ATermAppl range) {
        Set<ATermAppl> ds = Collections.singleton(ATermUtils.makeRange(p, (ATerm)range));
        return this.addRange(p, range, ds);
    }

    public Role addObjectRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        PropertyType roleType = role == null ? PropertyType.UNTYPED : role.getType();
        switch (roleType) {
            case DATATYPE: {
                role = null;
                break;
            }
            case OBJECT: {
                break;
            }
            default: {
                if (role == null) {
                    role = new Role(r, PropertyType.OBJECT);
                    this.roles.put(r, role);
                } else {
                    role.setType(PropertyType.OBJECT);
                }
                ATermAppl invR = ATermUtils.makeInv(r);
                Role invRole = new Role(invR, PropertyType.OBJECT);
                this.roles.put(invR, invRole);
                role.setInverse(invRole);
                invRole.setInverse(role);
                this.addSubRole((ATerm)ATermUtils.BOTTOM_OBJECT_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)ATermUtils.BOTTOM_OBJECT_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
            }
        }
        return role;
    }

    public Role addDatatypeRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, PropertyType.DATATYPE);
            this.roles.put(r, role);
            this.addSubRole((ATerm)ATermUtils.BOTTOM_DATA_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
            this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
        } else {
            switch (role.getType()) {
                case DATATYPE: {
                    break;
                }
                case OBJECT: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(PropertyType.DATATYPE);
                    this.addSubRole((ATerm)ATermUtils.BOTTOM_DATA_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                    this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
                }
            }
        }
        return role;
    }

    public Role addAnnotationRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, PropertyType.ANNOTATION);
            this.roles.put(r, role);
        } else {
            switch (role.getType()) {
                case ANNOTATION: {
                    break;
                }
                case OBJECT: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(PropertyType.ANNOTATION);
                }
            }
        }
        return role;
    }

    @Deprecated
    public Role addOntologyRole(ATermAppl r) {
        return this.addAnnotationRole(r);
    }

    public boolean addSubRole(ATerm sub, ATerm sup) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(sub, sup)) : DependencySet.INDEPENDENT;
        return this.addSubRole(sub, sup, ds);
    }

    public boolean addSubRole(ATerm sub, ATerm sup, DependencySet ds) {
        Role roleSup = this.getRole(sup);
        Role roleSub = this.getRole(sub);
        if (roleSup == null) {
            return false;
        }
        if (sub.getType() == 4) {
            roleSup.addSubRoleChain((ATermList)sub, ds);
        } else {
            if (roleSub == null) {
                return false;
            }
            roleSup.addSubRole(roleSub, ds);
            roleSub.addSuperRole(roleSup, ds);
        }
        return true;
    }

    public boolean addEquivalentRole(ATerm s, ATerm r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeEqProp(s, r)) : DependencySet.INDEPENDENT;
        return this.addEquivalentRole(r, s, ds);
    }

    public boolean addEquivalentRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addSubRole(roleS, ds);
        roleR.addSuperRole(roleS, ds);
        roleS.addSubRole(roleR, ds);
        roleS.addSuperRole(roleR, ds);
        if (roleR.getInverse() != null) {
            roleR.getInverse().addSubRole(roleS.getInverse(), ds);
            roleR.getInverse().addSuperRole(roleS.getInverse(), ds);
            roleS.getInverse().addSubRole(roleR.getInverse(), ds);
            roleS.getInverse().addSuperRole(roleR.getInverse(), ds);
        }
        return true;
    }

    public boolean addDisjointRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addDisjointRole(roleS, ds);
        roleS.addDisjointRole(roleR, ds);
        return true;
    }

    public boolean addDomain(ATerm p, ATermAppl domain, Set<ATermAppl> explanation) {
        Set<Set<ATermAppl>> allExplanations;
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.domainAssertions.get(r);
        if (domains == null) {
            domains = new HashMap<ATermAppl, Set<Set<ATermAppl>>>();
            this.domainAssertions.put(r, domains);
        }
        if ((allExplanations = domains.get(domain)) == null) {
            allExplanations = new HashSet<Set<ATermAppl>>();
            domains.put(domain, allExplanations);
        }
        return allExplanations.add(explanation);
    }

    public boolean addDomain(ATerm p, ATermAppl a) {
        Set<ATermAppl> explain = Collections.singleton(ATermUtils.makeDomain(p, (ATerm)a));
        return this.addDomain(p, a, explain);
    }

    public boolean addInverseRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null || !roleS.isObjectRole() || !roleR.isObjectRole()) {
            return false;
        }
        this.addEquivalentRole((ATerm)roleS.getInverse().getName(), r, ds);
        return true;
    }

    public Iterator<ATermAppl> getAssertedDomains(Role r) {
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.domainAssertions.get(r);
        return domains == null ? IteratorUtils.emptyIterator() : new ValueIterator(new DomainRangeIterator(domains, r, true));
    }

    public Iterator<ATermAppl> getAssertedRanges(Role r) {
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.rangeAssertions.get(r);
        return ranges == null ? IteratorUtils.emptyIterator() : new ValueIterator(new DomainRangeIterator(ranges, r, false));
    }

    @Deprecated
    public boolean isDomainAsserted(ATerm p, ATermAppl domain) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.domainAssertions.get(r);
        if (domains == null) {
            return false;
        }
        Set<Set<ATermAppl>> allExplanations = domains.get(domain);
        if (allExplanations == null) {
            return false;
        }
        Set<ATermAppl> explanation = Collections.singleton(ATermUtils.makeDomain(p, (ATerm)domain));
        return allExplanations.contains(explanation);
    }

    @Deprecated
    public boolean isRangeAsserted(ATerm p, ATermAppl range) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.rangeAssertions.get(r);
        if (ranges == null) {
            return false;
        }
        Set<Set<ATermAppl>> allExplanations = ranges.get(range);
        if (allExplanations == null) {
            return false;
        }
        Set<ATermAppl> explanation = Collections.singleton(ATermUtils.makeRange(p, (ATerm)range));
        return allExplanations.contains(explanation);
    }

    public boolean isRole(ATerm r) {
        return this.roles.containsKey(r);
    }

    public void prepare() {
        HashSet<Role> complexRoles = new HashSet<Role>();
        block0: for (Role role : this.roles.values()) {
            HashMap<ATerm, DependencySet> subExplain = new HashMap<ATerm, DependencySet>();
            HashSet<Role> subRoles = new HashSet<Role>();
            HashSet<ATermList> subRoleChains = new HashSet<ATermList>();
            this.computeSubRoles(role, subRoles, subRoleChains, subExplain, DependencySet.INDEPENDENT);
            role.setSubRolesAndChains(subRoles, subRoleChains, subExplain);
            for (Role s : subRoles) {
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                s.addSuperRole(role, explainSub);
            }
            for (ATermList chain : subRoleChains) {
                if (chain.getLength() == 2 && chain.getFirst().equals(chain.getLast()) && subRoles.contains(this.getRole(chain.getFirst()))) continue;
                role.setHasComplexSubRole(true);
                complexRoles.add(role);
                continue block0;
            }
        }
        for (Role s : complexRoles) {
            this.fsmBuilder.build(s);
        }
        for (Role role : this.roles.values()) {
            Role invR = role.getInverse();
            if (invR != null) {
                if (invR.isTransitive() && !role.isTransitive()) {
                    role.setTransitive(true, invR.getExplainTransitive());
                } else if (role.isTransitive() && !invR.isTransitive()) {
                    invR.setTransitive(true, role.getExplainTransitive());
                }
                if (invR.isFunctional() && !role.isInverseFunctional()) {
                    role.setInverseFunctional(true, invR.getExplainFunctional());
                }
                if (role.isFunctional() && !invR.isInverseFunctional()) {
                    invR.setInverseFunctional(true, role.getExplainFunctional());
                }
                if (invR.isInverseFunctional() && !role.isFunctional()) {
                    role.setFunctional(true, invR.getExplainInverseFunctional());
                }
                if (invR.isAsymmetric() && !role.isAsymmetric()) {
                    role.setAsymmetric(true, invR.getExplainAsymmetric());
                }
                if (role.isAsymmetric() && !invR.isAsymmetric()) {
                    invR.setAsymmetric(true, role.getExplainAsymmetric());
                }
                if (invR.isReflexive() && !role.isReflexive()) {
                    role.setReflexive(true, invR.getExplainReflexive());
                }
                if (role.isReflexive() && !invR.isReflexive()) {
                    invR.setReflexive(true, role.getExplainReflexive());
                }
                for (Role disjointR : role.getDisjointRoles()) {
                    invR.addDisjointRole(disjointR.getInverse(), role.getExplainDisjointRole(disjointR));
                }
            }
            for (Role s : role.getSubRoles()) {
                if (role.isForceSimple()) {
                    s.setForceSimple(true);
                }
                if (s.isSimple()) continue;
                role.setSimple(false);
            }
        }
        for (Role r : this.roles.values()) {
            if (r.isForceSimple()) {
                if (!r.isSimple()) {
                    this.ignoreTransitivity(r);
                }
            } else {
                boolean isTransitive = r.isTransitive();
                DependencySet transitiveDS = r.getExplainTransitive();
                for (Role s : r.getSubRoles()) {
                    if (!s.isTransitive()) continue;
                    if (r.isSubRoleOf(s) && r != s) {
                        isTransitive = true;
                        transitiveDS = r.getExplainSub((ATerm)s.getName()).union(s.getExplainTransitive(), true);
                    }
                    r.addTransitiveSubRole(s);
                }
                if (isTransitive != r.isTransitive()) {
                    r.setTransitive(isTransitive, transitiveDS);
                }
            }
            if (r.isFunctional()) {
                r.addFunctionalSuper(r);
            }
            for (Role s : r.getSuperRoles()) {
                DependencySet ds;
                DependencySet supDS;
                if (s.equals(r)) continue;
                DependencySet dependencySet = supDS = PelletOptions.USE_TRACING ? r.getExplainSuper((ATerm)s.getName()) : DependencySet.INDEPENDENT;
                if (s.isFunctional()) {
                    ds = PelletOptions.USE_TRACING ? supDS.union(s.getExplainFunctional(), true) : DependencySet.INDEPENDENT;
                    r.setFunctional(true, ds);
                    r.addFunctionalSuper(s);
                }
                if (s.isIrreflexive() && !r.isIrreflexive()) {
                    ds = PelletOptions.USE_TRACING ? supDS.union(s.getExplainIrreflexive(), true) : DependencySet.INDEPENDENT;
                    r.setIrreflexive(true, ds);
                }
                if (s.isAsymmetric() && !r.isAsymmetric()) {
                    ds = PelletOptions.USE_TRACING ? supDS.union(s.getExplainAsymmetric(), true) : DependencySet.INDEPENDENT;
                    r.setAsymmetric(true, ds);
                }
                for (Role disjointR : s.getDisjointRoles().toArray(new Role[0])) {
                    DependencySet ds2 = PelletOptions.USE_TRACING ? supDS.union(s.getExplainDisjointRole(disjointR), true) : DependencySet.INDEPENDENT;
                    r.addDisjointRole(disjointR, ds2);
                    disjointR.addDisjointRole(r, ds2);
                }
            }
            if (r.isReflexive() && !r.isAnon()) {
                this.reflexiveRoles.add(r);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(r.debugString());
        }
        this.objectTaxonomy = null;
        this.dataTaxonomy = null;
        this.annotationTaxonomy = null;
    }

    public void propagateDomainRange() {
        for (Role role : this.roles.values()) {
            role.resetDomainRange();
        }
        for (Role role : this.roles.values()) {
            Role invRole = role.getInverse();
            if (invRole != null) {
                Map<ATermAppl, Set<Set<ATermAppl>>> invDomains = this.domainAssertions.get(invRole);
                Map<ATermAppl, Set<Set<ATermAppl>>> invRanges = this.rangeAssertions.get(invRole);
                this.propogateDomain(role, invRanges);
                this.propogateRange(role, invDomains);
            }
            Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.domainAssertions.get(role);
            Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.rangeAssertions.get(role);
            this.propogateDomain(role, domains);
            this.propogateRange(role, ranges);
        }
    }

    private void propogateDomain(Role role, Map<ATermAppl, Set<Set<ATermAppl>>> domains) {
        if (domains == null || domains.isEmpty()) {
            return;
        }
        for (Map.Entry<ATermAppl, Set<Set<ATermAppl>>> e : domains.entrySet()) {
            Set<ATermAppl> explanation = e.getValue().iterator().next();
            ATermAppl domain = e.getKey();
            ATermAppl normalized = ATermUtils.normalize(domain);
            for (Role s : role.getSubRoles()) {
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                DependencySet ds = explainSub.union(explanation, true);
                s.addDomain(normalized, ds);
            }
        }
    }

    private void propogateRange(Role role, Map<ATermAppl, Set<Set<ATermAppl>>> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        for (Map.Entry<ATermAppl, Set<Set<ATermAppl>>> e : ranges.entrySet()) {
            Set<ATermAppl> explanation = e.getValue().iterator().next();
            ATermAppl range = e.getKey();
            ATermAppl normalized = ATermUtils.normalize(range);
            for (Role s : role.getSubRoles()) {
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                DependencySet ds = explainSub.union(explanation, true);
                s.addRange(normalized, ds);
            }
        }
    }

    public boolean removeDomain(ATerm p, ATermAppl domain) {
        if (!PelletOptions.USE_TRACING) {
            return false;
        }
        Role r = this.getRole(p);
        if (r == null) {
            return false;
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.domainAssertions.get(r);
        if (domains == null) {
            return false;
        }
        Set<Set<ATermAppl>> allExplanations = domains.get(domain);
        if (allExplanations == null) {
            return false;
        }
        Set<ATermAppl> explanation = Collections.singleton(ATermUtils.makeDomain(p, (ATerm)domain));
        if (!allExplanations.remove(explanation)) {
            return false;
        }
        if (allExplanations.isEmpty()) {
            domains.remove(domain);
        }
        return true;
    }

    public boolean removeRange(ATerm p, ATermAppl range) {
        if (!PelletOptions.USE_TRACING) {
            return false;
        }
        Role r = this.getRole(p);
        if (r == null) {
            return false;
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.rangeAssertions.get(r);
        if (ranges == null) {
            return false;
        }
        Set<Set<ATermAppl>> allExplanations = ranges.get(range);
        if (allExplanations == null) {
            return false;
        }
        Set<ATermAppl> explanation = Collections.singleton(ATermUtils.makeRange(p, (ATerm)range));
        if (!allExplanations.remove(explanation)) {
            return false;
        }
        if (allExplanations.isEmpty()) {
            ranges.remove(range);
        }
        return true;
    }

    void ignoreTransitivity(Role role) {
        Role namedRole = role.isAnon() ? role.getInverse() : role;
        String msg = "Unsupported axiom: Ignoring transitivity and/or complex subproperty axioms for " + namedRole;
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        log.warning(msg);
        role.removeSubRoleChains();
        role.setHasComplexSubRole(false);
        role.setSimple(true);
        role.setFSM(null);
        role.getInverse().removeSubRoleChains();
        role.getInverse().setHasComplexSubRole(false);
        role.getInverse().setSimple(true);
        role.getInverse().setFSM(null);
    }

    private void computeImmediateSubRoles(Role r, Map<ATerm, DependencySet> subs) {
        DependencySet subDS;
        Role invR = r.getInverse();
        if (invR != null && invR != r) {
            for (Role invSubR : invR.getSubRoles()) {
                Role subR = invSubR.getInverse();
                if (subR == null) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Property " + invSubR + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                if (subR == r) continue;
                DependencySet subDS2 = invR.getExplainSub((ATerm)invSubR.getName());
                subs.put((ATerm)subR.getName(), subDS2);
            }
            for (ATermList roleChain : invR.getSubRoleChains()) {
                subDS = invR.getExplainSub((ATerm)roleChain);
                ATermList subChain = this.inverse(roleChain);
                subs.put((ATerm)subChain, subDS);
            }
        }
        for (Role sub : r.getSubRoles()) {
            subDS = r.getExplainSub((ATerm)sub.getName());
            subs.put((ATerm)sub.getName(), subDS);
        }
        for (ATermList subChain : r.getSubRoleChains()) {
            subDS = r.getExplainSub((ATerm)subChain);
            subs.put((ATerm)subChain, subDS);
        }
    }

    private void computeSubRoles(Role r, Set<Role> subRoles, Set<ATermList> subRoleChains, Map<ATerm, DependencySet> dependencies, DependencySet ds) {
        if (subRoles.contains(r)) {
            return;
        }
        subRoles.add(r);
        dependencies.put((ATerm)r.getName(), ds);
        HashMap<ATerm, DependencySet> immSubs = new HashMap<ATerm, DependencySet>();
        this.computeImmediateSubRoles(r, immSubs);
        for (Map.Entry entry : immSubs.entrySet()) {
            DependencySet subDS;
            ATerm sub = (ATerm)entry.getKey();
            DependencySet dependencySet = subDS = PelletOptions.USE_TRACING ? ds.union((DependencySet)entry.getValue(), true) : DependencySet.INDEPENDENT;
            if (sub instanceof ATermAppl) {
                Role subRole = this.getRole(sub);
                this.computeSubRoles(subRole, subRoles, subRoleChains, dependencies, subDS);
                continue;
            }
            subRoleChains.add((ATermList)sub);
            dependencies.put(sub, subDS);
        }
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public ATermList inverse(ATermList roles) {
        ATermList invList = ATermUtils.EMPTY_LIST;
        ATermList list = roles;
        while (!list.isEmpty()) {
            ATermAppl r = (ATermAppl)list.getFirst();
            Role role = this.getRole((ATerm)r);
            Role invR = role.getInverse();
            if (invR == null) {
                System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
            } else {
                invList = invList.insert((ATerm)invR.getName());
            }
            list = list.getNext();
        }
        return invList;
    }

    public Set<ATermAppl> getRoleNames() {
        return this.roles.keySet();
    }

    public Set<Role> getReflexiveRoles() {
        return this.reflexiveRoles;
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    public Taxonomy<ATermAppl> getObjectTaxonomy() {
        if (this.objectTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, PropertyType.OBJECT);
            this.objectTaxonomy = builder.classify();
        }
        return this.objectTaxonomy;
    }

    public Taxonomy<ATermAppl> getDataTaxonomy() {
        if (this.dataTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, PropertyType.DATATYPE);
            this.dataTaxonomy = builder.classify();
        }
        return this.dataTaxonomy;
    }

    public Taxonomy<ATermAppl> getAnnotationTaxonomy() {
        if (this.annotationTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, PropertyType.ANNOTATION);
            if (PelletOptions.USE_ANNOTATION_SUPPORT) {
                this.annotationTaxonomy = builder.classify();
            }
        }
        return this.annotationTaxonomy;
    }

    public boolean isObjectTaxonomyPrepared() {
        return this.objectTaxonomy != null;
    }

    public boolean isDataTaxonomyPrepared() {
        return this.dataTaxonomy != null;
    }

    public boolean isAnnotationTaxonomyPrepared() {
        return this.annotationTaxonomy != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DomainRangeIterator
    extends FilterIterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>> {
        final ATermAppl p;
        final boolean isDomain;

        public DomainRangeIterator(Map<ATermAppl, Set<Set<ATermAppl>>> map, Role role, boolean isDomain) {
            super(map.entrySet().iterator());
            this.p = role.getName();
            this.isDomain = isDomain;
        }

        @Override
        public boolean filter(Map.Entry<ATermAppl, Set<Set<ATermAppl>>> entry) {
            Set<Set<ATermAppl>> allExplanations = entry.getValue();
            Set<ATermAppl> explanation = Collections.singleton(this.isDomain ? ATermUtils.makeDomain((ATerm)this.p, (ATerm)entry.getKey()) : ATermUtils.makeRange((ATerm)this.p, (ATerm)entry.getKey()));
            return !allExplanations.contains(explanation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueIterator
    extends MapIterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>, ATermAppl> {
        public ValueIterator(Iterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>> iterator) {
            super(iterator);
        }

        @Override
        public ATermAppl map(Map.Entry<ATermAppl, Set<Set<ATermAppl>>> e) {
            return e.getKey();
        }
    }
}

