/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.cache.CacheSafety;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSafetyDynamic
implements CacheSafety {
    private final Expressivity expressivity;

    CacheSafetyDynamic(Expressivity e) {
        this.expressivity = new Expressivity(e);
    }

    @Override
    public boolean canSupport(Expressivity expressivity) {
        return !expressivity.hasNominal() && ((Object)this.expressivity.getAnonInverses()).equals(expressivity.getAnonInverses());
    }

    @Override
    public boolean isSafe(ATermAppl c, Individual ind) {
        Edge parentEdge = this.getParentEdge(ind);
        Role r = parentEdge.getRole();
        Individual parent = parentEdge.getFrom();
        ABox abox = parent.getABox();
        if (!this.isParentSafe(abox.getKB(), r, parent)) {
            return false;
        }
        Iterator<CachedNode> nodes = this.getCachedNodes(abox, c);
        if (!nodes.hasNext()) {
            return false;
        }
        if (this.interactsWithInverses(abox.getKB(), r)) {
            while (nodes.hasNext()) {
                CachedNode node = nodes.next();
                if (node.isBottom()) {
                    return true;
                }
                if (node.isTop() || !node.isComplete()) {
                    return false;
                }
                if (this.isSafe(abox.getKB(), parent, r.getInverse(), node)) continue;
                return false;
            }
        }
        return true;
    }

    protected Edge getParentEdge(Individual ind) {
        Edge result = null;
        Role role = null;
        Individual parent = ind.getParent();
        for (Edge e : ind.getInEdges()) {
            if (!e.getFrom().equals(parent)) continue;
            if (role == null) {
                role = e.getRole();
                result = e;
                continue;
            }
            if (!e.getRole().isSubRoleOf(role)) continue;
            role = e.getRole();
            result = e;
        }
        assert (result != null);
        return result;
    }

    protected Iterator<CachedNode> getCachedNodes(ABox abox, ATermAppl c) {
        CachedNode node = abox.getCached(c);
        if (node != null) {
            return IteratorUtils.singleton(node);
        }
        if (ATermUtils.isAnd(c)) {
            ATermList list = (ATermList)c.getArgument(0);
            CachedNode[] nodes = new CachedNode[list.getLength()];
            int i = 0;
            while (!list.isEmpty()) {
                ATermAppl d = (ATermAppl)list.getFirst();
                node = abox.getCached(d);
                if (node == null) {
                    return IteratorUtils.emptyIterator();
                }
                if (node.isBottom()) {
                    return IteratorUtils.singleton(node);
                }
                nodes[i++] = node;
                list = list.getNext();
            }
            return IteratorUtils.iterator(nodes);
        }
        return IteratorUtils.emptyIterator();
    }

    private boolean isParentSafe(KnowledgeBase kb, Role role, Individual parent) {
        return this.isParentFunctionalSafe(role, parent) && this.isParentMaxSafe(kb, role, parent);
    }

    private boolean isParentFunctionalSafe(Role role, Individual parent) {
        return !role.isFunctional() || parent.getRNeighbors(role).size() <= 1;
    }

    private boolean isParentMaxSafe(KnowledgeBase kb, Role role, Individual parent) {
        for (ATermAppl negatedMax : parent.getTypes(5)) {
            ATermAppl max = (ATermAppl)negatedMax.getArgument(0);
            if (this.isParentMaxSafe(kb, role, max)) continue;
            return false;
        }
        return true;
    }

    private boolean isParentMaxSafe(KnowledgeBase kb, Role role, ATermAppl max) {
        Role maxR = kb.getRole(max.getArgument(0));
        return !role.isSubRoleOf(maxR);
    }

    private boolean isSafe(KnowledgeBase kb, Individual parent, Role role, CachedNode node) {
        if (!this.isFunctionalSafe(role, node)) {
            return false;
        }
        for (ATermAppl c : node.getDepends().keySet()) {
            ATermAppl arg;
            if (!(ATermUtils.isAllValues(c) ? !this.isAllValuesSafe(kb, parent, role, c) : ATermUtils.isNot(c) && ATermUtils.isMin(arg = (ATermAppl)c.getArgument(0)) && !this.isMaxSafe(kb, role, arg))) continue;
            return false;
        }
        return true;
    }

    private boolean isAllValuesSafe(KnowledgeBase kb, Individual parent, Role role, ATermAppl term) {
        Role s = kb.getRole(term.getArgument(0));
        if (!s.hasComplexSubRole()) {
            ATermAppl c = (ATermAppl)term.getArgument(1);
            if (role.isSubRoleOf(s) && !parent.hasType((ATerm)c)) {
                return false;
            }
        } else {
            TransitionGraph<Role> tg = s.getFSM();
            for (Transition<Role> t : tg.getInitialState().getTransitions()) {
                if (!role.isSubRoleOf(t.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFunctionalSafe(Role role, CachedNode node) {
        return !role.isFunctional() || this.getRNeighbors(node, role).isEmpty();
    }

    private boolean isMaxSafe(KnowledgeBase kb, Role role, ATermAppl term) {
        Role maxR = kb.getRole(term.getArgument(0));
        return !role.isSubRoleOf(maxR);
    }

    private Set<ATermAppl> getRNeighbors(CachedNode node, Role role) {
        Role r;
        HashSet<ATermAppl> neighbors = new HashSet<ATermAppl>();
        for (Edge edge : node.getOutEdges()) {
            r = edge.getRole();
            if (!r.isSubRoleOf(role)) continue;
            neighbors.add(edge.getToName());
        }
        if (role.isObjectRole()) {
            role = role.getInverse();
            for (Edge edge : node.getInEdges()) {
                r = edge.getRole();
                if (!r.isSubRoleOf(role)) continue;
                neighbors.add(edge.getFromName());
            }
        }
        return neighbors;
    }

    protected boolean interactsWithInverses(KnowledgeBase kb, Role role) {
        if (this.interactsWithInversesSimple(role)) {
            return true;
        }
        return this.expressivity.hasComplexSubRoles() && this.interactsWithInversesComplex(kb, role);
    }

    protected boolean interactsWithInversesSimple(Role role) {
        for (Role superRole : role.getSuperRoles()) {
            if (!this.hasAnonInverse(superRole)) continue;
            return true;
        }
        return false;
    }

    protected boolean interactsWithInversesComplex(KnowledgeBase kb, Role role) {
        for (ATermAppl p : this.expressivity.getAnonInverses()) {
            Role anonRole = kb.getRole((ATerm)p);
            if (!anonRole.hasComplexSubRole() || !anonRole.getFSM().getAlpahabet().contains(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnonInverse(Role role) {
        return !role.isBuiltin() && (role.isAnon() || this.expressivity.getAnonInverses().contains(role.getName()));
    }
}

