/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import java.util.logging.Logger;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;

public abstract class AbstractTableauRule
implements TableauRule {
    public static final Logger log = Logger.getLogger(AbstractTableauRule.class.getName());
    protected CompletionStrategy strategy;
    protected NodeSelector nodeSelector;
    protected BlockingType blockingType;

    public AbstractTableauRule(CompletionStrategy strategy, NodeSelector nodeSelector, BlockingType blockingType) {
        this.strategy = strategy;
        this.nodeSelector = nodeSelector;
        this.blockingType = blockingType;
    }

    public boolean isDisabled() {
        return false;
    }

    public void apply(IndividualIterator i) {
        i.reset(this.nodeSelector);
        while (i.hasNext()) {
            Individual node = i.next();
            if (this.strategy.getBlocking().isBlocked(node)) {
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.addQueueElement(node);
                continue;
            }
            this.apply(node);
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }

    protected boolean isBlocked(Individual node) {
        switch (this.blockingType) {
            case NONE: {
                return false;
            }
            case DIRECT: {
                return this.strategy.getBlocking().isDirectlyBlocked(node);
            }
            case INDIRECT: {
                return this.strategy.getBlocking().isIndirectlyBlocked(node);
            }
            case COMPLETE: {
                return this.strategy.getBlocking().isBlocked(node);
            }
        }
        throw new AssertionError();
    }

    protected void addQueueElement(Node node) {
        this.strategy.getABox().getCompletionQueue().add(new QueueElement(node), this.nodeSelector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum BlockingType {
        NONE,
        DIRECT,
        INDIRECT,
        COMPLETE;

    }
}

